/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer;

import de.maxhenkel.audioplayer.AudioManager;
import de.maxhenkel.audioplayer.AudioPlayer;
import de.maxhenkel.voicechat.api.Player;
import de.maxhenkel.voicechat.api.VoicechatConnection;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import de.maxhenkel.voicechat.api.audiochannel.AudioChannel;
import de.maxhenkel.voicechat.api.audiochannel.LocationalAudioChannel;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_124;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class PlayerManager {
    private final Map<UUID, de.maxhenkel.voicechat.api.audiochannel.AudioPlayer> players = new ConcurrentHashMap<UUID, de.maxhenkel.voicechat.api.audiochannel.AudioPlayer>();
    private static PlayerManager instance;

    @Nullable
    public UUID play(VoicechatServerApi api, class_3218 level, class_2338 pos, UUID sound, @Nullable class_3222 p) {
        UUID channelID = UUID.randomUUID();
        LocationalAudioChannel channel = api.createLocationalAudioChannel(channelID, api.fromServerLevel((Object)level), api.createPosition((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5));
        if (channel == null) {
            return null;
        }
        api.getPlayersInRange(api.fromServerLevel((Object)level), channel.getLocation(), api.getBroadcastRange(), serverPlayer -> {
            VoicechatConnection connection = api.getConnectionOf(serverPlayer);
            if (connection != null) {
                return connection.isDisabled();
            }
            return true;
        }).stream().map(Player::getPlayer).map(class_3222.class::cast).forEach(player -> player.method_7353((class_2561)class_2561.method_43470((String)"You need to enable voice chat to hear this music disc"), true));
        try {
            de.maxhenkel.voicechat.api.audiochannel.AudioPlayer player2 = api.createAudioPlayer((AudioChannel)channel, api.createEncoder(), AudioManager.getSound(level.method_8503(), sound));
            this.players.put(channelID, player2);
            player2.startPlaying();
        }
        catch (Exception e) {
            AudioPlayer.LOGGER.error("Failed to play audio: {}", (Object)e.getMessage());
            if (p != null) {
                p.method_7353((class_2561)class_2561.method_43470((String)"Failed to play audio: %s".formatted(e.getMessage())).method_27692(class_124.field_1079), true);
            }
            return null;
        }
        return channelID;
    }

    public void stop(UUID channelID) {
        de.maxhenkel.voicechat.api.audiochannel.AudioPlayer player = this.players.get(channelID);
        if (player != null) {
            player.stopPlaying();
        }
    }

    public static PlayerManager instance() {
        if (instance == null) {
            instance = new PlayerManager();
        }
        return instance;
    }
}

