/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer;

import de.maxhenkel.audioplayer.AudioPlayer;
import de.maxhenkel.audioplayer.PlayerManager;
import de.maxhenkel.audioplayer.Plugin;
import de.maxhenkel.audioplayer.interfaces.IJukebox;
import de.maxhenkel.voicechat.api.VoicechatServerApi;
import java.io.ByteArrayInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.UUID;
import javax.annotation.Nullable;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.UnsupportedAudioFileException;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.io.IOUtils;

public class AudioManager {
    public static class_5218 AUDIO_DATA = new class_5218("audio_player_data");
    public static AudioFormat FORMAT = new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, 48000.0f, 16, 1, 2, 48000.0f, false);

    public static short[] getSound(MinecraftServer server, UUID id) throws IOException, UnsupportedAudioFileException {
        Path soundFile = AudioManager.getSoundFile(server, id);
        if (!Files.exists(soundFile, new LinkOption[0])) {
            throw new FileNotFoundException("Sound does not exist");
        }
        return AudioManager.readSound(soundFile);
    }

    public static short[] readSound(Path file) throws IOException, UnsupportedAudioFileException {
        AudioInputStream in = AudioSystem.getAudioInputStream(file.toFile());
        AudioInputStream convertedIn = AudioSystem.getAudioInputStream(FORMAT, in);
        return Plugin.voicechatApi.getAudioConverter().bytesToShorts(convertedIn.readAllBytes());
    }

    public static Path getSoundFile(MinecraftServer server, UUID id) {
        return server.method_27050(AUDIO_DATA).resolve(id.toString() + ".wav");
    }

    public static void saveSound(MinecraftServer server, UUID id, String url) throws UnsupportedAudioFileException, IOException {
        Path soundFile = AudioManager.getSoundFile(server, id);
        if (Files.exists(soundFile, new LinkOption[0])) {
            throw new FileAlreadyExistsException("This audio already exists");
        }
        Files.createDirectories(soundFile.getParent(), new FileAttribute[0]);
        byte[] data = IOUtils.toByteArray((URL)new URL(url));
        if (data.length > AudioPlayer.SERVER_CONFIG.maxUploadSize.get()) {
            throw new IOException("Maximum file size exceeded (%sMB>%sMB)".formatted(Float.valueOf((float)data.length / 1000000.0f), Float.valueOf(AudioPlayer.SERVER_CONFIG.maxUploadSize.get().floatValue() / 1000000.0f)));
        }
        AudioSystem.write(AudioSystem.getAudioInputStream(new ByteArrayInputStream(data)), AudioFileFormat.Type.WAVE, Files.newOutputStream(soundFile, StandardOpenOption.CREATE_NEW));
    }

    @Nullable
    public static UUID getCustomSound(class_1799 itemStack) {
        class_2487 tag = itemStack.method_7969();
        if (tag == null || !tag.method_25928("CustomSound")) {
            return null;
        }
        return tag.method_25926("CustomSound");
    }

    public static boolean playCustomMusicDisc(class_3218 level, class_2338 pos, class_1799 musicDisc, @Nullable class_1657 player) {
        class_3222 p;
        UUID customSound = AudioManager.getCustomSound(musicDisc);
        if (customSound == null) {
            return false;
        }
        VoicechatServerApi api = Plugin.voicechatServerApi;
        if (api == null) {
            return false;
        }
        UUID channelID = PlayerManager.instance().play(api, level, pos, customSound, player instanceof class_3222 ? (p = (class_3222)player) : null);
        class_2586 class_25862 = level.method_8321(pos);
        if (class_25862 instanceof IJukebox) {
            IJukebox jukebox = (IJukebox)class_25862;
            jukebox.setChannelID(channelID);
        }
        return true;
    }
}

