/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.properties;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterators;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.function.IntPredicate;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import me.pepperbell.continuity.api.client.CTMProperties;
import me.pepperbell.continuity.api.client.CTMPropertiesFactory;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.properties.PropertiesParsingHelper;
import me.pepperbell.continuity.client.resource.InvalidIdentifierStateHolder;
import me.pepperbell.continuity.client.resource.ResourcePackUtil;
import me.pepperbell.continuity.client.resource.ResourceRedirectHandler;
import me.pepperbell.continuity.client.util.BooleanState;
import me.pepperbell.continuity.client.util.MathUtil;
import me.pepperbell.continuity.client.util.TextureUtil;
import me.pepperbell.continuity.client.util.biome.BiomeHolder;
import me.pepperbell.continuity.client.util.biome.BiomeHolderManager;
import net.minecraft.class_151;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3268;
import net.minecraft.class_4730;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.jetbrains.annotations.NotNull;

public class BaseCTMProperties
implements CTMProperties {
    public static final class_2960 SPECIAL_SKIP_ID = ContinuityClient.asId("special/skip");
    public static final class_2960 SPECIAL_DEFAULT_ID = ContinuityClient.asId("special/default");
    public static final class_4730 SPECIAL_SKIP_SPRITE_ID = TextureUtil.toSpriteId(SPECIAL_SKIP_ID);
    public static final class_4730 SPECIAL_DEFAULT_SPRITE_ID = TextureUtil.toSpriteId(SPECIAL_DEFAULT_ID);
    protected Properties properties;
    protected class_2960 id;
    protected String packName;
    protected int packPriority;
    protected String method;
    protected Set<class_2960> matchTilesSet;
    protected Predicate<class_2680> matchBlocksPredicate;
    protected int weight = 0;
    protected List<class_2960> tiles;
    protected EnumSet<class_2350> faces;
    protected Predicate<class_1959> biomePredicate;
    protected IntPredicate heightPredicate;
    protected Predicate<String> blockEntityNamePredicate;
    protected boolean valid = true;
    protected Set<class_4730> textureDependencies;
    protected List<class_4730> spriteIds;

    public BaseCTMProperties(Properties properties, class_2960 id, String packName, int packPriority, String method) {
        this.properties = properties;
        this.id = id;
        this.packName = packName;
        this.packPriority = packPriority;
        this.method = method;
    }

    @Override
    public boolean affectsTextures() {
        return this.matchTilesSet != null;
    }

    @Override
    public boolean affectsTexture(class_2960 id) {
        if (this.matchTilesSet != null) {
            return this.matchTilesSet.contains(id);
        }
        return false;
    }

    @Override
    public boolean affectsBlockStates() {
        return this.matchBlocksPredicate != null;
    }

    @Override
    public boolean affectsBlockState(class_2680 state) {
        if (this.matchBlocksPredicate != null) {
            return this.matchBlocksPredicate.test(state);
        }
        return false;
    }

    public Set<class_4730> getTextureDependencies() {
        if (this.textureDependencies == null) {
            this.resolveTiles();
        }
        return this.textureDependencies;
    }

    @Override
    public int compareTo(@NotNull CTMProperties o) {
        int c;
        BaseCTMProperties o1;
        if (o instanceof BaseCTMProperties) {
            o1 = (BaseCTMProperties)o;
            c = MathUtil.signum(this.weight - o1.weight);
            if (c != 0) {
                return c;
            }
        }
        if (this.affectsTextures() && !o.affectsTextures()) {
            return 1;
        }
        if (!this.affectsTextures() && o.affectsTextures()) {
            return -1;
        }
        if (o instanceof BaseCTMProperties) {
            o1 = (BaseCTMProperties)o;
            c = MathUtil.signum(this.packPriority - o1.packPriority);
            if (c != 0) {
                return c;
            }
            return o1.getId().method_12833(this.getId());
        }
        return 0;
    }

    public void init() {
        this.parseMatchTiles();
        this.parseMatchBlocks();
        this.detectMatches();
        this.validateMatches();
        this.parseWeight();
        this.parseTiles();
        this.validateTiles();
        this.parseFaces();
        this.parseBiomes();
        this.parseHeights();
        this.parseName();
        this.parseResourceCondition();
    }

    protected void parseMatchTiles() {
        this.matchTilesSet = PropertiesParsingHelper.parseMatchTiles(this.properties, "matchTiles", this.id, this.packName, true);
    }

    protected void parseMatchBlocks() {
        this.matchBlocksPredicate = PropertiesParsingHelper.parseBlockStates(this.properties, "matchBlocks", this.id, this.packName, true);
    }

    protected void detectMatches() {
        String baseName = FilenameUtils.getBaseName((String)this.id.method_12832());
        if (this.matchBlocksPredicate == null && baseName.startsWith("block_")) {
            try {
                class_2960 id = new class_2960(baseName.substring(6));
                class_2248 block = (class_2248)class_2378.field_11146.method_10223(id);
                if (block != class_2246.field_10124) {
                    this.matchBlocksPredicate = state -> state.method_26204() == block;
                }
            }
            catch (class_151 class_1512) {
                // empty catch block
            }
        }
    }

    protected void validateMatches() {
        if (this.matchTilesSet == null && this.matchBlocksPredicate == null) {
            ContinuityClient.LOGGER.error("No tile or block matches provided in file '" + this.id + "' in pack '" + this.packName + "'");
            this.valid = false;
        }
    }

    protected void parseWeight() {
        String weightStr = this.properties.getProperty("weight");
        if (weightStr != null) {
            weightStr = weightStr.trim();
            try {
                this.weight = Integer.parseInt(weightStr);
            }
            catch (NumberFormatException e) {
                ContinuityClient.LOGGER.warn("Invalid 'weight' value '" + weightStr + "' in file '" + this.id + "' in pack '" + this.packName + "'");
            }
        }
    }

    protected void parseTiles() {
        String[] tileStrs;
        String tilesStr = this.properties.getProperty("tiles");
        if (tilesStr != null && (tileStrs = (tilesStr = tilesStr.trim()).split("[ ,]")).length != 0) {
            String basePath = FilenameUtils.getPath((String)this.id.method_12832());
            ImmutableList.Builder listBuilder = ImmutableList.builder();
            BooleanState invalidIdentifierState = InvalidIdentifierStateHolder.get();
            invalidIdentifierState.enable();
            for (int i = 0; i < tileStrs.length; ++i) {
                Object path;
                String namespace;
                String tileStr = tileStrs[i];
                if (tileStr.isEmpty()) continue;
                if (tileStr.endsWith("<skip>") || tileStr.endsWith("<skip>.png")) {
                    listBuilder.add((Object)SPECIAL_SKIP_ID);
                    continue;
                }
                if (tileStr.endsWith("<default>") || tileStr.endsWith("<default>.png")) {
                    listBuilder.add((Object)SPECIAL_DEFAULT_ID);
                    continue;
                }
                if (tileStr.contains("-")) {
                    String[] tileStrRange = tileStr.split("-");
                    if (tileStrRange.length != 2) continue;
                    try {
                        int min = Integer.parseInt(tileStrRange[0]);
                        int max = Integer.parseInt(tileStrRange[1]);
                        if (min <= max) {
                            for (int t = min; t <= max; ++t) {
                                listBuilder.add((Object)new class_2960(this.id.method_12836(), basePath + t + ".png"));
                            }
                            continue;
                        }
                    }
                    catch (NumberFormatException min) {
                        // empty catch block
                    }
                    ContinuityClient.LOGGER.warn("Invalid 'tiles' element '" + tileStr + "' at index " + i + " in file '" + this.id + "' in pack '" + this.packName + "'");
                    continue;
                }
                String[] parts = tileStr.split(":", 2);
                if (parts.length == 0) continue;
                if (parts.length > 1) {
                    namespace = parts[0];
                    path = parts[1];
                } else {
                    namespace = this.id.method_12836();
                    path = parts[0];
                }
                if (!((String)path).endsWith(".png")) {
                    path = (String)path + ".png";
                }
                if (((String)path).startsWith("./")) {
                    path = basePath + ((String)path).substring(2);
                } else if (((String)path).startsWith("~/")) {
                    path = "optifine/" + ((String)path).substring(2);
                } else if (((String)path).startsWith("/")) {
                    path = "optifine/" + ((String)path).substring(1);
                } else if (!((String)path).startsWith("textures/") && !((String)path).startsWith("optifine/")) {
                    path = basePath + (String)path;
                }
                listBuilder.add((Object)new class_2960(namespace, (String)path));
            }
            invalidIdentifierState.disable();
            ImmutableList list = listBuilder.build();
            if (!list.isEmpty()) {
                this.tiles = list;
            }
        }
    }

    protected void validateTiles() {
        if (this.tiles == null) {
            ContinuityClient.LOGGER.error("No tiles provided in file '" + this.id + "' in pack '" + this.packName + "'");
            this.valid = false;
        }
    }

    protected void parseFaces() {
        String[] faceStrs;
        String facesStr = this.properties.getProperty("faces");
        if (facesStr != null && (faceStrs = (facesStr = facesStr.trim()).split("[ ,]")).length != 0) {
            for (int i = 0; i < faceStrs.length; ++i) {
                String faceStr = faceStrs[i];
                if (faceStr.isEmpty()) continue;
                if ((faceStr = faceStr.toUpperCase(Locale.ROOT)).equals("BOTTOM")) {
                    faceStr = "DOWN";
                } else if (faceStr.equals("TOP")) {
                    faceStr = "UP";
                }
                try {
                    class_2350 direction = class_2350.valueOf((String)faceStr);
                    if (this.faces == null) {
                        this.faces = EnumSet.noneOf(class_2350.class);
                    }
                    this.faces.add(direction);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    if (faceStr.equals("SIDES")) {
                        if (this.faces == null) {
                            this.faces = EnumSet.noneOf(class_2350.class);
                        }
                        Iterators.addAll(this.faces, (Iterator)class_2350.class_2353.field_11062.iterator());
                        continue;
                    }
                    if (faceStr.equals("ALL")) {
                        this.faces = null;
                        return;
                    }
                    ContinuityClient.LOGGER.warn("Unknown 'faces' element '" + faceStr + "' at index " + i + " in file '" + this.id + "' in pack '" + this.packName + "'");
                }
            }
        }
    }

    protected void parseBiomes() {
        String biomesStr = this.properties.getProperty("biomes");
        if (biomesStr != null) {
            String[] biomeStrs;
            biomesStr = biomesStr.trim();
            boolean negate = false;
            if (biomesStr.charAt(0) == '!') {
                negate = true;
                biomesStr = biomesStr.substring(1);
            }
            if ((biomeStrs = biomesStr.split(" ")).length != 0) {
                ImmutableSet.Builder setBuilder = ImmutableSet.builder();
                for (int i = 0; i < biomeStrs.length; ++i) {
                    String biomeStr = biomeStrs[i];
                    if (biomeStr.isEmpty()) continue;
                    try {
                        class_2960 biomeId = new class_2960(biomeStr.toLowerCase(Locale.ROOT));
                        setBuilder.add((Object)BiomeHolderManager.getOrCreateHolder(biomeId));
                        continue;
                    }
                    catch (class_151 e) {
                        ContinuityClient.LOGGER.warn("Invalid 'biomes' element '" + biomeStr + "' at index " + i + " in file '" + this.id + "' in pack '" + this.packName + "'", (Throwable)e);
                    }
                }
                ImmutableSet set = setBuilder.build();
                if (!set.isEmpty()) {
                    this.biomePredicate = biome -> {
                        for (BiomeHolder holder : set) {
                            if (holder.getBiome() != biome) continue;
                            return true;
                        }
                        return false;
                    };
                    if (negate) {
                        this.biomePredicate = this.biomePredicate.negate();
                    }
                }
            }
        }
    }

    protected void parseHeights() {
        String[] heightStrs;
        String heightsStr = this.properties.getProperty("heights");
        if (heightsStr != null && (heightStrs = (heightsStr = heightsStr.trim()).split("[ ,]")).length != 0) {
            ImmutableList.Builder predicateListBuilder = ImmutableList.builder();
            for (int i = 0; i < heightStrs.length; ++i) {
                String heightStr = heightStrs[i];
                if (heightStr.isEmpty()) continue;
                String[] parts = heightStr.split("\\.\\.", 2);
                if (parts.length > 1) {
                    try {
                        int max;
                        int min;
                        if (parts[1].isEmpty()) {
                            min = Integer.parseInt(parts[0]);
                            predicateListBuilder.add(y -> y >= min);
                            continue;
                        }
                        if (parts[0].isEmpty()) {
                            int max2 = Integer.parseInt(parts[1]);
                            predicateListBuilder.add(y -> y <= max2);
                            continue;
                        }
                        min = Integer.parseInt(parts[0]);
                        if (min < (max = Integer.parseInt(parts[1]))) {
                            predicateListBuilder.add(y -> y >= min && y <= max);
                            continue;
                        }
                        if (min > max) {
                            predicateListBuilder.add(y -> y >= max && y <= min);
                            continue;
                        }
                        predicateListBuilder.add(y -> y == min);
                        continue;
                    }
                    catch (NumberFormatException min) {
                    }
                } else {
                    String heightStr1 = heightStr.replaceAll("[()]", "");
                    if (!heightStr1.isEmpty()) {
                        int separatorIndex = heightStr1.indexOf(45, heightStr1.charAt(0) == '-' ? 1 : 0);
                        try {
                            int max;
                            if (separatorIndex == -1) {
                                int height = Integer.parseInt(heightStr1);
                                predicateListBuilder.add(y -> y == height);
                                continue;
                            }
                            int min = Integer.parseInt(heightStr1.substring(0, separatorIndex));
                            if (min < (max = Integer.parseInt(heightStr1.substring(separatorIndex + 1)))) {
                                predicateListBuilder.add(y -> y >= min && y <= max);
                                continue;
                            }
                            if (min > max) {
                                predicateListBuilder.add(y -> y >= max && y <= min);
                                continue;
                            }
                            predicateListBuilder.add(y -> y == min);
                            continue;
                        }
                        catch (NumberFormatException min) {
                            // empty catch block
                        }
                    }
                }
                ContinuityClient.LOGGER.warn("Invalid 'heights' element '" + heightStr + "' at index " + i + " in file '" + this.id + "' in pack '" + this.packName + "'");
            }
            ImmutableList predicateList = predicateListBuilder.build();
            if (!predicateList.isEmpty()) {
                int amount = predicateList.size();
                this.heightPredicate = y -> {
                    for (int i = 0; i < amount; ++i) {
                        if (!((IntPredicate)predicateList.get(i)).test(y)) continue;
                        return true;
                    }
                    return false;
                };
            }
        }
        if (this.heightPredicate == null) {
            boolean hasMaxHeight;
            String minHeightStr = this.properties.getProperty("minHeight");
            String maxHeightStr = this.properties.getProperty("maxHeight");
            boolean hasMinHeight = minHeightStr != null;
            boolean bl = hasMaxHeight = maxHeightStr != null;
            if (hasMinHeight || hasMaxHeight) {
                int min = 0;
                int max = 0;
                if (hasMinHeight) {
                    minHeightStr = minHeightStr.trim();
                    try {
                        min = Integer.parseInt(minHeightStr);
                    }
                    catch (NumberFormatException e) {
                        hasMinHeight = false;
                        ContinuityClient.LOGGER.warn("Invalid 'minHeight' value '" + minHeightStr + "' in file '" + this.id + "' in pack '" + this.packName + "'");
                    }
                }
                if (hasMaxHeight) {
                    maxHeightStr = maxHeightStr.trim();
                    try {
                        max = Integer.parseInt(maxHeightStr);
                    }
                    catch (NumberFormatException e) {
                        hasMaxHeight = false;
                        ContinuityClient.LOGGER.warn("Invalid 'maxHeight' value '" + minHeightStr + "' in file '" + this.id + "' in pack '" + this.packName + "'");
                    }
                }
                int finalMin = min;
                int finalMax = max;
                if (hasMinHeight && hasMaxHeight) {
                    this.heightPredicate = finalMin < finalMax ? y -> y >= finalMin && y <= finalMax : (finalMin > finalMax ? y -> y >= finalMax && y <= finalMin : y -> y == finalMin);
                } else if (hasMinHeight) {
                    this.heightPredicate = y -> y >= finalMin;
                } else if (hasMaxHeight) {
                    this.heightPredicate = y -> y <= finalMax;
                }
            }
        }
    }

    protected void parseName() {
        String nameStr = this.properties.getProperty("name");
        if (nameStr != null) {
            nameStr = nameStr.trim();
            nameStr = StringEscapeUtils.escapeJava((String)nameStr);
            boolean isPattern = false;
            boolean caseInsensitive = false;
            if (nameStr.startsWith("regex:")) {
                nameStr = nameStr.substring(6);
            } else if (nameStr.startsWith("iregex:")) {
                nameStr = nameStr.substring(7);
                caseInsensitive = true;
            } else if (nameStr.startsWith("pattern:")) {
                nameStr = nameStr.substring(8);
                isPattern = true;
            } else if (nameStr.startsWith("ipattern:")) {
                nameStr = nameStr.substring(9);
                isPattern = true;
                caseInsensitive = true;
            } else {
                this.blockEntityNamePredicate = nameStr::equals;
                return;
            }
            String patternStr = nameStr;
            if (isPattern) {
                patternStr = Pattern.quote(patternStr);
                patternStr = patternStr.replace("?", "\\E.\\Q");
                patternStr = patternStr.replace("*", "\\E.*\\Q");
            }
            Pattern pattern = Pattern.compile(patternStr, caseInsensitive ? 2 : 0);
            this.blockEntityNamePredicate = blockEntityName -> pattern.matcher((CharSequence)blockEntityName).matches();
        }
    }

    protected void parseResourceCondition() {
        String[] conditionStrs;
        String conditionsStr = this.properties.getProperty("resourceCondition");
        if (conditionsStr != null && (conditionStrs = (conditionsStr = conditionsStr.trim()).split("\\|")).length != 0) {
            class_3268 defaultPack = ResourcePackUtil.getDefaultResourcePack();
            BooleanState invalidIdentifierState = InvalidIdentifierStateHolder.get();
            invalidIdentifierState.enable();
            for (int i = 0; i < conditionStrs.length; ++i) {
                class_3262 pack;
                String[] parts;
                String conditionStr = conditionStrs[i];
                if (conditionStr.isEmpty() || (parts = conditionStr.split("@", 2)).length == 0) continue;
                class_2960 resourceId = new class_2960(parts[0]);
                String packStr = parts.length > 1 ? parts[1] : null;
                if (packStr == null || packStr.equals("default")) {
                    pack = ResourcePackUtil.getProvidingResourcePack(resourceId);
                    if (pack == null || pack == defaultPack) continue;
                    this.valid = false;
                    break;
                }
                if (packStr.equals("programmer_art")) {
                    pack = ResourcePackUtil.getProvidingResourcePack(resourceId);
                    if (pack == null || pack.method_14409().equals("Programmer Art")) continue;
                    this.valid = false;
                    break;
                }
                ContinuityClient.LOGGER.warn("Invalid pack '" + packStr + "' in 'resourceCondition' element '" + conditionStr + "' at index " + i + " in file '" + this.id + "' in pack '" + this.packName + "'");
            }
            invalidIdentifierState.disable();
        }
    }

    protected boolean isValid() {
        return this.valid;
    }

    protected void resolveTiles() {
        this.textureDependencies = new ObjectOpenHashSet();
        this.spriteIds = new ObjectArrayList();
        ResourceRedirectHandler redirectHandler = ResourceRedirectHandler.get();
        for (class_2960 tile : this.tiles) {
            class_4730 spriteId;
            if (tile.equals((Object)SPECIAL_SKIP_ID)) {
                spriteId = SPECIAL_SKIP_SPRITE_ID;
            } else if (tile.equals((Object)SPECIAL_DEFAULT_ID)) {
                spriteId = SPECIAL_DEFAULT_SPRITE_ID;
            } else {
                String namespace = tile.method_12836();
                String path = tile.method_12832();
                if (path.startsWith("textures/")) {
                    if ((path = path.substring(9)).endsWith(".png")) {
                        path = path.substring(0, path.length() - 4);
                    }
                    spriteId = TextureUtil.toSpriteId(new class_2960(namespace, path));
                    this.textureDependencies.add(spriteId);
                } else if (redirectHandler != null) {
                    path = redirectHandler.getSourceSpritePath(path);
                    spriteId = TextureUtil.toSpriteId(new class_2960(namespace, path));
                    this.textureDependencies.add(spriteId);
                } else {
                    spriteId = TextureUtil.MISSING_SPRITE_ID;
                }
            }
            this.spriteIds.add(spriteId);
        }
    }

    public class_2960 getId() {
        return this.id;
    }

    public String getPackName() {
        return this.packName;
    }

    public String getMethod() {
        return this.method;
    }

    public Set<class_2960> getMatchTilesSet() {
        return this.matchTilesSet;
    }

    public Predicate<class_2680> getMatchBlocksPredicate() {
        return this.matchBlocksPredicate;
    }

    public int getWeight() {
        return this.weight;
    }

    public EnumSet<class_2350> getFaces() {
        return this.faces;
    }

    public Predicate<class_1959> getBiomePredicate() {
        return this.biomePredicate;
    }

    public IntPredicate getHeightPredicate() {
        return this.heightPredicate;
    }

    public Predicate<String> getBlockEntityNamePredicate() {
        return this.blockEntityNamePredicate;
    }

    public List<class_4730> getSpriteIds() {
        if (this.spriteIds == null) {
            this.resolveTiles();
        }
        return this.spriteIds;
    }

    public static <T extends BaseCTMProperties> CTMPropertiesFactory<T> wrapFactory(CTMPropertiesFactory<T> factory) {
        return (properties, id, packName, packPriority, method) -> {
            BaseCTMProperties ctmProperties = (BaseCTMProperties)factory.createProperties(properties, id, packName, packPriority, method);
            if (ctmProperties == null) {
                return null;
            }
            ctmProperties.init();
            if (ctmProperties.isValid()) {
                return ctmProperties;
            }
            return null;
        };
    }
}

