/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.recipes;

import com.google.common.collect.ImmutableTable;
import java.util.Optional;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.transfer.IRecipeTransferHandler;
import mezz.jei.common.Constants;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.class_1703;
import net.minecraft.class_3917;
import org.jetbrains.annotations.Nullable;

public class RecipeTransferManager {
    private final ImmutableTable<Class<? extends class_1703>, RecipeType<?>, IRecipeTransferHandler<?, ?>> recipeTransferHandlers;

    public RecipeTransferManager(ImmutableTable<Class<? extends class_1703>, RecipeType<?>, IRecipeTransferHandler<?, ?>> recipeTransferHandlers) {
        this.recipeTransferHandlers = recipeTransferHandlers;
    }

    @Nullable
    public <C extends class_1703, R> IRecipeTransferHandler<C, R> getRecipeTransferHandler(C container, IRecipeCategory<R> recipeCategory) {
        class_3917 menuType;
        ErrorUtil.checkNotNull(container, "container");
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        try {
            class_3917 cast;
            menuType = cast = container.method_17358();
        }
        catch (UnsupportedOperationException ignored) {
            menuType = null;
        }
        RecipeType<R> recipeType = recipeCategory.getRecipeType();
        Class<?> containerClass = container.getClass();
        IRecipeTransferHandler<?, R> handler = this.getHandler(containerClass, menuType, recipeType);
        if (handler != null) {
            return handler;
        }
        return this.getHandler(containerClass, menuType, Constants.UNIVERSAL_RECIPE_TRANSFER_TYPE);
    }

    @Nullable
    private <C extends class_1703, R> IRecipeTransferHandler<C, R> getHandler(Class<? extends C> containerClass, @Nullable class_3917<C> menuType, RecipeType<?> recipeType) {
        Optional handlerMenuType;
        IRecipeTransferHandler handler = (IRecipeTransferHandler)this.recipeTransferHandlers.get(containerClass, recipeType);
        if (handler != null && ((handlerMenuType = handler.getMenuType()).isEmpty() || handlerMenuType.get().equals(menuType))) {
            IRecipeTransferHandler cast = handler;
            return cast;
        }
        return null;
    }
}

