/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.plugins.vanilla.crafting;

import java.util.List;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.common.util.RecipeErrorUtil;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_2371;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class CategoryRecipeValidator<T extends class_1860<?>> {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final int INVALID_COUNT = -1;
    private final IRecipeCategory<T> recipeCategory;
    private final int maxInputs;

    public CategoryRecipeValidator(IRecipeCategory<T> recipeCategory, int maxInputs) {
        this.recipeCategory = recipeCategory;
        this.maxInputs = maxInputs;
    }

    public boolean isRecipeValid(T recipe) {
        return this.hasValidInputsAndOutputs(recipe);
    }

    public boolean isRecipeHandled(T recipe) {
        return this.recipeCategory.isHandled(recipe);
    }

    private boolean hasValidInputsAndOutputs(T recipe) {
        if (recipe.method_8118()) {
            return true;
        }
        class_1799 recipeOutput = recipe.method_8110();
        if (recipeOutput == null || recipeOutput.method_7960()) {
            String recipeInfo = RecipeErrorUtil.getInfoFromRecipe(recipe, this.recipeCategory);
            LOGGER.error("Recipe has no output. {}", (Object)recipeInfo);
            return false;
        }
        class_2371 ingredients = recipe.method_8117();
        if (ingredients == null) {
            String recipeInfo = RecipeErrorUtil.getInfoFromRecipe(recipe, this.recipeCategory);
            LOGGER.error("Recipe has no input Ingredients. {}", (Object)recipeInfo);
            return false;
        }
        int inputCount = CategoryRecipeValidator.getInputCount((List<class_1856>)ingredients);
        if (inputCount == -1) {
            return false;
        }
        if (inputCount > this.maxInputs) {
            String recipeInfo = RecipeErrorUtil.getInfoFromRecipe(recipe, this.recipeCategory);
            LOGGER.error("Recipe has too many inputs. {}", (Object)recipeInfo);
            return false;
        }
        if (inputCount == 0 && this.maxInputs > 0) {
            String recipeInfo = RecipeErrorUtil.getInfoFromRecipe(recipe, this.recipeCategory);
            LOGGER.error("Recipe has no inputs. {}", (Object)recipeInfo);
            return false;
        }
        return true;
    }

    private static int getInputCount(List<class_1856> ingredientList) {
        int inputCount = 0;
        for (class_1856 ingredient : ingredientList) {
            class_1799[] input = ingredient.method_8105();
            if (input == null) {
                return -1;
            }
            ++inputCount;
        }
        return inputCount;
    }
}

