/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.input.handlers;

import java.util.List;
import java.util.Optional;
import mezz.jei.common.gui.TooltipRenderer;
import mezz.jei.common.gui.overlay.IIngredientGrid;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.input.IUserInputHandler;
import mezz.jei.common.input.UserInput;
import mezz.jei.common.network.IConnectionToServer;
import mezz.jei.common.network.packets.PacketDeletePlayerItem;
import mezz.jei.common.platform.IPlatformItemStackHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.CheatUtil;
import mezz.jei.core.config.GiveMode;
import mezz.jei.core.config.IClientConfig;
import mezz.jei.core.config.IWorldConfig;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_746;

public class DeleteItemInputHandler
implements IUserInputHandler {
    private final IIngredientGrid ingredientGrid;
    private final IWorldConfig worldConfig;
    private final IClientConfig clientConfig;
    private final IConnectionToServer serverConnection;

    public DeleteItemInputHandler(IIngredientGrid ingredientGrid, IWorldConfig worldConfig, IClientConfig clientConfig, IConnectionToServer serverConnection) {
        this.ingredientGrid = ingredientGrid;
        this.worldConfig = worldConfig;
        this.clientConfig = clientConfig;
        this.serverConnection = serverConnection;
    }

    @Override
    public Optional<IUserInputHandler> handleUserInput(class_437 screen, UserInput userInput, IInternalKeyMappings keyBindings) {
        double mouseY;
        double mouseX = userInput.getMouseX();
        if (!this.ingredientGrid.isMouseOver(mouseX, mouseY = userInput.getMouseY())) {
            return Optional.empty();
        }
        class_310 minecraft = class_310.method_1551();
        if (!this.shouldDeleteItemOnClick(minecraft, mouseX, mouseY)) {
            return Optional.empty();
        }
        class_746 player = minecraft.field_1724;
        if (player == null) {
            return Optional.empty();
        }
        class_1799 itemStack = player.field_7512.method_34255();
        if (itemStack.method_7960()) {
            return Optional.empty();
        }
        if (!userInput.isSimulate()) {
            player.field_7512.method_34254(class_1799.field_8037);
            PacketDeletePlayerItem packet = new PacketDeletePlayerItem(itemStack);
            this.serverConnection.sendPacketToServer(packet);
        }
        return Optional.of(this);
    }

    public void drawTooltips(class_4587 poseStack, int mouseX, int mouseY) {
        class_5250 deleteItem = class_2561.method_43471((String)"jei.tooltip.delete.item");
        TooltipRenderer.drawHoveringText(poseStack, List.of(deleteItem), mouseX, mouseY);
    }

    public boolean shouldDeleteItemOnClick(class_310 minecraft, double mouseX, double mouseY) {
        if (!this.worldConfig.isDeleteItemsInCheatModeActive()) {
            return false;
        }
        class_746 player = minecraft.field_1724;
        if (player == null) {
            return false;
        }
        class_1799 itemStack = player.field_7512.method_34255();
        if (itemStack.method_7960()) {
            return false;
        }
        GiveMode giveMode = this.clientConfig.getGiveMode();
        if (giveMode == GiveMode.MOUSE_PICKUP) {
            return this.ingredientGrid.getIngredientUnderMouse(mouseX, mouseY).findFirst().map(CheatUtil::getCheatItemStack).map(i -> {
                IPlatformItemStackHelper itemStackHelper = Services.PLATFORM.getItemStackHelper();
                return !itemStackHelper.canStack(itemStack, (class_1799)i);
            }).orElse(true);
        }
        return true;
    }
}

