/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.input;

import java.util.List;
import java.util.stream.Stream;
import mezz.jei.common.input.IClickedIngredient;
import mezz.jei.common.input.IInternalKeyMappings;
import mezz.jei.common.input.IRecipeFocusSource;
import mezz.jei.common.input.UserInput;
import net.minecraft.class_310;

public class CombinedRecipeFocusSource {
    private final List<IRecipeFocusSource> handlers;

    public CombinedRecipeFocusSource(IRecipeFocusSource ... handlers) {
        this.handlers = List.of(handlers);
    }

    public Stream<IClickedIngredient<?>> getIngredientUnderMouse(UserInput input, IInternalKeyMappings keyBindings) {
        double mouseX = input.getMouseX();
        double mouseY = input.getMouseY();
        Stream<IClickedIngredient<?>> stream = this.handlers.stream().flatMap(handler -> handler.getIngredientUnderMouse(mouseX, mouseY));
        if (CombinedRecipeFocusSource.isConflictingVanillaMouseButton(input, keyBindings)) {
            stream = stream.filter(IClickedIngredient::canOverrideVanillaClickHandler);
        }
        return stream;
    }

    private static boolean isConflictingVanillaMouseButton(UserInput input, IInternalKeyMappings keyBindings) {
        if (input.isMouse()) {
            class_310 minecraft = class_310.method_1551();
            return input.is(keyBindings.getLeftClick()) || input.is(minecraft.field_1690.field_1871) || input.is(keyBindings.getRightClick());
        }
        return false;
    }
}

