/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.ingredients;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import mezz.jei.common.color.ColorNamer;
import mezz.jei.common.config.IIngredientFilterConfig;
import mezz.jei.common.util.Translator;
import net.minecraft.class_124;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_3544;
import org.jetbrains.annotations.Unmodifiable;

public final class IngredientInformationUtil {
    private IngredientInformationUtil() {
    }

    public static <T> String getDisplayName(T ingredient, IIngredientHelper<T> ingredientHelper) {
        String displayName = ingredientHelper.getDisplayName(ingredient);
        return IngredientInformationUtil.removeChatFormatting(displayName);
    }

    public static <T> @Unmodifiable List<String> getTooltipStrings(T ingredient, IIngredientRenderer<T> ingredientRenderer, Set<String> toRemove, IIngredientFilterConfig config) {
        class_1836.class_1837 tooltipFlag = config.getSearchAdvancedTooltips() ? class_1836.class_1837.field_8935 : class_1836.class_1837.field_8934;
        List<class_2561> tooltip = ingredientRenderer.getTooltip(ingredient, (class_1836)tooltipFlag);
        return tooltip.stream().map(class_2561::getString).map(IngredientInformationUtil::removeChatFormatting).map(Translator::toLowercaseWithLocale).map(line -> {
            for (String excludeWord : toRemove) {
                line = line.replace(excludeWord, "");
            }
            return line;
        }).filter(line -> !class_3544.method_15438((String)line)).toList();
    }

    private static String removeChatFormatting(String string) {
        String withoutFormattingCodes = class_124.method_539((String)string);
        return withoutFormattingCodes == null ? "" : withoutFormattingCodes;
    }

    public static <V> Collection<String> getColorStrings(V ingredient, IIngredientHelper<V> ingredientHelper) {
        Iterable<Integer> colors = ingredientHelper.getColors(ingredient);
        ColorNamer colorNamer = ColorNamer.getInstance();
        return colorNamer.getColorNames(colors).map(Translator::toLowercaseWithLocale).distinct().toList();
    }
}

