/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.gui.recipes.layout;

import java.util.List;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.recipe.transfer.IRecipeTransferError;
import mezz.jei.common.gui.TooltipRenderer;
import mezz.jei.common.gui.elements.GuiIconButtonSmall;
import mezz.jei.common.gui.ingredients.RecipeSlots;
import mezz.jei.common.gui.recipes.IOnClickHandler;
import mezz.jei.common.gui.recipes.layout.IRecipeLayoutInternal;
import mezz.jei.common.gui.textures.Textures;
import mezz.jei.common.recipes.RecipeTransferManager;
import mezz.jei.common.transfer.RecipeTransferErrorInternal;
import mezz.jei.common.transfer.RecipeTransferUtil;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;

public class RecipeTransferButton
extends GuiIconButtonSmall {
    public static final int RECIPE_BUTTON_SIZE = 13;
    private final IRecipeLayoutInternal<?> recipeLayout;
    @Nullable
    private IRecipeTransferError recipeTransferError;
    @Nullable
    private IOnClickHandler onClickHandler;

    public RecipeTransferButton(int xPos, int yPos, IDrawable icon, IRecipeLayoutInternal<?> recipeLayout, Textures textures) {
        super(xPos, yPos, 13, 13, icon, b -> {}, textures);
        this.recipeLayout = recipeLayout;
    }

    public void init(RecipeTransferManager recipeTransferManager, @Nullable class_1703 container, class_1657 player) {
        this.recipeTransferError = container != null ? RecipeTransferUtil.getTransferRecipeError(recipeTransferManager, container, this.recipeLayout, player) : RecipeTransferErrorInternal.INSTANCE;
        if (RecipeTransferUtil.allowsTransfer(this.recipeTransferError)) {
            this.field_22763 = true;
            this.field_22764 = true;
        } else {
            this.field_22763 = false;
            IRecipeTransferError.Type type = this.recipeTransferError.getType();
            this.field_22764 = type == IRecipeTransferError.Type.USER_FACING;
        }
    }

    public void drawToolTip(class_4587 poseStack, int mouseX, int mouseY) {
        if (this.method_25405(mouseX, mouseY)) {
            if (this.recipeTransferError == null) {
                class_5250 tooltipTransfer = class_2561.method_43471((String)"jei.tooltip.transfer");
                TooltipRenderer.drawHoveringText(poseStack, List.of(tooltipTransfer), mouseX, mouseY);
            } else {
                RecipeSlots recipeSlots = this.recipeLayout.getRecipeSlots();
                IRecipeSlotsView recipeSlotsView = recipeSlots.getView();
                this.recipeTransferError.showError(poseStack, mouseX, mouseY, recipeSlotsView, this.recipeLayout.getPosX(), this.recipeLayout.getPosY());
            }
        }
    }

    public boolean method_25405(double mouseX, double mouseY) {
        return this.field_22764 && mouseX >= (double)this.field_22760 && mouseY >= (double)this.field_22761 && mouseX < (double)(this.field_22760 + this.field_22758) && mouseY < (double)(this.field_22761 + this.field_22759);
    }

    @Override
    public void method_25394(class_4587 poseStack, int mouseX, int mouseY, float partialTicks) {
        super.method_25394(poseStack, mouseX, mouseY, partialTicks);
        if (this.field_22764 && this.recipeTransferError != null && this.recipeTransferError.getType() == IRecipeTransferError.Type.COSMETIC) {
            RecipeTransferButton.method_25294((class_4587)poseStack, (int)this.field_22760, (int)this.field_22761, (int)(this.field_22760 + this.field_22758), (int)(this.field_22761 + this.field_22759), (int)-2130729728);
        }
    }

    public void setOnClickHandler(IOnClickHandler onClickHandler) {
        this.onClickHandler = onClickHandler;
    }

    public void method_25357(double mouseX, double mouseY) {
        if (!this.method_25405(mouseX, mouseY)) {
            return;
        }
        if (this.onClickHandler != null) {
            this.onClickHandler.onClick(mouseX, mouseY);
        }
    }
}

