/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.config.file;

import java.util.List;
import mezz.jei.common.config.file.ConfigSchema;
import mezz.jei.common.config.file.serializers.DeserializeResult;
import mezz.jei.common.config.file.serializers.IConfigValueSerializer;
import org.jetbrains.annotations.Nullable;

public class ConfigValue<T> {
    private final String name;
    private final String description;
    private final T defaultValue;
    private final IConfigValueSerializer<T> serializer;
    private volatile T currentValue;
    @Nullable
    private ConfigSchema schema;

    public ConfigValue(String name, T defaultValue, IConfigValueSerializer<T> serializer, String description) {
        this.name = name;
        this.description = description;
        this.defaultValue = defaultValue;
        this.currentValue = defaultValue;
        this.serializer = serializer;
    }

    public void setSchema(ConfigSchema schema) {
        this.schema = schema;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getValue() {
        if (this.schema != null) {
            this.schema.loadIfNeeded();
        }
        return this.currentValue;
    }

    public IConfigValueSerializer<T> getSerializer() {
        return this.serializer;
    }

    public List<String> setFromSerializedValue(String value) {
        DeserializeResult<T> deserializeResult = this.serializer.deserialize(value);
        T result = deserializeResult.getResult();
        if (result != null) {
            this.currentValue = result;
        }
        return deserializeResult.getErrors();
    }
}

