/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.common.color;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.helpers.IColorHelper;
import mezz.jei.common.color.ColorName;
import mezz.jei.common.color.ColorThief;
import mezz.jei.common.platform.IPlatformRenderHelper;
import mezz.jei.common.platform.Services;
import mezz.jei.common.util.ErrorUtil;
import net.minecraft.class_1011;
import net.minecraft.class_1047;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_324;
import net.minecraft.class_325;
import net.minecraft.class_3532;
import net.minecraft.class_763;
import net.minecraft.class_773;
import net.minecraft.class_776;
import net.minecraft.class_918;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public final class ColorGetter
implements IColorHelper {
    public static final ColorGetter INSTANCE = new ColorGetter();
    private static final Logger LOGGER = LogManager.getLogger();
    private static final List<ColorName> defaultColors = List.of(new ColorName("White", 0xEEEEEE), new ColorName("LightBlue", 7639756), new ColorName("Cyan", 61166), new ColorName("Blue", 0x2222DD), new ColorName("LapisBlue", 2441611), new ColorName("Teal", 32896), new ColorName("Yellow", 13290328), new ColorName("GoldenYellow", 15652608), new ColorName("Orange", 14251572), new ColorName("Pink", 13732253), new ColorName("HotPink", 0xFC0FC0), new ColorName("Magenta", 0xB24BBB), new ColorName("Purple", 8470201), new ColorName("EvilPurple", 3020361), new ColorName("Lavender", 11894492), new ColorName("Indigo", 4718722), new ColorName("Sand", 14406560), new ColorName("Tan", 12295011), new ColorName("LightBrown", 10506797), new ColorName("Brown", 6507315), new ColorName("DarkBrown", 3812627), new ColorName("LimeGreen", 4436537), new ColorName("SlimeGreen", 8637299), new ColorName("Green", 32768), new ColorName("DarkGreen", 0x224D22), new ColorName("GrassGreen", 5537865), new ColorName("Red", 9843760), new ColorName("BrickRed", 11558987), new ColorName("NetherBrick", 2757910), new ColorName("Redstone", 13516342), new ColorName("Black", 0x181515), new ColorName("CharcoalGray", 0x464646), new ColorName("IronGray", 0x646464), new ColorName("Gray", 0x808080), new ColorName("Silver", 0xC0C0C0));

    private ColorGetter() {
    }

    public static List<ColorName> getColorDefaults() {
        return defaultColors;
    }

    public static List<Integer> getColors(class_1799 itemStack, int colorCount) {
        try {
            return ColorGetter.unsafeGetColors(itemStack, colorCount);
        }
        catch (LinkageError | RuntimeException e) {
            String itemStackInfo = ErrorUtil.getItemStackInfo(itemStack);
            LOGGER.debug("Failed to get color name for {}", (Object)itemStackInfo, (Object)e);
            return Collections.emptyList();
        }
    }

    private static List<Integer> unsafeGetColors(class_1799 itemStack, int colorCount) {
        class_1792 item = itemStack.method_7909();
        if (itemStack.method_7960()) {
            return Collections.emptyList();
        }
        if (item instanceof class_1747) {
            class_1747 itemBlock = (class_1747)item;
            class_2248 block = itemBlock.method_7711();
            if (block == null) {
                return Collections.emptyList();
            }
            return ColorGetter.getBlockColors(block, colorCount);
        }
        return ColorGetter.getItemColors(itemStack, colorCount);
    }

    private static List<Integer> getItemColors(class_1799 itemStack, int colorCount) {
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        class_325 itemColors = renderHelper.getItemColors();
        int renderColor = itemColors.method_1704(itemStack, 0);
        class_1058 textureAtlasSprite = ColorGetter.getTextureAtlasSprite(itemStack);
        if (textureAtlasSprite == null) {
            return Collections.emptyList();
        }
        return INSTANCE.getColors(textureAtlasSprite, renderColor, colorCount);
    }

    private static List<Integer> getBlockColors(class_2248 block, int colorCount) {
        class_2680 blockState = block.method_9564();
        class_324 blockColors = class_310.method_1551().method_1505();
        int renderColor = blockColors.method_1697(blockState, null, null, 0);
        class_1058 textureAtlasSprite = ColorGetter.getTextureAtlasSprite(blockState);
        if (textureAtlasSprite == null) {
            return Collections.emptyList();
        }
        return INSTANCE.getColors(textureAtlasSprite, renderColor, colorCount);
    }

    @Override
    public List<Integer> getColors(class_1058 textureAtlasSprite, int renderColor, int colorCount) {
        int[][] palette;
        if (colorCount <= 0) {
            return Collections.emptyList();
        }
        class_1011 bufferedImage = ColorGetter.getNativeImage(textureAtlasSprite);
        if (bufferedImage == null) {
            return Collections.emptyList();
        }
        ArrayList<Integer> colors = new ArrayList<Integer>(colorCount);
        for (int[] colorInt : palette = ColorThief.getPalette(bufferedImage, colorCount, 2, false)) {
            int red = (int)((float)(colorInt[0] - 1) * (float)(renderColor >> 16 & 0xFF) / 255.0f);
            int green = (int)((float)(colorInt[1] - 1) * (float)(renderColor >> 8 & 0xFF) / 255.0f);
            int blue = (int)((float)(colorInt[2] - 1) * (float)(renderColor & 0xFF) / 255.0f);
            red = class_3532.method_15340((int)red, (int)0, (int)255);
            green = class_3532.method_15340((int)green, (int)0, (int)255);
            blue = class_3532.method_15340((int)blue, (int)0, (int)255);
            int color = 0xFF000000 | (red & 0xFF) << 16 | (green & 0xFF) << 8 | blue & 0xFF;
            colors.add(color);
        }
        return colors;
    }

    @Nullable
    private static class_1011 getNativeImage(class_1058 textureAtlasSprite) {
        int iconWidth = textureAtlasSprite.method_4578();
        int iconHeight = textureAtlasSprite.method_4595();
        if (iconWidth <= 0 || iconHeight <= 0) {
            return null;
        }
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        return renderHelper.getMainImage(textureAtlasSprite);
    }

    @Nullable
    private static class_1058 getTextureAtlasSprite(class_2680 blockState) {
        class_310 minecraft = class_310.method_1551();
        class_776 blockRendererDispatcher = minecraft.method_1541();
        class_773 blockModelShapes = blockRendererDispatcher.method_3351();
        class_1087 blockModel = blockModelShapes.method_3335(blockState);
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        class_1058 textureAtlasSprite = renderHelper.getParticleIcon(blockModel);
        if (textureAtlasSprite instanceof class_1047) {
            return null;
        }
        return textureAtlasSprite;
    }

    @Nullable
    private static class_1058 getTextureAtlasSprite(class_1799 itemStack) {
        class_918 itemRenderer = class_310.method_1551().method_1480();
        class_763 itemModelMesher = itemRenderer.method_4012();
        class_1087 itemModel = itemModelMesher.method_3308(itemStack);
        IPlatformRenderHelper renderHelper = Services.PLATFORM.getRenderHelper();
        class_1058 particleTexture = renderHelper.getParticleIcon(itemModel);
        if (particleTexture instanceof class_1047) {
            return null;
        }
        return particleTexture;
    }
}

