/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.util;

import com.google.common.collect.MapMaker;
import com.mojang.blaze3d.systems.RenderSystem;
import fi.dy.masa.malilib.config.IConfigBoolean;
import fi.dy.masa.minihud.config.Configs;
import fi.dy.masa.minihud.config.RendererToggle;
import fi.dy.masa.minihud.mixin.IMixinEntityNavigation;
import io.netty.buffer.Unpooled;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_11;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1408;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2658;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5575;
import net.minecraft.class_863;
import net.minecraft.class_869;
import net.minecraft.class_9;
import net.minecraft.server.MinecraftServer;

public class DebugInfoUtils {
    private static boolean neighborUpdateEnabled;
    private static boolean pathfindingEnabled;
    private static int tickCounter;
    private static final Map<class_1297, class_11> OLD_PATHS;

    public static void sendPacketDebugPath(MinecraftServer server, int entityId, class_11 path, float maxDistance) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        buffer.writeInt(entityId);
        buffer.writeFloat(maxDistance);
        DebugInfoUtils.writePathToBuffer(buffer, path);
        class_2658 packet = new class_2658(class_2658.field_12161, buffer);
        server.method_3760().method_14581((class_2596)packet);
    }

    private static void writeBlockPosToBuffer(class_2540 buf, class_2338 pos) {
        buf.writeInt(pos.method_10263());
        buf.writeInt(pos.method_10264());
        buf.writeInt(pos.method_10260());
    }

    private static void writePathPointToBuffer(class_2540 buf, class_9 node) {
        buf.writeInt(node.field_40);
        buf.writeInt(node.field_39);
        buf.writeInt(node.field_38);
        buf.writeFloat(node.field_46);
        buf.writeFloat(node.field_43);
        buf.writeBoolean(node.field_42);
        buf.writeInt(node.field_41.ordinal());
        buf.writeFloat(node.field_47);
    }

    public static class_2540 writePathTobuffer(class_11 path) {
        class_2540 buffer = new class_2540(Unpooled.buffer());
        DebugInfoUtils.writePathToBuffer(buffer, path);
        return buffer;
    }

    private static void writePathToBuffer(class_2540 buf, class_11 path) {
        class_9 destination = path.method_45();
        class_2338 target = path.method_48();
        if (destination != null) {
            buf.writeBoolean(path.method_21655());
            buf.writeInt(path.method_39());
            buf.writeInt(0);
            DebugInfoUtils.writeBlockPosToBuffer(buf, target);
            class_9[] openSet = path.method_22880();
            class_9[] closedSet = path.method_22881();
            int length = path.method_38();
            buf.writeInt(length);
            for (int i = 0; i < length; ++i) {
                class_9 point = path.method_40(i);
                DebugInfoUtils.writePathPointToBuffer(buf, point);
            }
            buf.writeInt(openSet.length);
            for (class_9 point : openSet) {
                DebugInfoUtils.writePathPointToBuffer(buf, point);
            }
            buf.writeInt(closedSet.length);
            for (class_9 point : closedSet) {
                DebugInfoUtils.writePathPointToBuffer(buf, point);
            }
        }
    }

    public static void onNeighborUpdate(class_1937 world, class_2338 pos) {
        if (neighborUpdateEnabled && !world.field_9236) {
            class_310 mc = class_310.method_1551();
            mc.execute(() -> ((class_869)mc.field_1709.field_4535).method_3870(world.method_8510(), pos.method_10062()));
        }
    }

    public static void onServerTickEnd(MinecraftServer server) {
        class_310 mc = class_310.method_1551();
        if (pathfindingEnabled && mc.field_1687 != null && ++tickCounter >= 10) {
            tickCounter = 0;
            class_3218 world = server.method_3847(mc.field_1687.method_27983());
            if (world != null) {
                class_5575 filter = class_5575.method_31795(class_1308.class);
                Predicate<class_1308> predicate = class_1309::method_5805;
                for (class_1308 entity : world.method_18198(filter, predicate)) {
                    boolean isSamepath;
                    class_1408 navigator = entity.method_5942();
                    if (navigator == null || !DebugInfoUtils.isAnyPlayerWithinRange(world, (class_1297)entity, 64.0)) continue;
                    class_11 path = navigator.method_6345();
                    class_11 old = OLD_PATHS.get(entity);
                    if (path == null) continue;
                    boolean bl = isSamepath = old != null && old.method_41(path);
                    if (old != null && isSamepath && old.method_39() == path.method_39()) continue;
                    int id = entity.method_5628();
                    float maxDistance = Configs.Generic.DEBUG_RENDERER_PATH_MAX_DIST.getBooleanValue() ? ((IMixinEntityNavigation)navigator).getMaxDistanceToWaypoint() : 0.0f;
                    DebugInfoUtils.sendPacketDebugPath(server, id, path, maxDistance);
                    if (!isSamepath) {
                        class_2540 buf = DebugInfoUtils.writePathTobuffer(path);
                        OLD_PATHS.put((class_1297)entity, class_11.method_34((class_2540)buf));
                        continue;
                    }
                    old.method_42(path.method_39());
                }
            }
        }
    }

    private static boolean isAnyPlayerWithinRange(class_3218 world, class_1297 entity, double range) {
        List players = world.method_18456();
        double squaredRange = range * range;
        for (class_1657 player : players) {
            double distSq = player.method_5649(entity.method_23317(), entity.method_23318(), entity.method_23321());
            if (!(range < 0.0) && !(distSq < squaredRange)) continue;
            return true;
        }
        return false;
    }

    public static void toggleDebugRenderer(IConfigBoolean config) {
        if (config == RendererToggle.DEBUG_NEIGHBOR_UPDATES) {
            neighborUpdateEnabled = config.getBooleanValue();
        } else if (config == RendererToggle.DEBUG_PATH_FINDING) {
            pathfindingEnabled = config.getBooleanValue();
        } else if (config == RendererToggle.DEBUG_CHUNK_BORDER) {
            boolean enabled = class_310.method_1551().field_1709.method_3713();
            DebugInfoUtils.debugWarn(enabled ? "debug.chunk_boundaries.on" : "debug.chunk_boundaries.off", new Object[0]);
        } else if (config == RendererToggle.DEBUG_CHUNK_INFO) {
            class_310.method_1551().field_20907 = config.getBooleanValue();
        } else if (config == RendererToggle.DEBUG_CHUNK_OCCLUSION) {
            class_310.method_1551().field_20908 = config.getBooleanValue();
        }
    }

    private static void debugWarn(String key, Object ... args) {
        class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43473().method_10852((class_2561)class_2561.method_43471((String)"debug.prefix").method_27695(new class_124[]{class_124.field_1054, class_124.field_1067})).method_27693(" ").method_10852((class_2561)class_2561.method_43469((String)key, (Object[])args)));
    }

    public static void renderVanillaDebug(class_4587 matrixStack, class_4597.class_4598 vtx, double cameraX, double cameraY, double cameraZ) {
        class_863 renderer = class_310.method_1551().field_1709;
        if (RendererToggle.DEBUG_COLLISION_BOXES.getBooleanValue()) {
            renderer.field_4534.method_23109(matrixStack, (class_4597)vtx, cameraX, cameraY, cameraZ);
        }
        if (RendererToggle.DEBUG_NEIGHBOR_UPDATES.getBooleanValue()) {
            renderer.field_4535.method_23109(matrixStack, (class_4597)vtx, cameraX, cameraY, cameraZ);
        }
        if (RendererToggle.DEBUG_PATH_FINDING.getBooleanValue()) {
            renderer.field_4523.method_23109(matrixStack, (class_4597)vtx, cameraX, cameraY, cameraZ);
        }
        if (RendererToggle.DEBUG_SOLID_FACES.getBooleanValue()) {
            RenderSystem.enableDepthTest();
            renderer.field_4517.method_23109(matrixStack, (class_4597)vtx, cameraX, cameraY, cameraZ);
        }
        if (RendererToggle.DEBUG_WATER.getBooleanValue()) {
            renderer.field_4528.method_23109(matrixStack, (class_4597)vtx, cameraX, cameraY, cameraZ);
        }
    }

    static {
        OLD_PATHS = new MapMaker().weakKeys().weakValues().makeMap();
    }
}

