/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.minihud.event;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fi.dy.masa.malilib.interfaces.IWorldLoadListener;
import fi.dy.masa.malilib.util.FileUtils;
import fi.dy.masa.malilib.util.JsonUtils;
import fi.dy.masa.malilib.util.StringUtils;
import fi.dy.masa.minihud.MiniHUD;
import fi.dy.masa.minihud.renderer.OverlayRenderer;
import fi.dy.masa.minihud.renderer.RenderContainer;
import fi.dy.masa.minihud.renderer.shapes.ShapeManager;
import fi.dy.masa.minihud.util.DataStorage;
import java.io.File;
import javax.annotation.Nullable;
import net.minecraft.class_310;
import net.minecraft.class_638;

public class WorldLoadListener
implements IWorldLoadListener {
    public void onWorldLoadPre(@Nullable class_638 worldBefore, @Nullable class_638 worldAfter, class_310 mc) {
        if (worldBefore != null) {
            this.writeDataPerDimension();
            if (worldAfter == null) {
                this.writeDataGlobal();
            }
        }
    }

    public void onWorldLoadPost(@Nullable class_638 worldBefore, @Nullable class_638 worldAfter, class_310 mc) {
        DataStorage.getInstance().reset(worldAfter == null);
        if (worldAfter != null) {
            if (worldBefore == null) {
                this.readStoredDataGlobal();
            }
            this.readStoredDataPerDimension();
            OverlayRenderer.resetRenderTimeout();
            DataStorage.getInstance().onWorldJoin();
        }
    }

    private void writeDataPerDimension() {
        File file = WorldLoadListener.getCurrentStorageFile(false);
        JsonObject root = new JsonObject();
        root.add("data_storage", (JsonElement)DataStorage.getInstance().toJson());
        root.add("shapes", (JsonElement)ShapeManager.INSTANCE.toJson());
        JsonUtils.writeJsonToFile((JsonObject)root, (File)file);
    }

    private void writeDataGlobal() {
        File file = WorldLoadListener.getCurrentStorageFile(true);
        JsonObject root = new JsonObject();
        root.add("renderers", (JsonElement)RenderContainer.INSTANCE.toJson());
        JsonUtils.writeJsonToFile((JsonObject)root, (File)file);
    }

    private void readStoredDataPerDimension() {
        File file = WorldLoadListener.getCurrentStorageFile(false);
        JsonElement element = JsonUtils.parseJsonFile((File)file);
        if (element != null && element.isJsonObject()) {
            JsonObject root = element.getAsJsonObject();
            if (JsonUtils.hasObject((JsonObject)root, (String)"shapes")) {
                ShapeManager.INSTANCE.fromJson(JsonUtils.getNestedObject((JsonObject)root, (String)"shapes", (boolean)false));
            }
            if (JsonUtils.hasObject((JsonObject)root, (String)"data_storage")) {
                DataStorage.getInstance().fromJson(JsonUtils.getNestedObject((JsonObject)root, (String)"data_storage", (boolean)false));
            }
        }
    }

    private void readStoredDataGlobal() {
        JsonObject root;
        File file = WorldLoadListener.getCurrentStorageFile(true);
        JsonElement element = JsonUtils.parseJsonFile((File)file);
        if (element != null && element.isJsonObject() && JsonUtils.hasObject((JsonObject)(root = element.getAsJsonObject()), (String)"renderers")) {
            RenderContainer.INSTANCE.fromJson(JsonUtils.getNestedObject((JsonObject)root, (String)"renderers", (boolean)false));
        }
    }

    public static File getCurrentConfigDirectory() {
        return new File(FileUtils.getConfigDirectory(), "minihud");
    }

    private static File getCurrentStorageFile(boolean globalData) {
        File dir = WorldLoadListener.getCurrentConfigDirectory();
        if (!dir.exists() && !dir.mkdirs()) {
            MiniHUD.logger.warn("Failed to create the config directory '{}'", (Object)dir.getAbsolutePath());
        }
        return new File(dir, StringUtils.getStorageFileName((boolean)globalData, (String)"", (String)".json", (String)"minihud_default"));
    }
}

