/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.IllegalFormatException;
import mcp.mobius.waila.util.ExceptionUtil;
import net.minecraft.class_1159;
import net.minecraft.class_1799;
import net.minecraft.class_287;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_757;

public final class DisplayUtil
extends class_332 {
    private static final DisplayUtil DH = new DisplayUtil();
    private static final String NUM_SUFFIXES = "kmbt";
    private static final class_310 CLIENT = class_310.method_1551();

    public static void bindTexture(class_2960 texture) {
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.setShaderTexture((int)0, (class_2960)texture);
    }

    public static void renderStack(int x, int y, class_1799 stack) {
        DisplayUtil.renderStack(x, y, stack, stack.method_7947() > 1 ? DisplayUtil.shortHandNumber(stack.method_7947()) : "");
    }

    public static void renderStack(int x, int y, class_1799 stack, String countText) {
        DisplayUtil.enable3DRender();
        try {
            CLIENT.method_1480().method_4010(stack, x, y);
            CLIENT.method_1480().method_4022(DisplayUtil.CLIENT.field_1772, stack, x, y, countText);
        }
        catch (Exception e) {
            String stackStr = stack != null ? stack.toString() : "NullStack";
            ExceptionUtil.dump(e, "renderStack | " + stackStr, null);
        }
        DisplayUtil.enable2DRender();
    }

    private static String shortHandNumber(int number) {
        if (number < 1000) {
            return "" + number;
        }
        int exp = (int)(Math.log(number) / Math.log(1000.0));
        return String.format("%.1f%c", (double)number / Math.pow(1000.0, exp), Character.valueOf(NUM_SUFFIXES.charAt(exp - 1)));
    }

    public static void enable3DRender() {
        class_308.method_24211();
        RenderSystem.enableDepthTest();
    }

    public static void enable2DRender() {
        class_308.method_24210();
        RenderSystem.disableDepthTest();
    }

    public static void drawGradientRect(class_4587 matrices, int x, int y, int w, int h, int startColor, int endColor) {
        DH.method_25296(matrices, x, y, x + w, y + h, startColor, endColor);
    }

    public static void drawTexturedModalRect(class_4587 matrices, int x, int y, int textureX, int textureY, int width, int height, int tw, int th) {
        DisplayUtil.method_25293((class_4587)matrices, (int)x, (int)y, (int)width, (int)height, (float)textureX, (float)textureY, (int)tw, (int)th, (int)256, (int)256);
    }

    public static void fillGradient(class_1159 matrix, class_287 buf, int x, int y, int w, int h, int start, int end) {
        DisplayUtil.method_27533((class_1159)matrix, (class_287)buf, (int)x, (int)y, (int)(x + w), (int)(y + h), (int)0, (int)start, (int)end);
    }

    public static int getAlphaFromPercentage(int percentage) {
        return percentage == 100 ? -16777216 : (percentage == 0 ? 0x1000000 : (int)((float)percentage / 100.0f * 256.0f) << 24);
    }

    public static String tryFormat(String format, Object ... args) {
        try {
            return format.formatted(args);
        }
        catch (IllegalFormatException e) {
            return "FORMATTING ERROR";
        }
    }
}

