/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.component.PairComponent;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.class_1496;
import net.minecraft.class_2561;
import net.minecraft.class_6025;

public enum PetOwnerProvider implements IEntityComponentProvider
{
    INSTANCE;

    static final Map<UUID, class_2561> NAMES;
    static final class_2561 UNKNOWN;
    static final class_2561 KEY;

    @Override
    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        if (config.getBoolean(Options.PET_OWNER)) {
            class_2561 name;
            Object entity = accessor.getEntity();
            UUID uuid = null;
            if (entity instanceof class_1496) {
                class_1496 horse = (class_1496)entity;
                uuid = horse.method_6768();
            } else if (entity instanceof class_6025) {
                class_6025 ownableEntity = (class_6025)entity;
                uuid = ownableEntity.method_6139();
            }
            if (uuid == null) {
                return;
            }
            if (NAMES.containsKey(uuid)) {
                name = NAMES.get(uuid);
            } else {
                name = UNKNOWN;
                try {
                    String nameStr;
                    JsonObject object;
                    HttpResponse<String> response = HttpClient.newHttpClient().send(HttpRequest.newBuilder().uri(new URI("https://sessionserver.mojang.com/session/minecraft/profile/" + uuid)).GET().build(), HttpResponse.BodyHandlers.ofString(StandardCharsets.UTF_8));
                    JsonElement element = JsonParser.parseString((String)response.body());
                    if (element.isJsonObject() && (object = element.getAsJsonObject()).has("name") && (element = object.get("name")).isJsonPrimitive() && !(nameStr = element.getAsString()).isBlank()) {
                        name = class_2561.method_43470((String)nameStr);
                    }
                }
                catch (JsonParseException | IOException | InterruptedException | URISyntaxException e) {
                    e.printStackTrace();
                }
                NAMES.put(uuid, name);
            }
            if (name != UNKNOWN || !config.getBoolean(Options.PET_HIDE_UNKNOWN_OWNER)) {
                tooltip.addLine(new PairComponent(KEY, name));
            }
        }
    }

    static {
        NAMES = new HashMap<UUID, class_2561>();
        UNKNOWN = class_2561.method_43470((String)"???");
        KEY = class_2561.method_43471((String)"tooltip.waila.owner");
    }
}

