/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.gui.hud;

import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.text2speech.Narrator;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.awt.Rectangle;
import java.util.function.Supplier;
import mcp.mobius.waila.access.DataAccessor;
import mcp.mobius.waila.api.IEventListener;
import mcp.mobius.waila.api.ITooltipComponent;
import mcp.mobius.waila.api.IWailaConfig;
import mcp.mobius.waila.api.WailaConstants;
import mcp.mobius.waila.api.component.EmptyComponent;
import mcp.mobius.waila.api.component.PairComponent;
import mcp.mobius.waila.api.component.WrappedComponent;
import mcp.mobius.waila.config.PluginConfig;
import mcp.mobius.waila.event.EventCanceller;
import mcp.mobius.waila.gui.hud.Line;
import mcp.mobius.waila.gui.hud.Tooltip;
import mcp.mobius.waila.registry.Registrar;
import mcp.mobius.waila.util.DisplayUtil;
import net.minecraft.class_1041;
import net.minecraft.class_1159;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3695;
import net.minecraft.class_408;
import net.minecraft.class_4587;
import net.minecraft.class_757;

public class TooltipRenderer {
    private static final Tooltip TOOLTIP = new Tooltip();
    private static final Object2IntOpenHashMap<Line> LINE_HEIGHT = new Object2IntOpenHashMap();
    private static final Supplier<Rectangle> RENDER_RECT = Suppliers.memoize(Rectangle::new);
    private static final Supplier<Rectangle> RECT = Suppliers.memoize(Rectangle::new);
    private static final Supplier<Narrator> NARRATOR = Suppliers.memoize(Narrator::getNarrator);
    private static boolean started;
    private static String lastNarration;
    private static ITooltipComponent icon;
    private static int topOffset;
    public static int colonOffset;
    public static int colonWidth;
    public static State state;

    public static void beginBuild(State state) {
        started = true;
        TooltipRenderer.state = state;
        TOOLTIP.clear();
        LINE_HEIGHT.clear();
        icon = EmptyComponent.INSTANCE;
        topOffset = 0;
        colonOffset = 0;
        colonWidth = class_310.method_1551().field_1772.method_1727(": ");
    }

    public static void add(Tooltip tooltip) {
        Preconditions.checkState((boolean)started);
        ObjectListIterator objectListIterator = tooltip.iterator();
        while (objectListIterator.hasNext()) {
            Line line = (Line)objectListIterator.next();
            if (line.tag != null) {
                TOOLTIP.setLine(line.tag, line);
                continue;
            }
            TooltipRenderer.add(line);
        }
    }

    public static void add(Line line) {
        Preconditions.checkState((boolean)started);
        TOOLTIP.add(line);
        for (ITooltipComponent component : line.components) {
            if (!(component instanceof PairComponent)) continue;
            PairComponent pair = (PairComponent)component;
            colonOffset = Math.max(pair.key.getWidth(), colonOffset);
            break;
        }
    }

    public static void setIcon(ITooltipComponent icon) {
        Preconditions.checkState((boolean)started);
        TooltipRenderer.icon = PluginConfig.INSTANCE.getBoolean(WailaConstants.CONFIG_SHOW_ICON) ? icon : EmptyComponent.INSTANCE;
    }

    public static void endBuild() {
        Preconditions.checkState((boolean)started);
        if (state.fireEvent()) {
            for (IEventListener listener : Registrar.INSTANCE.eventListeners.get(Object.class)) {
                listener.onHandleTooltip(TOOLTIP, DataAccessor.INSTANCE, PluginConfig.INSTANCE);
            }
        }
        TooltipRenderer.narrateObjectName();
        class_310 client = class_310.method_1551();
        class_1041 window = client.method_22683();
        float scale = state.getScale();
        int w = 0;
        int h = 0;
        ObjectListIterator objectListIterator = TOOLTIP.iterator();
        while (objectListIterator.hasNext()) {
            Line line = (Line)objectListIterator.next();
            int lineW = line.getWidth();
            int lineH = line.getHeight();
            w = Math.max(w, lineW);
            h += lineH;
            LINE_HEIGHT.put((Object)line, lineH);
        }
        topOffset = 0;
        if (icon.getHeight() > h) {
            topOffset = class_3532.method_38788((int)(icon.getHeight() - h), (int)2);
        }
        if (icon.getWidth() > 0) {
            w += icon.getWidth() + 3;
        }
        w += 6;
        h = Math.max(h, icon.getHeight()) + TOOLTIP.size() - 1 + 6;
        int windowW = (int)((float)window.method_4486() / scale);
        int windowH = (int)((float)window.method_4502() / scale);
        IWailaConfig.Overlay.Position.Align.X anchorX = state.getXAnchor();
        IWailaConfig.Overlay.Position.Align.Y anchorY = state.getYAnchor();
        IWailaConfig.Overlay.Position.Align.X alignX = state.getXAlign();
        IWailaConfig.Overlay.Position.Align.Y alignY = state.getYAlign();
        double x = (double)windowW * anchorX.multiplier - (double)w * alignX.multiplier + (double)state.getX();
        double y = (double)windowH * anchorY.multiplier - (double)h * alignY.multiplier + (double)state.getY();
        if (!state.bossBarsOverlap() && anchorX == IWailaConfig.Overlay.Position.Align.X.CENTER && anchorY == IWailaConfig.Overlay.Position.Align.Y.TOP) {
            y += (double)Math.min(client.field_1705.method_1740().field_2060.size() * 19, window.method_4502() / 3 + 2);
        }
        RECT.get().setRect(x, y, w, h);
        started = false;
    }

    public static void resetState() {
        state = null;
    }

    public static void render(class_4587 matrices, float delta) {
        if (state == null || !state.render()) {
            return;
        }
        class_310 client = class_310.method_1551();
        class_3695 profiler = client.method_16011();
        profiler.method_15396("Waila Overlay");
        float scale = state.getScale();
        RenderSystem.getModelViewStack().method_22903();
        RenderSystem.getModelViewStack().method_22905(scale, scale, 1.0f);
        RenderSystem.applyModelViewMatrix();
        matrices.method_22903();
        DisplayUtil.enable2DRender();
        Rectangle rect = RENDER_RECT.get();
        rect.setRect(RECT.get());
        if (state.fireEvent()) {
            EventCanceller canceller = EventCanceller.INSTANCE;
            canceller.setCanceled(false);
            for (IEventListener listener : Registrar.INSTANCE.eventListeners.get(Object.class)) {
                listener.onBeforeTooltipRender(matrices, rect, DataAccessor.INSTANCE, PluginConfig.INSTANCE, canceller);
                if (!canceller.isCanceled()) continue;
                matrices.method_22909();
                RenderSystem.enableDepthTest();
                RenderSystem.getModelViewStack().method_22909();
                RenderSystem.applyModelViewMatrix();
                profiler.method_15407();
                return;
            }
        }
        int x = rect.x;
        int y = rect.y;
        int width = rect.width;
        int height = rect.height;
        RenderSystem.disableTexture();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.setShader(class_757::method_34540);
        class_289 tesselator = class_289.method_1348();
        class_287 buf = tesselator.method_1349();
        buf.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
        class_1159 matrix = matrices.method_23760().method_23761();
        int background = state.getBg();
        int gradStart = state.getGradStart();
        int gradEnd = state.getGradEnd();
        DisplayUtil.fillGradient(matrix, buf, x + 1, y, width - 1, 1, background, background);
        DisplayUtil.fillGradient(matrix, buf, x + 1, y + height, width - 1, 1, background, background);
        DisplayUtil.fillGradient(matrix, buf, x + 1, y + 1, width - 1, height - 1, background, background);
        DisplayUtil.fillGradient(matrix, buf, x, y + 1, 1, height - 1, background, background);
        DisplayUtil.fillGradient(matrix, buf, x + width, y + 1, 1, height - 1, background, background);
        DisplayUtil.fillGradient(matrix, buf, x + 1, y + 2, 1, height - 3, gradStart, gradEnd);
        DisplayUtil.fillGradient(matrix, buf, x + width - 1, y + 2, 1, height - 3, gradStart, gradEnd);
        DisplayUtil.fillGradient(matrix, buf, x + 1, y + 1, width - 1, 1, gradStart, gradStart);
        DisplayUtil.fillGradient(matrix, buf, x + 1, y + height - 1, width - 1, 1, gradEnd, gradEnd);
        tesselator.method_1350();
        RenderSystem.enableTexture();
        int textX = x + (icon.getWidth() > 0 ? icon.getWidth() + 7 : 4);
        int textY = y + 4 + topOffset;
        ObjectListIterator objectListIterator = TOOLTIP.iterator();
        while (objectListIterator.hasNext()) {
            Line line = (Line)objectListIterator.next();
            line.render(matrices, textX, textY, delta);
            textY += LINE_HEIGHT.getInt((Object)line) + 1;
        }
        RenderSystem.disableBlend();
        matrices.method_22909();
        if (state.fireEvent()) {
            for (IEventListener listener : Registrar.INSTANCE.eventListeners.get(Object.class)) {
                listener.onAfterTooltipRender(matrices, rect, DataAccessor.INSTANCE, PluginConfig.INSTANCE);
            }
        }
        icon.render(matrices, x + 4, y + class_3532.method_38788((int)(height - icon.getHeight()), (int)2), delta);
        RenderSystem.enableDepthTest();
        RenderSystem.getModelViewStack().method_22909();
        RenderSystem.applyModelViewMatrix();
        profiler.method_15407();
    }

    private static void narrateObjectName() {
        ITooltipComponent iTooltipComponent;
        if (!state.render()) {
            return;
        }
        Narrator narrator = NARRATOR.get();
        if (narrator.active() || !state.enableTextToSpeech() || class_310.method_1551().field_1755 instanceof class_408) {
            return;
        }
        Line objectName = TOOLTIP.getLine(WailaConstants.OBJECT_NAME_TAG);
        if (objectName != null && (iTooltipComponent = objectName.components.get(0)) instanceof WrappedComponent) {
            WrappedComponent component = (WrappedComponent)iTooltipComponent;
            String narrate = component.component.getString();
            if (!lastNarration.equalsIgnoreCase(narrate)) {
                narrator.clear();
                narrator.say(narrate, true);
                lastNarration = narrate;
            }
        }
    }

    static {
        lastNarration = "";
        icon = EmptyComponent.INSTANCE;
    }

    public static interface State {
        public boolean render();

        public boolean fireEvent();

        public float getScale();

        public IWailaConfig.Overlay.Position.Align.X getXAnchor();

        public IWailaConfig.Overlay.Position.Align.Y getYAnchor();

        public IWailaConfig.Overlay.Position.Align.X getXAlign();

        public IWailaConfig.Overlay.Position.Align.Y getYAlign();

        public int getX();

        public int getY();

        public boolean bossBarsOverlap();

        public int getBg();

        public int getGradStart();

        public int getGradEnd();

        public boolean enableTextToSpeech();

        public int getFontColor();
    }
}

