/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.entries.TextFieldListEntry;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_342;
import org.jetbrains.annotations.ApiStatus;

@Environment(value=EnvType.CLIENT)
public class FloatListEntry
extends TextFieldListEntry<Float> {
    private static final Function<String, String> stripCharacters = s -> {
        StringBuilder stringBuilder_1 = new StringBuilder();
        char[] var2 = s.toCharArray();
        int var3 = var2.length;
        for (char c : var2) {
            if (!Character.isDigit(c) && c != '-' && c != '.') continue;
            stringBuilder_1.append(c);
        }
        return stringBuilder_1.toString();
    };
    private float minimum = -3.4028235E38f;
    private float maximum = Float.MAX_VALUE;
    private final Consumer<Float> saveConsumer;

    @Deprecated
    @ApiStatus.Internal
    public FloatListEntry(class_2561 fieldName, Float value, class_2561 resetButtonKey, Supplier<Float> defaultValue, Consumer<Float> saveConsumer) {
        super(fieldName, value, resetButtonKey, defaultValue);
        this.saveConsumer = saveConsumer;
    }

    @Deprecated
    @ApiStatus.Internal
    public FloatListEntry(class_2561 fieldName, Float value, class_2561 resetButtonKey, Supplier<Float> defaultValue, Consumer<Float> saveConsumer, Supplier<Optional<class_2561[]>> tooltipSupplier) {
        this(fieldName, value, resetButtonKey, defaultValue, saveConsumer, tooltipSupplier, false);
    }

    @Deprecated
    @ApiStatus.Internal
    public FloatListEntry(class_2561 fieldName, Float value, class_2561 resetButtonKey, Supplier<Float> defaultValue, Consumer<Float> saveConsumer, Supplier<Optional<class_2561[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, value, resetButtonKey, defaultValue, tooltipSupplier, requiresRestart);
        this.saveConsumer = saveConsumer;
    }

    @Override
    protected String stripAddText(String s) {
        return stripCharacters.apply(s);
    }

    @Override
    protected void textFieldPreRender(class_342 widget) {
        try {
            double i = Float.parseFloat(this.textFieldWidget.method_1882());
            if (i < (double)this.minimum || i > (double)this.maximum) {
                widget.method_1868(0xFF5555);
            } else {
                widget.method_1868(0xE0E0E0);
            }
        }
        catch (NumberFormatException ex) {
            widget.method_1868(0xFF5555);
        }
    }

    @Override
    protected boolean isMatchDefault(String text) {
        return this.getDefaultValue().isPresent() && text.equals(((Float)this.defaultValue.get()).toString());
    }

    public FloatListEntry setMinimum(float minimum) {
        this.minimum = minimum;
        return this;
    }

    public FloatListEntry setMaximum(float maximum) {
        this.maximum = maximum;
        return this;
    }

    @Override
    public void save() {
        if (this.saveConsumer != null) {
            this.saveConsumer.accept(this.getValue());
        }
    }

    @Override
    public Float getValue() {
        try {
            return Float.valueOf(this.textFieldWidget.method_1882());
        }
        catch (Exception e) {
            return Float.valueOf(0.0f);
        }
    }

    @Override
    public Optional<class_2561> getError() {
        try {
            float i = Float.parseFloat(this.textFieldWidget.method_1882());
            if (i > this.maximum) {
                return Optional.of(class_2561.method_43469((String)"text.cloth-config.error.too_large", (Object[])new Object[]{Float.valueOf(this.maximum)}));
            }
            if (i < this.minimum) {
                return Optional.of(class_2561.method_43469((String)"text.cloth-config.error.too_small", (Object[])new Object[]{Float.valueOf(this.minimum)}));
            }
        }
        catch (NumberFormatException ex) {
            return Optional.of(class_2561.method_43471((String)"text.cloth-config.error.not_valid_number_float"));
        }
        return super.getError();
    }
}

