/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.vendored.joml;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.text.NumberFormat;
import net.coderbot.iris.vendored.joml.Math;
import net.coderbot.iris.vendored.joml.Matrix3dc;
import net.coderbot.iris.vendored.joml.Matrix3fc;
import net.coderbot.iris.vendored.joml.Matrix3x2fc;
import net.coderbot.iris.vendored.joml.Matrix4dc;
import net.coderbot.iris.vendored.joml.Matrix4fc;
import net.coderbot.iris.vendored.joml.Matrix4x3fc;
import net.coderbot.iris.vendored.joml.MemUtil;
import net.coderbot.iris.vendored.joml.Options;
import net.coderbot.iris.vendored.joml.Quaternionf;
import net.coderbot.iris.vendored.joml.Quaternionfc;
import net.coderbot.iris.vendored.joml.Runtime;
import net.coderbot.iris.vendored.joml.Vector2dc;
import net.coderbot.iris.vendored.joml.Vector2fc;
import net.coderbot.iris.vendored.joml.Vector2ic;
import net.coderbot.iris.vendored.joml.Vector3d;
import net.coderbot.iris.vendored.joml.Vector3dc;
import net.coderbot.iris.vendored.joml.Vector3fc;
import net.coderbot.iris.vendored.joml.Vector3i;
import net.coderbot.iris.vendored.joml.Vector3ic;

public class Vector3f
implements Externalizable,
Cloneable,
Vector3fc {
    private static final long serialVersionUID = 1L;
    public float x;
    public float y;
    public float z;

    public Vector3f() {
    }

    public Vector3f(float f) {
        this.x = f;
        this.y = f;
        this.z = f;
    }

    public Vector3f(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
    }

    public Vector3f(Vector3fc vector3fc) {
        this.x = vector3fc.x();
        this.y = vector3fc.y();
        this.z = vector3fc.z();
    }

    public Vector3f(Vector3ic vector3ic) {
        this.x = vector3ic.x();
        this.y = vector3ic.y();
        this.z = vector3ic.z();
    }

    public Vector3f(Vector2fc vector2fc, float f) {
        this.x = vector2fc.x();
        this.y = vector2fc.y();
        this.z = f;
    }

    public Vector3f(Vector2ic vector2ic, float f) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
        this.z = f;
    }

    public Vector3f(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
        this.z = fArray[2];
    }

    public Vector3f(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
    }

    public Vector3f(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n, byteBuffer);
    }

    public Vector3f(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, floatBuffer.position(), floatBuffer);
    }

    public Vector3f(int n, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, n, floatBuffer);
    }

    @Override
    public float x() {
        return this.x;
    }

    @Override
    public float y() {
        return this.y;
    }

    @Override
    public float z() {
        return this.z;
    }

    public Vector3f set(Vector3fc vector3fc) {
        this.x = vector3fc.x();
        this.y = vector3fc.y();
        this.z = vector3fc.z();
        return this;
    }

    public Vector3f set(Vector3dc vector3dc) {
        this.x = (float)vector3dc.x();
        this.y = (float)vector3dc.y();
        this.z = (float)vector3dc.z();
        return this;
    }

    public Vector3f set(Vector3ic vector3ic) {
        this.x = vector3ic.x();
        this.y = vector3ic.y();
        this.z = vector3ic.z();
        return this;
    }

    public Vector3f set(Vector2fc vector2fc, float f) {
        this.x = vector2fc.x();
        this.y = vector2fc.y();
        this.z = f;
        return this;
    }

    public Vector3f set(Vector2dc vector2dc, float f) {
        this.x = (float)vector2dc.x();
        this.y = (float)vector2dc.y();
        this.z = f;
        return this;
    }

    public Vector3f set(Vector2ic vector2ic, float f) {
        this.x = vector2ic.x();
        this.y = vector2ic.y();
        this.z = f;
        return this;
    }

    public Vector3f set(float f) {
        this.x = f;
        this.y = f;
        this.z = f;
        return this;
    }

    public Vector3f set(float f, float f2, float f3) {
        this.x = f;
        this.y = f2;
        this.z = f3;
        return this;
    }

    public Vector3f set(double d) {
        this.x = (float)d;
        this.y = (float)d;
        this.z = (float)d;
        return this;
    }

    public Vector3f set(double d, double d2, double d3) {
        this.x = (float)d;
        this.y = (float)d2;
        this.z = (float)d3;
        return this;
    }

    public Vector3f set(float[] fArray) {
        this.x = fArray[0];
        this.y = fArray[1];
        this.z = fArray[2];
        return this;
    }

    public Vector3f set(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, byteBuffer.position(), byteBuffer);
        return this;
    }

    public Vector3f set(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.get(this, n, byteBuffer);
        return this;
    }

    public Vector3f set(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, floatBuffer.position(), floatBuffer);
        return this;
    }

    public Vector3f set(int n, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.get(this, n, floatBuffer);
        return this;
    }

    public Vector3f setComponent(int n, float f) throws IllegalArgumentException {
        switch (n) {
            case 0: {
                this.x = f;
                break;
            }
            case 1: {
                this.y = f;
                break;
            }
            case 2: {
                this.z = f;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        return this;
    }

    @Override
    public FloatBuffer get(FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put(this, floatBuffer.position(), floatBuffer);
        return floatBuffer;
    }

    @Override
    public FloatBuffer get(int n, FloatBuffer floatBuffer) {
        MemUtil.INSTANCE.put(this, n, floatBuffer);
        return floatBuffer;
    }

    @Override
    public ByteBuffer get(ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, byteBuffer.position(), byteBuffer);
        return byteBuffer;
    }

    @Override
    public ByteBuffer get(int n, ByteBuffer byteBuffer) {
        MemUtil.INSTANCE.put(this, n, byteBuffer);
        return byteBuffer;
    }

    public Vector3f sub(Vector3fc vector3fc) {
        this.x -= vector3fc.x();
        this.y -= vector3fc.y();
        this.z -= vector3fc.z();
        return this;
    }

    @Override
    public Vector3f sub(Vector3fc vector3fc, Vector3f vector3f) {
        vector3f.x = this.x - vector3fc.x();
        vector3f.y = this.y - vector3fc.y();
        vector3f.z = this.z - vector3fc.z();
        return vector3f;
    }

    public Vector3f sub(float f, float f2, float f3) {
        this.x -= f;
        this.y -= f2;
        this.z -= f3;
        return this;
    }

    @Override
    public Vector3f sub(float f, float f2, float f3, Vector3f vector3f) {
        vector3f.x = this.x - f;
        vector3f.y = this.y - f2;
        vector3f.z = this.z - f3;
        return vector3f;
    }

    public Vector3f add(Vector3fc vector3fc) {
        this.x += vector3fc.x();
        this.y += vector3fc.y();
        this.z += vector3fc.z();
        return this;
    }

    @Override
    public Vector3f add(Vector3fc vector3fc, Vector3f vector3f) {
        vector3f.x = this.x + vector3fc.x();
        vector3f.y = this.y + vector3fc.y();
        vector3f.z = this.z + vector3fc.z();
        return vector3f;
    }

    public Vector3f add(float f, float f2, float f3) {
        this.x += f;
        this.y += f2;
        this.z += f3;
        return this;
    }

    @Override
    public Vector3f add(float f, float f2, float f3, Vector3f vector3f) {
        vector3f.x = this.x + f;
        vector3f.y = this.y + f2;
        vector3f.z = this.z + f3;
        return vector3f;
    }

    public Vector3f fma(Vector3fc vector3fc, Vector3fc vector3fc2) {
        this.x = Math.fma(vector3fc.x(), vector3fc2.x(), this.x);
        this.y = Math.fma(vector3fc.y(), vector3fc2.y(), this.y);
        this.z = Math.fma(vector3fc.z(), vector3fc2.z(), this.z);
        return this;
    }

    public Vector3f fma(float f, Vector3fc vector3fc) {
        this.x = Math.fma(f, vector3fc.x(), this.x);
        this.y = Math.fma(f, vector3fc.y(), this.y);
        this.z = Math.fma(f, vector3fc.z(), this.z);
        return this;
    }

    @Override
    public Vector3f fma(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3f vector3f) {
        vector3f.x = Math.fma(vector3fc.x(), vector3fc2.x(), this.x);
        vector3f.y = Math.fma(vector3fc.y(), vector3fc2.y(), this.y);
        vector3f.z = Math.fma(vector3fc.z(), vector3fc2.z(), this.z);
        return vector3f;
    }

    @Override
    public Vector3f fma(float f, Vector3fc vector3fc, Vector3f vector3f) {
        vector3f.x = Math.fma(f, vector3fc.x(), this.x);
        vector3f.y = Math.fma(f, vector3fc.y(), this.y);
        vector3f.z = Math.fma(f, vector3fc.z(), this.z);
        return vector3f;
    }

    public Vector3f mulAdd(Vector3fc vector3fc, Vector3fc vector3fc2) {
        this.x = Math.fma(this.x, vector3fc.x(), vector3fc2.x());
        this.y = Math.fma(this.y, vector3fc.y(), vector3fc2.y());
        this.z = Math.fma(this.z, vector3fc.z(), vector3fc2.z());
        return this;
    }

    public Vector3f mulAdd(float f, Vector3fc vector3fc) {
        this.x = Math.fma(this.x, f, vector3fc.x());
        this.y = Math.fma(this.y, f, vector3fc.y());
        this.z = Math.fma(this.z, f, vector3fc.z());
        return this;
    }

    @Override
    public Vector3f mulAdd(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3f vector3f) {
        vector3f.x = Math.fma(this.x, vector3fc.x(), vector3fc2.x());
        vector3f.y = Math.fma(this.y, vector3fc.y(), vector3fc2.y());
        vector3f.z = Math.fma(this.z, vector3fc.z(), vector3fc2.z());
        return vector3f;
    }

    @Override
    public Vector3f mulAdd(float f, Vector3fc vector3fc, Vector3f vector3f) {
        vector3f.x = Math.fma(this.x, f, vector3fc.x());
        vector3f.y = Math.fma(this.y, f, vector3fc.y());
        vector3f.z = Math.fma(this.z, f, vector3fc.z());
        return vector3f;
    }

    public Vector3f mul(Vector3fc vector3fc) {
        this.x *= vector3fc.x();
        this.y *= vector3fc.y();
        this.z *= vector3fc.z();
        return this;
    }

    @Override
    public Vector3f mul(Vector3fc vector3fc, Vector3f vector3f) {
        vector3f.x = this.x * vector3fc.x();
        vector3f.y = this.y * vector3fc.y();
        vector3f.z = this.z * vector3fc.z();
        return vector3f;
    }

    public Vector3f div(Vector3fc vector3fc) {
        this.x /= vector3fc.x();
        this.y /= vector3fc.y();
        this.z /= vector3fc.z();
        return this;
    }

    @Override
    public Vector3f div(Vector3fc vector3fc, Vector3f vector3f) {
        vector3f.x = this.x / vector3fc.x();
        vector3f.y = this.y / vector3fc.y();
        vector3f.z = this.z / vector3fc.z();
        return vector3f;
    }

    @Override
    public Vector3f mulProject(Matrix4fc matrix4fc, Vector3f vector3f) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        float f4 = 1.0f / Math.fma(matrix4fc.m03(), f, Math.fma(matrix4fc.m13(), f2, Math.fma(matrix4fc.m23(), f3, matrix4fc.m33())));
        vector3f.x = Math.fma(matrix4fc.m00(), f, Math.fma(matrix4fc.m10(), f2, Math.fma(matrix4fc.m20(), f3, matrix4fc.m30()))) * f4;
        vector3f.y = Math.fma(matrix4fc.m01(), f, Math.fma(matrix4fc.m11(), f2, Math.fma(matrix4fc.m21(), f3, matrix4fc.m31()))) * f4;
        vector3f.z = Math.fma(matrix4fc.m02(), f, Math.fma(matrix4fc.m12(), f2, Math.fma(matrix4fc.m22(), f3, matrix4fc.m32()))) * f4;
        return vector3f;
    }

    @Override
    public Vector3f mulProject(Matrix4fc matrix4fc, float f, Vector3f vector3f) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        float f5 = 1.0f / Math.fma(matrix4fc.m03(), f2, Math.fma(matrix4fc.m13(), f3, Math.fma(matrix4fc.m23(), f4, matrix4fc.m33() * f)));
        vector3f.x = Math.fma(matrix4fc.m00(), f2, Math.fma(matrix4fc.m10(), f3, Math.fma(matrix4fc.m20(), f4, matrix4fc.m30() * f))) * f5;
        vector3f.y = Math.fma(matrix4fc.m01(), f2, Math.fma(matrix4fc.m11(), f3, Math.fma(matrix4fc.m21(), f4, matrix4fc.m31() * f))) * f5;
        vector3f.z = Math.fma(matrix4fc.m02(), f2, Math.fma(matrix4fc.m12(), f3, Math.fma(matrix4fc.m22(), f4, matrix4fc.m32() * f))) * f5;
        return vector3f;
    }

    public Vector3f mulProject(Matrix4fc matrix4fc) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        float f4 = 1.0f / Math.fma(matrix4fc.m03(), f, Math.fma(matrix4fc.m13(), f2, Math.fma(matrix4fc.m23(), f3, matrix4fc.m33())));
        this.x = Math.fma(matrix4fc.m00(), f, Math.fma(matrix4fc.m10(), f2, Math.fma(matrix4fc.m20(), f3, matrix4fc.m30()))) * f4;
        this.y = Math.fma(matrix4fc.m01(), f, Math.fma(matrix4fc.m11(), f2, Math.fma(matrix4fc.m21(), f3, matrix4fc.m31()))) * f4;
        this.z = Math.fma(matrix4fc.m02(), f, Math.fma(matrix4fc.m12(), f2, Math.fma(matrix4fc.m22(), f3, matrix4fc.m32()))) * f4;
        return this;
    }

    public Vector3f mul(Matrix3fc matrix3fc) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        this.x = Math.fma(matrix3fc.m00(), f, Math.fma(matrix3fc.m10(), f2, matrix3fc.m20() * f3));
        this.y = Math.fma(matrix3fc.m01(), f, Math.fma(matrix3fc.m11(), f2, matrix3fc.m21() * f3));
        this.z = Math.fma(matrix3fc.m02(), f, Math.fma(matrix3fc.m12(), f2, matrix3fc.m22() * f3));
        return this;
    }

    @Override
    public Vector3f mul(Matrix3fc matrix3fc, Vector3f vector3f) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        vector3f.x = Math.fma(matrix3fc.m00(), f, Math.fma(matrix3fc.m10(), f2, matrix3fc.m20() * f3));
        vector3f.y = Math.fma(matrix3fc.m01(), f, Math.fma(matrix3fc.m11(), f2, matrix3fc.m21() * f3));
        vector3f.z = Math.fma(matrix3fc.m02(), f, Math.fma(matrix3fc.m12(), f2, matrix3fc.m22() * f3));
        return vector3f;
    }

    public Vector3f mul(Matrix3dc matrix3dc) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        this.x = (float)Math.fma(matrix3dc.m00(), (double)f, Math.fma(matrix3dc.m10(), (double)f2, matrix3dc.m20() * (double)f3));
        this.y = (float)Math.fma(matrix3dc.m01(), (double)f, Math.fma(matrix3dc.m11(), (double)f2, matrix3dc.m21() * (double)f3));
        this.z = (float)Math.fma(matrix3dc.m02(), (double)f, Math.fma(matrix3dc.m12(), (double)f2, matrix3dc.m22() * (double)f3));
        return this;
    }

    @Override
    public Vector3f mul(Matrix3dc matrix3dc, Vector3f vector3f) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        vector3f.x = (float)Math.fma(matrix3dc.m00(), (double)f, Math.fma(matrix3dc.m10(), (double)f2, matrix3dc.m20() * (double)f3));
        vector3f.y = (float)Math.fma(matrix3dc.m01(), (double)f, Math.fma(matrix3dc.m11(), (double)f2, matrix3dc.m21() * (double)f3));
        vector3f.z = (float)Math.fma(matrix3dc.m02(), (double)f, Math.fma(matrix3dc.m12(), (double)f2, matrix3dc.m22() * (double)f3));
        return vector3f;
    }

    public Vector3f mul(Matrix3x2fc matrix3x2fc) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        this.x = Math.fma(matrix3x2fc.m00(), f, Math.fma(matrix3x2fc.m10(), f2, matrix3x2fc.m20() * f3));
        this.y = Math.fma(matrix3x2fc.m01(), f, Math.fma(matrix3x2fc.m11(), f2, matrix3x2fc.m21() * f3));
        this.z = f3;
        return this;
    }

    @Override
    public Vector3f mul(Matrix3x2fc matrix3x2fc, Vector3f vector3f) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        vector3f.x = Math.fma(matrix3x2fc.m00(), f, Math.fma(matrix3x2fc.m10(), f2, matrix3x2fc.m20() * f3));
        vector3f.y = Math.fma(matrix3x2fc.m01(), f, Math.fma(matrix3x2fc.m11(), f2, matrix3x2fc.m21() * f3));
        vector3f.z = f3;
        return vector3f;
    }

    public Vector3f mulTranspose(Matrix3fc matrix3fc) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        this.x = Math.fma(matrix3fc.m00(), f, Math.fma(matrix3fc.m01(), f2, matrix3fc.m02() * f3));
        this.y = Math.fma(matrix3fc.m10(), f, Math.fma(matrix3fc.m11(), f2, matrix3fc.m12() * f3));
        this.z = Math.fma(matrix3fc.m20(), f, Math.fma(matrix3fc.m21(), f2, matrix3fc.m22() * f3));
        return this;
    }

    @Override
    public Vector3f mulTranspose(Matrix3fc matrix3fc, Vector3f vector3f) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        vector3f.x = Math.fma(matrix3fc.m00(), f, Math.fma(matrix3fc.m01(), f2, matrix3fc.m02() * f3));
        vector3f.y = Math.fma(matrix3fc.m10(), f, Math.fma(matrix3fc.m11(), f2, matrix3fc.m12() * f3));
        vector3f.z = Math.fma(matrix3fc.m20(), f, Math.fma(matrix3fc.m21(), f2, matrix3fc.m22() * f3));
        return vector3f;
    }

    public Vector3f mulPosition(Matrix4fc matrix4fc) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        this.x = Math.fma(matrix4fc.m00(), f, Math.fma(matrix4fc.m10(), f2, Math.fma(matrix4fc.m20(), f3, matrix4fc.m30())));
        this.y = Math.fma(matrix4fc.m01(), f, Math.fma(matrix4fc.m11(), f2, Math.fma(matrix4fc.m21(), f3, matrix4fc.m31())));
        this.z = Math.fma(matrix4fc.m02(), f, Math.fma(matrix4fc.m12(), f2, Math.fma(matrix4fc.m22(), f3, matrix4fc.m32())));
        return this;
    }

    public Vector3f mulPosition(Matrix4x3fc matrix4x3fc) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        this.x = Math.fma(matrix4x3fc.m00(), f, Math.fma(matrix4x3fc.m10(), f2, Math.fma(matrix4x3fc.m20(), f3, matrix4x3fc.m30())));
        this.y = Math.fma(matrix4x3fc.m01(), f, Math.fma(matrix4x3fc.m11(), f2, Math.fma(matrix4x3fc.m21(), f3, matrix4x3fc.m31())));
        this.z = Math.fma(matrix4x3fc.m02(), f, Math.fma(matrix4x3fc.m12(), f2, Math.fma(matrix4x3fc.m22(), f3, matrix4x3fc.m32())));
        return this;
    }

    @Override
    public Vector3f mulPosition(Matrix4fc matrix4fc, Vector3f vector3f) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        vector3f.x = Math.fma(matrix4fc.m00(), f, Math.fma(matrix4fc.m10(), f2, Math.fma(matrix4fc.m20(), f3, matrix4fc.m30())));
        vector3f.y = Math.fma(matrix4fc.m01(), f, Math.fma(matrix4fc.m11(), f2, Math.fma(matrix4fc.m21(), f3, matrix4fc.m31())));
        vector3f.z = Math.fma(matrix4fc.m02(), f, Math.fma(matrix4fc.m12(), f2, Math.fma(matrix4fc.m22(), f3, matrix4fc.m32())));
        return vector3f;
    }

    @Override
    public Vector3f mulPosition(Matrix4x3fc matrix4x3fc, Vector3f vector3f) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        vector3f.x = Math.fma(matrix4x3fc.m00(), f, Math.fma(matrix4x3fc.m10(), f2, Math.fma(matrix4x3fc.m20(), f3, matrix4x3fc.m30())));
        vector3f.y = Math.fma(matrix4x3fc.m01(), f, Math.fma(matrix4x3fc.m11(), f2, Math.fma(matrix4x3fc.m21(), f3, matrix4x3fc.m31())));
        vector3f.z = Math.fma(matrix4x3fc.m02(), f, Math.fma(matrix4x3fc.m12(), f2, Math.fma(matrix4x3fc.m22(), f3, matrix4x3fc.m32())));
        return vector3f;
    }

    public Vector3f mulTransposePosition(Matrix4fc matrix4fc) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        this.x = Math.fma(matrix4fc.m00(), f, Math.fma(matrix4fc.m01(), f2, Math.fma(matrix4fc.m02(), f3, matrix4fc.m03())));
        this.y = Math.fma(matrix4fc.m10(), f, Math.fma(matrix4fc.m11(), f2, Math.fma(matrix4fc.m12(), f3, matrix4fc.m13())));
        this.z = Math.fma(matrix4fc.m20(), f, Math.fma(matrix4fc.m21(), f2, Math.fma(matrix4fc.m22(), f3, matrix4fc.m23())));
        return this;
    }

    @Override
    public Vector3f mulTransposePosition(Matrix4fc matrix4fc, Vector3f vector3f) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        vector3f.x = Math.fma(matrix4fc.m00(), f, Math.fma(matrix4fc.m01(), f2, Math.fma(matrix4fc.m02(), f3, matrix4fc.m03())));
        vector3f.y = Math.fma(matrix4fc.m10(), f, Math.fma(matrix4fc.m11(), f2, Math.fma(matrix4fc.m12(), f3, matrix4fc.m13())));
        vector3f.z = Math.fma(matrix4fc.m20(), f, Math.fma(matrix4fc.m21(), f2, Math.fma(matrix4fc.m22(), f3, matrix4fc.m23())));
        return vector3f;
    }

    public float mulPositionW(Matrix4fc matrix4fc) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        float f4 = Math.fma(matrix4fc.m03(), f, Math.fma(matrix4fc.m13(), f2, Math.fma(matrix4fc.m23(), f3, matrix4fc.m33())));
        this.x = Math.fma(matrix4fc.m00(), f, Math.fma(matrix4fc.m10(), f2, Math.fma(matrix4fc.m20(), f3, matrix4fc.m30())));
        this.y = Math.fma(matrix4fc.m01(), f, Math.fma(matrix4fc.m11(), f2, Math.fma(matrix4fc.m21(), f3, matrix4fc.m31())));
        this.z = Math.fma(matrix4fc.m02(), f, Math.fma(matrix4fc.m12(), f2, Math.fma(matrix4fc.m22(), f3, matrix4fc.m32())));
        return f4;
    }

    @Override
    public float mulPositionW(Matrix4fc matrix4fc, Vector3f vector3f) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        float f4 = Math.fma(matrix4fc.m03(), f, Math.fma(matrix4fc.m13(), f2, Math.fma(matrix4fc.m23(), f3, matrix4fc.m33())));
        vector3f.x = Math.fma(matrix4fc.m00(), f, Math.fma(matrix4fc.m10(), f2, Math.fma(matrix4fc.m20(), f3, matrix4fc.m30())));
        vector3f.y = Math.fma(matrix4fc.m01(), f, Math.fma(matrix4fc.m11(), f2, Math.fma(matrix4fc.m21(), f3, matrix4fc.m31())));
        vector3f.z = Math.fma(matrix4fc.m02(), f, Math.fma(matrix4fc.m12(), f2, Math.fma(matrix4fc.m22(), f3, matrix4fc.m32())));
        return f4;
    }

    public Vector3f mulDirection(Matrix4dc matrix4dc) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        this.x = (float)Math.fma(matrix4dc.m00(), (double)f, Math.fma(matrix4dc.m10(), (double)f2, matrix4dc.m20() * (double)f3));
        this.y = (float)Math.fma(matrix4dc.m01(), (double)f, Math.fma(matrix4dc.m11(), (double)f2, matrix4dc.m21() * (double)f3));
        this.z = (float)Math.fma(matrix4dc.m02(), (double)f, Math.fma(matrix4dc.m12(), (double)f2, matrix4dc.m22() * (double)f3));
        return this;
    }

    public Vector3f mulDirection(Matrix4fc matrix4fc) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        this.x = Math.fma(matrix4fc.m00(), f, Math.fma(matrix4fc.m10(), f2, matrix4fc.m20() * f3));
        this.y = Math.fma(matrix4fc.m01(), f, Math.fma(matrix4fc.m11(), f2, matrix4fc.m21() * f3));
        this.z = Math.fma(matrix4fc.m02(), f, Math.fma(matrix4fc.m12(), f2, matrix4fc.m22() * f3));
        return this;
    }

    public Vector3f mulDirection(Matrix4x3fc matrix4x3fc) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        this.x = Math.fma(matrix4x3fc.m00(), f, Math.fma(matrix4x3fc.m10(), f2, matrix4x3fc.m20() * f3));
        this.y = Math.fma(matrix4x3fc.m01(), f, Math.fma(matrix4x3fc.m11(), f2, matrix4x3fc.m21() * f3));
        this.z = Math.fma(matrix4x3fc.m02(), f, Math.fma(matrix4x3fc.m12(), f2, matrix4x3fc.m22() * f3));
        return this;
    }

    @Override
    public Vector3f mulDirection(Matrix4dc matrix4dc, Vector3f vector3f) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        vector3f.x = (float)Math.fma(matrix4dc.m00(), (double)f, Math.fma(matrix4dc.m10(), (double)f2, matrix4dc.m20() * (double)f3));
        vector3f.y = (float)Math.fma(matrix4dc.m01(), (double)f, Math.fma(matrix4dc.m11(), (double)f2, matrix4dc.m21() * (double)f3));
        vector3f.z = (float)Math.fma(matrix4dc.m02(), (double)f, Math.fma(matrix4dc.m12(), (double)f2, matrix4dc.m22() * (double)f3));
        return vector3f;
    }

    @Override
    public Vector3f mulDirection(Matrix4fc matrix4fc, Vector3f vector3f) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        vector3f.x = Math.fma(matrix4fc.m00(), f, Math.fma(matrix4fc.m10(), f2, matrix4fc.m20() * f3));
        vector3f.y = Math.fma(matrix4fc.m01(), f, Math.fma(matrix4fc.m11(), f2, matrix4fc.m21() * f3));
        vector3f.z = Math.fma(matrix4fc.m02(), f, Math.fma(matrix4fc.m12(), f2, matrix4fc.m22() * f3));
        return vector3f;
    }

    @Override
    public Vector3f mulDirection(Matrix4x3fc matrix4x3fc, Vector3f vector3f) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        vector3f.x = Math.fma(matrix4x3fc.m00(), f, Math.fma(matrix4x3fc.m10(), f2, matrix4x3fc.m20() * f3));
        vector3f.y = Math.fma(matrix4x3fc.m01(), f, Math.fma(matrix4x3fc.m11(), f2, matrix4x3fc.m21() * f3));
        vector3f.z = Math.fma(matrix4x3fc.m02(), f, Math.fma(matrix4x3fc.m12(), f2, matrix4x3fc.m22() * f3));
        return vector3f;
    }

    public Vector3f mulTransposeDirection(Matrix4fc matrix4fc) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        this.x = Math.fma(matrix4fc.m00(), f, Math.fma(matrix4fc.m01(), f2, matrix4fc.m02() * f3));
        this.y = Math.fma(matrix4fc.m10(), f, Math.fma(matrix4fc.m11(), f2, matrix4fc.m12() * f3));
        this.z = Math.fma(matrix4fc.m20(), f, Math.fma(matrix4fc.m21(), f2, matrix4fc.m22() * f3));
        return this;
    }

    @Override
    public Vector3f mulTransposeDirection(Matrix4fc matrix4fc, Vector3f vector3f) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        vector3f.x = Math.fma(matrix4fc.m00(), f, Math.fma(matrix4fc.m01(), f2, matrix4fc.m02() * f3));
        vector3f.y = Math.fma(matrix4fc.m10(), f, Math.fma(matrix4fc.m11(), f2, matrix4fc.m12() * f3));
        vector3f.z = Math.fma(matrix4fc.m20(), f, Math.fma(matrix4fc.m21(), f2, matrix4fc.m22() * f3));
        return vector3f;
    }

    public Vector3f mul(float f) {
        this.x *= f;
        this.y *= f;
        this.z *= f;
        return this;
    }

    @Override
    public Vector3f mul(float f, Vector3f vector3f) {
        vector3f.x = this.x * f;
        vector3f.y = this.y * f;
        vector3f.z = this.z * f;
        return vector3f;
    }

    public Vector3f mul(float f, float f2, float f3) {
        this.x *= f;
        this.y *= f2;
        this.z *= f3;
        return this;
    }

    @Override
    public Vector3f mul(float f, float f2, float f3, Vector3f vector3f) {
        vector3f.x = this.x * f;
        vector3f.y = this.y * f2;
        vector3f.z = this.z * f3;
        return vector3f;
    }

    public Vector3f div(float f) {
        float f2 = 1.0f / f;
        this.x *= f2;
        this.y *= f2;
        this.z *= f2;
        return this;
    }

    @Override
    public Vector3f div(float f, Vector3f vector3f) {
        float f2 = 1.0f / f;
        vector3f.x = this.x * f2;
        vector3f.y = this.y * f2;
        vector3f.z = this.z * f2;
        return vector3f;
    }

    public Vector3f div(float f, float f2, float f3) {
        this.x /= f;
        this.y /= f2;
        this.z /= f3;
        return this;
    }

    @Override
    public Vector3f div(float f, float f2, float f3, Vector3f vector3f) {
        vector3f.x = this.x / f;
        vector3f.y = this.y / f2;
        vector3f.z = this.z / f3;
        return vector3f;
    }

    public Vector3f rotate(Quaternionfc quaternionfc) {
        return quaternionfc.transform(this, this);
    }

    @Override
    public Vector3f rotate(Quaternionfc quaternionfc, Vector3f vector3f) {
        return quaternionfc.transform(this, vector3f);
    }

    @Override
    public Quaternionf rotationTo(Vector3fc vector3fc, Quaternionf quaternionf) {
        return quaternionf.rotationTo(this, vector3fc);
    }

    @Override
    public Quaternionf rotationTo(float f, float f2, float f3, Quaternionf quaternionf) {
        return quaternionf.rotationTo(this.x, this.y, this.z, f, f2, f3);
    }

    public Vector3f rotateAxis(float f, float f2, float f3, float f4) {
        if (f3 == 0.0f && f4 == 0.0f && Math.absEqualsOne(f2)) {
            return this.rotateX(f2 * f, this);
        }
        if (f2 == 0.0f && f4 == 0.0f && Math.absEqualsOne(f3)) {
            return this.rotateY(f3 * f, this);
        }
        if (f2 == 0.0f && f3 == 0.0f && Math.absEqualsOne(f4)) {
            return this.rotateZ(f4 * f, this);
        }
        return this.rotateAxisInternal(f, f2, f3, f4, this);
    }

    @Override
    public Vector3f rotateAxis(float f, float f2, float f3, float f4, Vector3f vector3f) {
        if (f3 == 0.0f && f4 == 0.0f && Math.absEqualsOne(f2)) {
            return this.rotateX(f2 * f, vector3f);
        }
        if (f2 == 0.0f && f4 == 0.0f && Math.absEqualsOne(f3)) {
            return this.rotateY(f3 * f, vector3f);
        }
        if (f2 == 0.0f && f3 == 0.0f && Math.absEqualsOne(f4)) {
            return this.rotateZ(f4 * f, vector3f);
        }
        return this.rotateAxisInternal(f, f2, f3, f4, vector3f);
    }

    private Vector3f rotateAxisInternal(float f, float f2, float f3, float f4, Vector3f vector3f) {
        float f5 = f * 0.5f;
        float f6 = Math.sin(f5);
        float f7 = f2 * f6;
        float f8 = f3 * f6;
        float f9 = f4 * f6;
        float f10 = Math.cosFromSin(f6, f5);
        float f11 = f10 * f10;
        float f12 = f7 * f7;
        float f13 = f8 * f8;
        float f14 = f9 * f9;
        float f15 = f9 * f10;
        float f16 = f7 * f8;
        float f17 = f7 * f9;
        float f18 = f8 * f10;
        float f19 = f8 * f9;
        float f20 = f7 * f10;
        float f21 = this.x;
        float f22 = this.y;
        float f23 = this.z;
        vector3f.x = (f11 + f12 - f14 - f13) * f21 + (-f15 + f16 - f15 + f16) * f22 + (f18 + f17 + f17 + f18) * f23;
        vector3f.y = (f16 + f15 + f15 + f16) * f21 + (f13 - f14 + f11 - f12) * f22 + (f19 + f19 - f20 - f20) * f23;
        vector3f.z = (f17 - f18 + f17 - f18) * f21 + (f19 + f19 + f20 + f20) * f22 + (f14 - f13 - f12 + f11) * f23;
        return vector3f;
    }

    public Vector3f rotateX(float f) {
        float f2 = Math.sin(f);
        float f3 = Math.cosFromSin(f2, f);
        float f4 = this.y * f3 - this.z * f2;
        float f5 = this.y * f2 + this.z * f3;
        this.y = f4;
        this.z = f5;
        return this;
    }

    @Override
    public Vector3f rotateX(float f, Vector3f vector3f) {
        float f2 = Math.sin(f);
        float f3 = Math.cosFromSin(f2, f);
        float f4 = this.y * f3 - this.z * f2;
        float f5 = this.y * f2 + this.z * f3;
        vector3f.x = this.x;
        vector3f.y = f4;
        vector3f.z = f5;
        return vector3f;
    }

    public Vector3f rotateY(float f) {
        float f2 = Math.sin(f);
        float f3 = Math.cosFromSin(f2, f);
        float f4 = this.x * f3 + this.z * f2;
        float f5 = -this.x * f2 + this.z * f3;
        this.x = f4;
        this.z = f5;
        return this;
    }

    @Override
    public Vector3f rotateY(float f, Vector3f vector3f) {
        float f2 = Math.sin(f);
        float f3 = Math.cosFromSin(f2, f);
        float f4 = this.x * f3 + this.z * f2;
        float f5 = -this.x * f2 + this.z * f3;
        vector3f.x = f4;
        vector3f.y = this.y;
        vector3f.z = f5;
        return vector3f;
    }

    public Vector3f rotateZ(float f) {
        float f2 = Math.sin(f);
        float f3 = Math.cosFromSin(f2, f);
        float f4 = this.x * f3 - this.y * f2;
        float f5 = this.x * f2 + this.y * f3;
        this.x = f4;
        this.y = f5;
        return this;
    }

    @Override
    public Vector3f rotateZ(float f, Vector3f vector3f) {
        float f2 = Math.sin(f);
        float f3 = Math.cosFromSin(f2, f);
        float f4 = this.x * f3 - this.y * f2;
        float f5 = this.x * f2 + this.y * f3;
        vector3f.x = f4;
        vector3f.y = f5;
        vector3f.z = this.z;
        return vector3f;
    }

    @Override
    public float lengthSquared() {
        return Math.fma(this.x, this.x, Math.fma(this.y, this.y, this.z * this.z));
    }

    public static float lengthSquared(float f, float f2, float f3) {
        return Math.fma(f, f, Math.fma(f2, f2, f3 * f3));
    }

    @Override
    public float length() {
        return Math.sqrt(Math.fma(this.x, this.x, Math.fma(this.y, this.y, this.z * this.z)));
    }

    public static float length(float f, float f2, float f3) {
        return Math.sqrt(Math.fma(f, f, Math.fma(f2, f2, f3 * f3)));
    }

    public Vector3f normalize() {
        float f = Math.invsqrt(Math.fma(this.x, this.x, Math.fma(this.y, this.y, this.z * this.z)));
        this.x *= f;
        this.y *= f;
        this.z *= f;
        return this;
    }

    @Override
    public Vector3f normalize(Vector3f vector3f) {
        float f = Math.invsqrt(Math.fma(this.x, this.x, Math.fma(this.y, this.y, this.z * this.z)));
        vector3f.x = this.x * f;
        vector3f.y = this.y * f;
        vector3f.z = this.z * f;
        return vector3f;
    }

    public Vector3f normalize(float f) {
        float f2 = Math.invsqrt(Math.fma(this.x, this.x, Math.fma(this.y, this.y, this.z * this.z))) * f;
        this.x *= f2;
        this.y *= f2;
        this.z *= f2;
        return this;
    }

    @Override
    public Vector3f normalize(float f, Vector3f vector3f) {
        float f2 = Math.invsqrt(Math.fma(this.x, this.x, Math.fma(this.y, this.y, this.z * this.z))) * f;
        vector3f.x = this.x * f2;
        vector3f.y = this.y * f2;
        vector3f.z = this.z * f2;
        return vector3f;
    }

    public Vector3f cross(Vector3fc vector3fc) {
        float f = Math.fma(this.y, vector3fc.z(), -this.z * vector3fc.y());
        float f2 = Math.fma(this.z, vector3fc.x(), -this.x * vector3fc.z());
        float f3 = Math.fma(this.x, vector3fc.y(), -this.y * vector3fc.x());
        this.x = f;
        this.y = f2;
        this.z = f3;
        return this;
    }

    public Vector3f cross(float f, float f2, float f3) {
        float f4 = Math.fma(this.y, f3, -this.z * f2);
        float f5 = Math.fma(this.z, f, -this.x * f3);
        float f6 = Math.fma(this.x, f2, -this.y * f);
        this.x = f4;
        this.y = f5;
        this.z = f6;
        return this;
    }

    @Override
    public Vector3f cross(Vector3fc vector3fc, Vector3f vector3f) {
        float f = Math.fma(this.y, vector3fc.z(), -this.z * vector3fc.y());
        float f2 = Math.fma(this.z, vector3fc.x(), -this.x * vector3fc.z());
        float f3 = Math.fma(this.x, vector3fc.y(), -this.y * vector3fc.x());
        vector3f.x = f;
        vector3f.y = f2;
        vector3f.z = f3;
        return vector3f;
    }

    @Override
    public Vector3f cross(float f, float f2, float f3, Vector3f vector3f) {
        float f4 = Math.fma(this.y, f3, -this.z * f2);
        float f5 = Math.fma(this.z, f, -this.x * f3);
        float f6 = Math.fma(this.x, f2, -this.y * f);
        vector3f.x = f4;
        vector3f.y = f5;
        vector3f.z = f6;
        return vector3f;
    }

    @Override
    public float distance(Vector3fc vector3fc) {
        float f = this.x - vector3fc.x();
        float f2 = this.y - vector3fc.y();
        float f3 = this.z - vector3fc.z();
        return Math.sqrt(Math.fma(f, f, Math.fma(f2, f2, f3 * f3)));
    }

    @Override
    public float distance(float f, float f2, float f3) {
        float f4 = this.x - f;
        float f5 = this.y - f2;
        float f6 = this.z - f3;
        return Math.sqrt(Math.fma(f4, f4, Math.fma(f5, f5, f6 * f6)));
    }

    @Override
    public float distanceSquared(Vector3fc vector3fc) {
        float f = this.x - vector3fc.x();
        float f2 = this.y - vector3fc.y();
        float f3 = this.z - vector3fc.z();
        return Math.fma(f, f, Math.fma(f2, f2, f3 * f3));
    }

    @Override
    public float distanceSquared(float f, float f2, float f3) {
        float f4 = this.x - f;
        float f5 = this.y - f2;
        float f6 = this.z - f3;
        return Math.fma(f4, f4, Math.fma(f5, f5, f6 * f6));
    }

    public static float distance(float f, float f2, float f3, float f4, float f5, float f6) {
        return Math.sqrt(Vector3f.distanceSquared(f, f2, f3, f4, f5, f6));
    }

    public static float distanceSquared(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = f - f4;
        float f8 = f2 - f5;
        float f9 = f3 - f6;
        return Math.fma(f7, f7, Math.fma(f8, f8, f9 * f9));
    }

    @Override
    public float dot(Vector3fc vector3fc) {
        return Math.fma(this.x, vector3fc.x(), Math.fma(this.y, vector3fc.y(), this.z * vector3fc.z()));
    }

    @Override
    public float dot(float f, float f2, float f3) {
        return Math.fma(this.x, f, Math.fma(this.y, f2, this.z * f3));
    }

    @Override
    public float angleCos(Vector3fc vector3fc) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        float f4 = Math.fma(f, f, Math.fma(f2, f2, f3 * f3));
        float f5 = Math.fma(vector3fc.x(), vector3fc.x(), Math.fma(vector3fc.y(), vector3fc.y(), vector3fc.z() * vector3fc.z()));
        float f6 = Math.fma(f, vector3fc.x(), Math.fma(f2, vector3fc.y(), f3 * vector3fc.z()));
        return f6 / Math.sqrt(f4 * f5);
    }

    @Override
    public float angle(Vector3fc vector3fc) {
        float f = this.angleCos(vector3fc);
        f = f < 1.0f ? f : 1.0f;
        f = f > -1.0f ? f : -1.0f;
        return Math.acos(f);
    }

    @Override
    public float angleSigned(Vector3fc vector3fc, Vector3fc vector3fc2) {
        return this.angleSigned(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3fc2.x(), vector3fc2.y(), vector3fc2.z());
    }

    @Override
    public float angleSigned(float f, float f2, float f3, float f4, float f5, float f6) {
        float f7 = this.x;
        float f8 = this.y;
        float f9 = this.z;
        return Math.atan2((f8 * f3 - f9 * f2) * f4 + (f9 * f - f7 * f3) * f5 + (f7 * f2 - f8 * f) * f6, f7 * f + f8 * f2 + f9 * f3);
    }

    public Vector3f min(Vector3fc vector3fc) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        this.x = f < vector3fc.x() ? f : vector3fc.x();
        this.y = f2 < vector3fc.y() ? f2 : vector3fc.y();
        this.z = f3 < vector3fc.z() ? f3 : vector3fc.z();
        return this;
    }

    @Override
    public Vector3f min(Vector3fc vector3fc, Vector3f vector3f) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        vector3f.x = f < vector3fc.x() ? f : vector3fc.x();
        vector3f.y = f2 < vector3fc.y() ? f2 : vector3fc.y();
        vector3f.z = f3 < vector3fc.z() ? f3 : vector3fc.z();
        return vector3f;
    }

    public Vector3f max(Vector3fc vector3fc) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        this.x = f > vector3fc.x() ? f : vector3fc.x();
        this.y = f2 > vector3fc.y() ? f2 : vector3fc.y();
        this.z = f3 > vector3fc.z() ? f3 : vector3fc.z();
        return this;
    }

    @Override
    public Vector3f max(Vector3fc vector3fc, Vector3f vector3f) {
        float f = this.x;
        float f2 = this.y;
        float f3 = this.z;
        vector3f.x = f > vector3fc.x() ? f : vector3fc.x();
        vector3f.y = f2 > vector3fc.y() ? f2 : vector3fc.y();
        vector3f.z = f3 > vector3fc.z() ? f3 : vector3fc.z();
        return vector3f;
    }

    public Vector3f zero() {
        this.x = 0.0f;
        this.y = 0.0f;
        this.z = 0.0f;
        return this;
    }

    public String toString() {
        return Runtime.formatNumbers(this.toString(Options.NUMBER_FORMAT));
    }

    public String toString(NumberFormat numberFormat) {
        return "(" + Runtime.format(this.x, numberFormat) + " " + Runtime.format(this.y, numberFormat) + " " + Runtime.format(this.z, numberFormat) + ")";
    }

    @Override
    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeFloat(this.x);
        objectOutput.writeFloat(this.y);
        objectOutput.writeFloat(this.z);
    }

    @Override
    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        this.set(objectInput.readFloat(), objectInput.readFloat(), objectInput.readFloat());
    }

    public Vector3f negate() {
        this.x = -this.x;
        this.y = -this.y;
        this.z = -this.z;
        return this;
    }

    @Override
    public Vector3f negate(Vector3f vector3f) {
        vector3f.x = -this.x;
        vector3f.y = -this.y;
        vector3f.z = -this.z;
        return vector3f;
    }

    public Vector3f absolute() {
        this.x = Math.abs(this.x);
        this.y = Math.abs(this.y);
        this.z = Math.abs(this.z);
        return this;
    }

    @Override
    public Vector3f absolute(Vector3f vector3f) {
        vector3f.x = Math.abs(this.x);
        vector3f.y = Math.abs(this.y);
        vector3f.z = Math.abs(this.z);
        return vector3f;
    }

    public int hashCode() {
        int n = 1;
        n = 31 * n + Float.floatToIntBits(this.x);
        n = 31 * n + Float.floatToIntBits(this.y);
        n = 31 * n + Float.floatToIntBits(this.z);
        return n;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        Vector3f vector3f = (Vector3f)object;
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(vector3f.x)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(vector3f.y)) {
            return false;
        }
        return Float.floatToIntBits(this.z) == Float.floatToIntBits(vector3f.z);
    }

    @Override
    public boolean equals(Vector3fc vector3fc, float f) {
        if (this == vector3fc) {
            return true;
        }
        if (vector3fc == null) {
            return false;
        }
        if (!(vector3fc instanceof Vector3fc)) {
            return false;
        }
        if (!Runtime.equals(this.x, vector3fc.x(), f)) {
            return false;
        }
        if (!Runtime.equals(this.y, vector3fc.y(), f)) {
            return false;
        }
        return Runtime.equals(this.z, vector3fc.z(), f);
    }

    @Override
    public boolean equals(float f, float f2, float f3) {
        if (Float.floatToIntBits(this.x) != Float.floatToIntBits(f)) {
            return false;
        }
        if (Float.floatToIntBits(this.y) != Float.floatToIntBits(f2)) {
            return false;
        }
        return Float.floatToIntBits(this.z) == Float.floatToIntBits(f3);
    }

    public Vector3f reflect(Vector3fc vector3fc) {
        float f = vector3fc.x();
        float f2 = vector3fc.y();
        float f3 = vector3fc.z();
        float f4 = Math.fma(this.x, f, Math.fma(this.y, f2, this.z * f3));
        this.x -= (f4 + f4) * f;
        this.y -= (f4 + f4) * f2;
        this.z -= (f4 + f4) * f3;
        return this;
    }

    public Vector3f reflect(float f, float f2, float f3) {
        float f4 = Math.fma(this.x, f, Math.fma(this.y, f2, this.z * f3));
        this.x -= (f4 + f4) * f;
        this.y -= (f4 + f4) * f2;
        this.z -= (f4 + f4) * f3;
        return this;
    }

    @Override
    public Vector3f reflect(Vector3fc vector3fc, Vector3f vector3f) {
        return this.reflect(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3f);
    }

    @Override
    public Vector3f reflect(float f, float f2, float f3, Vector3f vector3f) {
        float f4 = this.dot(f, f2, f3);
        vector3f.x = this.x - (f4 + f4) * f;
        vector3f.y = this.y - (f4 + f4) * f2;
        vector3f.z = this.z - (f4 + f4) * f3;
        return vector3f;
    }

    public Vector3f half(Vector3fc vector3fc) {
        return this.set(this).add(vector3fc.x(), vector3fc.y(), vector3fc.z()).normalize();
    }

    public Vector3f half(float f, float f2, float f3) {
        return this.half(f, f2, f3, this);
    }

    @Override
    public Vector3f half(Vector3fc vector3fc, Vector3f vector3f) {
        return this.half(vector3fc.x(), vector3fc.y(), vector3fc.z(), vector3f);
    }

    @Override
    public Vector3f half(float f, float f2, float f3, Vector3f vector3f) {
        return vector3f.set(this).add(f, f2, f3).normalize();
    }

    @Override
    public Vector3f smoothStep(Vector3fc vector3fc, float f, Vector3f vector3f) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        float f5 = f * f;
        float f6 = f5 * f;
        vector3f.x = (f2 + f2 - vector3fc.x() - vector3fc.x()) * f6 + (3.0f * vector3fc.x() - 3.0f * f2) * f5 + f2 * f + f2;
        vector3f.y = (f3 + f3 - vector3fc.y() - vector3fc.y()) * f6 + (3.0f * vector3fc.y() - 3.0f * f3) * f5 + f3 * f + f3;
        vector3f.z = (f4 + f4 - vector3fc.z() - vector3fc.z()) * f6 + (3.0f * vector3fc.z() - 3.0f * f4) * f5 + f4 * f + f4;
        return vector3f;
    }

    @Override
    public Vector3f hermite(Vector3fc vector3fc, Vector3fc vector3fc2, Vector3fc vector3fc3, float f, Vector3f vector3f) {
        float f2 = this.x;
        float f3 = this.y;
        float f4 = this.z;
        float f5 = f * f;
        float f6 = f5 * f;
        vector3f.x = (f2 + f2 - vector3fc2.x() - vector3fc2.x() + vector3fc3.x() + vector3fc.x()) * f6 + (3.0f * vector3fc2.x() - 3.0f * f2 - vector3fc.x() - vector3fc.x() - vector3fc3.x()) * f5 + f2 * f + f2;
        vector3f.y = (f3 + f3 - vector3fc2.y() - vector3fc2.y() + vector3fc3.y() + vector3fc.y()) * f6 + (3.0f * vector3fc2.y() - 3.0f * f3 - vector3fc.y() - vector3fc.y() - vector3fc3.y()) * f5 + f3 * f + f3;
        vector3f.z = (f4 + f4 - vector3fc2.z() - vector3fc2.z() + vector3fc3.z() + vector3fc.z()) * f6 + (3.0f * vector3fc2.z() - 3.0f * f4 - vector3fc.z() - vector3fc.z() - vector3fc3.z()) * f5 + f4 * f + f4;
        return vector3f;
    }

    public Vector3f lerp(Vector3fc vector3fc, float f) {
        return this.lerp(vector3fc, f, this);
    }

    @Override
    public Vector3f lerp(Vector3fc vector3fc, float f, Vector3f vector3f) {
        vector3f.x = Math.fma(vector3fc.x() - this.x, f, this.x);
        vector3f.y = Math.fma(vector3fc.y() - this.y, f, this.y);
        vector3f.z = Math.fma(vector3fc.z() - this.z, f, this.z);
        return vector3f;
    }

    @Override
    public float get(int n) throws IllegalArgumentException {
        switch (n) {
            case 0: {
                return this.x;
            }
            case 1: {
                return this.y;
            }
            case 2: {
                return this.z;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public Vector3i get(int n, Vector3i vector3i) {
        vector3i.x = Math.roundUsing(this.x(), n);
        vector3i.y = Math.roundUsing(this.y(), n);
        vector3i.z = Math.roundUsing(this.z(), n);
        return vector3i;
    }

    @Override
    public Vector3f get(Vector3f vector3f) {
        vector3f.x = this.x();
        vector3f.y = this.y();
        vector3f.z = this.z();
        return vector3f;
    }

    @Override
    public Vector3d get(Vector3d vector3d) {
        vector3d.x = this.x();
        vector3d.y = this.y();
        vector3d.z = this.z();
        return vector3d;
    }

    @Override
    public int maxComponent() {
        float f = Math.abs(this.x);
        float f2 = Math.abs(this.y);
        float f3 = Math.abs(this.z);
        if (f >= f2 && f >= f3) {
            return 0;
        }
        if (f2 >= f3) {
            return 1;
        }
        return 2;
    }

    @Override
    public int minComponent() {
        float f = Math.abs(this.x);
        float f2 = Math.abs(this.y);
        float f3 = Math.abs(this.z);
        if (f < f2 && f < f3) {
            return 0;
        }
        if (f2 < f3) {
            return 1;
        }
        return 2;
    }

    @Override
    public Vector3f orthogonalize(Vector3fc vector3fc, Vector3f vector3f) {
        float f;
        float f2;
        float f3;
        if (Math.abs(vector3fc.x()) > Math.abs(vector3fc.z())) {
            f3 = -vector3fc.y();
            f2 = vector3fc.x();
            f = 0.0f;
        } else {
            f3 = 0.0f;
            f2 = -vector3fc.z();
            f = vector3fc.y();
        }
        float f4 = Math.invsqrt(f3 * f3 + f2 * f2 + f * f);
        vector3f.x = f3 * f4;
        vector3f.y = f2 * f4;
        vector3f.z = f * f4;
        return vector3f;
    }

    public Vector3f orthogonalize(Vector3fc vector3fc) {
        return this.orthogonalize(vector3fc, this);
    }

    @Override
    public Vector3f orthogonalizeUnit(Vector3fc vector3fc, Vector3f vector3f) {
        return this.orthogonalize(vector3fc, vector3f);
    }

    public Vector3f orthogonalizeUnit(Vector3fc vector3fc) {
        return this.orthogonalizeUnit(vector3fc, this);
    }

    public Vector3f floor() {
        return this.floor(this);
    }

    @Override
    public Vector3f floor(Vector3f vector3f) {
        vector3f.x = Math.floor(this.x);
        vector3f.y = Math.floor(this.y);
        vector3f.z = Math.floor(this.z);
        return vector3f;
    }

    public Vector3f ceil() {
        return this.ceil(this);
    }

    @Override
    public Vector3f ceil(Vector3f vector3f) {
        vector3f.x = Math.ceil(this.x);
        vector3f.y = Math.ceil(this.y);
        vector3f.z = Math.ceil(this.z);
        return vector3f;
    }

    public Vector3f round() {
        return this.round(this);
    }

    @Override
    public Vector3f round(Vector3f vector3f) {
        vector3f.x = Math.round(this.x);
        vector3f.y = Math.round(this.y);
        vector3f.z = Math.round(this.z);
        return vector3f;
    }

    @Override
    public boolean isFinite() {
        return Math.isFinite(this.x) && Math.isFinite(this.y) && Math.isFinite(this.z);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

