/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Function;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gl.blending.BlendModeOverride;
import net.coderbot.iris.shaderpack.ConstDirectiveParser;
import net.coderbot.iris.shaderpack.DispatchingDirectiveHolder;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shaderpack.PackRenderTargetDirectives;
import net.coderbot.iris.shaderpack.ProgramDirectives;
import net.coderbot.iris.shaderpack.ProgramSource;
import net.coderbot.iris.shaderpack.ShaderPack;
import net.coderbot.iris.shaderpack.ShaderProperties;
import net.coderbot.iris.shaderpack.include.AbsolutePackPath;
import net.coderbot.iris.shaderpack.loading.ProgramId;

public class ProgramSet {
    private final PackDirectives packDirectives;
    private final ProgramSource shadow;
    private final ProgramSource[] shadowcomp;
    private final ProgramSource[] prepare;
    private final ProgramSource gbuffersBasic;
    private final ProgramSource gbuffersLine;
    private final ProgramSource gbuffersBeaconBeam;
    private final ProgramSource gbuffersTextured;
    private final ProgramSource gbuffersTexturedLit;
    private final ProgramSource gbuffersTerrain;
    private ProgramSource gbuffersDamagedBlock;
    private final ProgramSource gbuffersSkyBasic;
    private final ProgramSource gbuffersSkyTextured;
    private final ProgramSource gbuffersClouds;
    private final ProgramSource gbuffersWeather;
    private final ProgramSource gbuffersEntities;
    private final ProgramSource gbuffersEntitiesGlowing;
    private final ProgramSource gbuffersGlint;
    private final ProgramSource gbuffersEntityEyes;
    private final ProgramSource gbuffersBlock;
    private final ProgramSource gbuffersHand;
    private final ProgramSource[] deferred;
    private final ProgramSource gbuffersWater;
    private final ProgramSource gbuffersHandWater;
    private final ProgramSource[] composite;
    private final ProgramSource compositeFinal;
    private final ShaderPack pack;

    public ProgramSet(AbsolutePackPath absolutePackPath, Function<AbsolutePackPath, String> function, ShaderProperties shaderProperties, ShaderPack shaderPack) {
        this.packDirectives = new PackDirectives(PackRenderTargetDirectives.BASELINE_SUPPORTED_RENDER_TARGETS, shaderProperties);
        this.pack = shaderPack;
        this.shadow = ProgramSet.readProgramSource(absolutePackPath, function, "shadow", this, shaderProperties, BlendModeOverride.OFF);
        this.shadowcomp = this.readProgramArray(absolutePackPath, function, "shadowcomp", shaderProperties);
        this.prepare = this.readProgramArray(absolutePackPath, function, "prepare", shaderProperties);
        this.gbuffersBasic = ProgramSet.readProgramSource(absolutePackPath, function, "gbuffers_basic", this, shaderProperties);
        this.gbuffersLine = ProgramSet.readProgramSource(absolutePackPath, function, "gbuffers_line", this, shaderProperties);
        this.gbuffersBeaconBeam = ProgramSet.readProgramSource(absolutePackPath, function, "gbuffers_beaconbeam", this, shaderProperties);
        this.gbuffersTextured = ProgramSet.readProgramSource(absolutePackPath, function, "gbuffers_textured", this, shaderProperties);
        this.gbuffersTexturedLit = ProgramSet.readProgramSource(absolutePackPath, function, "gbuffers_textured_lit", this, shaderProperties);
        this.gbuffersTerrain = ProgramSet.readProgramSource(absolutePackPath, function, "gbuffers_terrain", this, shaderProperties);
        this.gbuffersDamagedBlock = ProgramSet.readProgramSource(absolutePackPath, function, "gbuffers_damagedblock", this, shaderProperties);
        this.gbuffersSkyBasic = ProgramSet.readProgramSource(absolutePackPath, function, "gbuffers_skybasic", this, shaderProperties);
        this.gbuffersSkyTextured = ProgramSet.readProgramSource(absolutePackPath, function, "gbuffers_skytextured", this, shaderProperties);
        this.gbuffersClouds = ProgramSet.readProgramSource(absolutePackPath, function, "gbuffers_clouds", this, shaderProperties);
        this.gbuffersWeather = ProgramSet.readProgramSource(absolutePackPath, function, "gbuffers_weather", this, shaderProperties);
        this.gbuffersEntities = ProgramSet.readProgramSource(absolutePackPath, function, "gbuffers_entities", this, shaderProperties);
        this.gbuffersEntitiesGlowing = ProgramSet.readProgramSource(absolutePackPath, function, "gbuffers_entities_glowing", this, shaderProperties);
        this.gbuffersGlint = ProgramSet.readProgramSource(absolutePackPath, function, "gbuffers_armor_glint", this, shaderProperties);
        this.gbuffersEntityEyes = ProgramSet.readProgramSource(absolutePackPath, function, "gbuffers_spidereyes", this, shaderProperties);
        this.gbuffersBlock = ProgramSet.readProgramSource(absolutePackPath, function, "gbuffers_block", this, shaderProperties);
        this.gbuffersHand = ProgramSet.readProgramSource(absolutePackPath, function, "gbuffers_hand", this, shaderProperties);
        this.deferred = this.readProgramArray(absolutePackPath, function, "deferred", shaderProperties);
        this.gbuffersWater = ProgramSet.readProgramSource(absolutePackPath, function, "gbuffers_water", this, shaderProperties);
        this.gbuffersHandWater = ProgramSet.readProgramSource(absolutePackPath, function, "gbuffers_hand_water", this, shaderProperties);
        this.composite = this.readProgramArray(absolutePackPath, function, "composite", shaderProperties);
        this.compositeFinal = ProgramSet.readProgramSource(absolutePackPath, function, "final", this, shaderProperties);
        this.locateDirectives();
        if (!this.gbuffersDamagedBlock.isValid()) {
            ProgramSet.first(this.getGbuffersTerrain(), this.getGbuffersTexturedLit(), this.getGbuffersTextured(), this.getGbuffersBasic()).ifPresent(programSource -> {
                ProgramDirectives programDirectives = programSource.getDirectives().withOverriddenDrawBuffers(new int[]{0});
                this.gbuffersDamagedBlock = programSource.withDirectiveOverride(programDirectives);
            });
        }
    }

    @SafeVarargs
    private static <T> Optional<T> first(Optional<T> ... optionalArray) {
        for (Optional<T> optional : optionalArray) {
            if (!optional.isPresent()) continue;
            return optional;
        }
        return Optional.empty();
    }

    private ProgramSource[] readProgramArray(AbsolutePackPath absolutePackPath, Function<AbsolutePackPath, String> function, String string, ShaderProperties shaderProperties) {
        ProgramSource[] programSourceArray = new ProgramSource[99];
        for (int i = 0; i < programSourceArray.length; ++i) {
            String string2 = i == 0 ? "" : Integer.toString(i);
            programSourceArray[i] = ProgramSet.readProgramSource(absolutePackPath, function, string + string2, this, shaderProperties);
        }
        return programSourceArray;
    }

    private void locateDirectives() {
        ArrayList<ProgramSource> arrayList = new ArrayList<ProgramSource>();
        arrayList.add(this.shadow);
        arrayList.addAll(Arrays.asList(this.shadowcomp));
        arrayList.addAll(Arrays.asList(this.prepare));
        arrayList.addAll(Arrays.asList(this.gbuffersBasic, this.gbuffersBeaconBeam, this.gbuffersTextured, this.gbuffersTexturedLit, this.gbuffersTerrain, this.gbuffersDamagedBlock, this.gbuffersSkyBasic, this.gbuffersSkyTextured, this.gbuffersClouds, this.gbuffersWeather, this.gbuffersEntities, this.gbuffersEntitiesGlowing, this.gbuffersGlint, this.gbuffersEntityEyes, this.gbuffersBlock, this.gbuffersHand));
        arrayList.addAll(Arrays.asList(this.deferred));
        arrayList.add(this.gbuffersWater);
        arrayList.add(this.gbuffersHandWater);
        arrayList.addAll(Arrays.asList(this.composite));
        arrayList.add(this.compositeFinal);
        DispatchingDirectiveHolder dispatchingDirectiveHolder = new DispatchingDirectiveHolder();
        this.packDirectives.acceptDirectivesFrom(dispatchingDirectiveHolder);
        for (ProgramSource programSource : arrayList) {
            if (programSource == null) continue;
            programSource.getFragmentSource().map(ConstDirectiveParser::findDirectives).ifPresent(list -> {
                for (ConstDirectiveParser.ConstDirective constDirective : list) {
                    dispatchingDirectiveHolder.processDirective(constDirective);
                }
            });
        }
        this.packDirectives.getRenderTargetDirectives().getRenderTargetSettings().forEach((n, renderTargetSettings) -> Iris.logger.debug("Render target settings for colortex" + n + ": " + renderTargetSettings));
    }

    public Optional<ProgramSource> getShadow() {
        return this.shadow.requireValid();
    }

    public ProgramSource[] getShadowComposite() {
        return this.shadowcomp;
    }

    public ProgramSource[] getPrepare() {
        return this.prepare;
    }

    public Optional<ProgramSource> getGbuffersBasic() {
        return this.gbuffersBasic.requireValid();
    }

    public Optional<ProgramSource> getGbuffersBeaconBeam() {
        return this.gbuffersBeaconBeam.requireValid();
    }

    public Optional<ProgramSource> getGbuffersTextured() {
        return this.gbuffersTextured.requireValid();
    }

    public Optional<ProgramSource> getGbuffersTexturedLit() {
        return this.gbuffersTexturedLit.requireValid();
    }

    public Optional<ProgramSource> getGbuffersTerrain() {
        return this.gbuffersTerrain.requireValid();
    }

    public Optional<ProgramSource> getGbuffersDamagedBlock() {
        return this.gbuffersDamagedBlock.requireValid();
    }

    public Optional<ProgramSource> getGbuffersSkyBasic() {
        return this.gbuffersSkyBasic.requireValid();
    }

    public Optional<ProgramSource> getGbuffersSkyTextured() {
        return this.gbuffersSkyTextured.requireValid();
    }

    public Optional<ProgramSource> getGbuffersClouds() {
        return this.gbuffersClouds.requireValid();
    }

    public Optional<ProgramSource> getGbuffersWeather() {
        return this.gbuffersWeather.requireValid();
    }

    public Optional<ProgramSource> getGbuffersEntities() {
        return this.gbuffersEntities.requireValid();
    }

    public Optional<ProgramSource> getGbuffersEntitiesGlowing() {
        return this.gbuffersEntitiesGlowing.requireValid();
    }

    public Optional<ProgramSource> getGbuffersGlint() {
        return this.gbuffersGlint.requireValid();
    }

    public Optional<ProgramSource> getGbuffersEntityEyes() {
        return this.gbuffersEntityEyes.requireValid();
    }

    public Optional<ProgramSource> getGbuffersBlock() {
        return this.gbuffersBlock.requireValid();
    }

    public Optional<ProgramSource> getGbuffersHand() {
        return this.gbuffersHand.requireValid();
    }

    public Optional<ProgramSource> get(ProgramId programId) {
        switch (programId) {
            case Shadow: {
                return this.getShadow();
            }
            case Basic: {
                return this.getGbuffersBasic();
            }
            case Line: {
                return this.gbuffersLine.requireValid();
            }
            case Textured: {
                return this.getGbuffersTextured();
            }
            case TexturedLit: {
                return this.getGbuffersTexturedLit();
            }
            case SkyBasic: {
                return this.getGbuffersSkyBasic();
            }
            case SkyTextured: {
                return this.getGbuffersSkyTextured();
            }
            case Clouds: {
                return this.getGbuffersClouds();
            }
            case Terrain: {
                return this.getGbuffersTerrain();
            }
            case DamagedBlock: {
                return this.getGbuffersDamagedBlock();
            }
            case Block: {
                return this.getGbuffersBlock();
            }
            case BeaconBeam: {
                return this.getGbuffersBeaconBeam();
            }
            case Entities: {
                return this.getGbuffersEntities();
            }
            case EntitiesGlowing: {
                return this.getGbuffersEntitiesGlowing();
            }
            case ArmorGlint: {
                return this.getGbuffersGlint();
            }
            case SpiderEyes: {
                return this.getGbuffersEntityEyes();
            }
            case Hand: {
                return this.getGbuffersHand();
            }
            case Weather: {
                return this.getGbuffersWeather();
            }
            case Water: {
                return this.getGbuffersWater();
            }
            case HandWater: {
                return this.getGbuffersHandWater();
            }
            case Final: {
                return this.getCompositeFinal();
            }
        }
        return Optional.empty();
    }

    public ProgramSource[] getDeferred() {
        return this.deferred;
    }

    public Optional<ProgramSource> getGbuffersWater() {
        return this.gbuffersWater.requireValid();
    }

    public Optional<ProgramSource> getGbuffersHandWater() {
        return this.gbuffersHandWater.requireValid();
    }

    public ProgramSource[] getComposite() {
        return this.composite;
    }

    public Optional<ProgramSource> getCompositeFinal() {
        return this.compositeFinal.requireValid();
    }

    public PackDirectives getPackDirectives() {
        return this.packDirectives;
    }

    public ShaderPack getPack() {
        return this.pack;
    }

    private static ProgramSource readProgramSource(AbsolutePackPath absolutePackPath, Function<AbsolutePackPath, String> function, String string, ProgramSet programSet, ShaderProperties shaderProperties) {
        return ProgramSet.readProgramSource(absolutePackPath, function, string, programSet, shaderProperties, null);
    }

    private static ProgramSource readProgramSource(AbsolutePackPath absolutePackPath, Function<AbsolutePackPath, String> function, String string, ProgramSet programSet, ShaderProperties shaderProperties, BlendModeOverride blendModeOverride) {
        AbsolutePackPath absolutePackPath2 = absolutePackPath.resolve(string + ".vsh");
        String string2 = function.apply(absolutePackPath2);
        AbsolutePackPath absolutePackPath3 = absolutePackPath.resolve(string + ".gsh");
        String string3 = function.apply(absolutePackPath3);
        AbsolutePackPath absolutePackPath4 = absolutePackPath.resolve(string + ".fsh");
        String string4 = function.apply(absolutePackPath4);
        return new ProgramSource(string, string2, string3, string4, programSet, shaderProperties, blendModeOverride);
    }
}

