/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack;

import com.google.common.collect.ImmutableList;
import it.unimi.dsi.fastutil.Function;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.coderbot.iris.shaderpack.materialmap.BlockEntry;
import net.coderbot.iris.shaderpack.materialmap.NamespacedId;

public class LegacyIdMap {
    private static final ImmutableList<String> COLORS = ImmutableList.of((Object)"white", (Object)"orange", (Object)"magenta", (Object)"light_blue", (Object)"yellow", (Object)"lime", (Object)"pink", (Object)"gray", (Object)"light_gray", (Object)"cyan", (Object)"purple", (Object)"blue", (Object[])new String[]{"brown", "green", "red", "black"});
    private static final ImmutableList<String> WOOD_TYPES = ImmutableList.of((Object)"oak", (Object)"birch", (Object)"jungle", (Object)"spruce", (Object)"acacia", (Object)"dark_oak");

    public static void addLegacyValues(Int2ObjectMap<List<BlockEntry>> int2ObjectMap) {
        LegacyIdMap.add(int2ObjectMap, 1, LegacyIdMap.block("stone"), LegacyIdMap.block("granite"), LegacyIdMap.block("diorite"), LegacyIdMap.block("andesite"));
        LegacyIdMap.add(int2ObjectMap, 2, LegacyIdMap.block("grass_block"));
        LegacyIdMap.add(int2ObjectMap, 4, LegacyIdMap.block("cobblestone"));
        LegacyIdMap.add(int2ObjectMap, 50, LegacyIdMap.block("torch"));
        LegacyIdMap.add(int2ObjectMap, 89, LegacyIdMap.block("glowstone"));
        LegacyIdMap.add(int2ObjectMap, 124, LegacyIdMap.block("redstone_lamp"));
        LegacyIdMap.add(int2ObjectMap, 12, LegacyIdMap.block("sand"));
        LegacyIdMap.add(int2ObjectMap, 24, LegacyIdMap.block("sandstone"));
        LegacyIdMap.add(int2ObjectMap, 41, LegacyIdMap.block("gold_block"));
        LegacyIdMap.add(int2ObjectMap, 42, LegacyIdMap.block("iron_block"));
        LegacyIdMap.add(int2ObjectMap, 57, LegacyIdMap.block("diamond_block"));
        LegacyIdMap.add(int2ObjectMap, -123, LegacyIdMap.block("emerald_block"));
        LegacyIdMap.addMany(int2ObjectMap, 35, COLORS, (Function<String, BlockEntry>)((Function)object -> LegacyIdMap.block(object + "_wool")));
        LegacyIdMap.add(int2ObjectMap, 8, LegacyIdMap.block("water"));
        LegacyIdMap.add(int2ObjectMap, 10, LegacyIdMap.block("lava"));
        LegacyIdMap.add(int2ObjectMap, 79, LegacyIdMap.block("ice"));
        LegacyIdMap.addMany(int2ObjectMap, 18, WOOD_TYPES, (Function<String, BlockEntry>)((Function)object -> LegacyIdMap.block(object + "_leaves")));
        LegacyIdMap.addMany(int2ObjectMap, 95, COLORS, (Function<String, BlockEntry>)((Function)object -> LegacyIdMap.block(object + "_stained_glass")));
        LegacyIdMap.addMany(int2ObjectMap, 160, COLORS, (Function<String, BlockEntry>)((Function)object -> LegacyIdMap.block(object + "_stained_glass_pane")));
        LegacyIdMap.add(int2ObjectMap, 31, LegacyIdMap.block("grass"), LegacyIdMap.block("seagrass"), LegacyIdMap.block("sweet_berry_bush"));
        LegacyIdMap.add(int2ObjectMap, 59, LegacyIdMap.block("wheat"), LegacyIdMap.block("carrots"), LegacyIdMap.block("potatoes"));
        LegacyIdMap.add(int2ObjectMap, 37, LegacyIdMap.block("dandelion"), LegacyIdMap.block("poppy"), LegacyIdMap.block("blue_orchid"), LegacyIdMap.block("allium"), LegacyIdMap.block("azure_bluet"), LegacyIdMap.block("red_tulip"), LegacyIdMap.block("pink_tulip"), LegacyIdMap.block("white_tulip"), LegacyIdMap.block("orange_tulip"), LegacyIdMap.block("oxeye_daisy"), LegacyIdMap.block("cornflower"), LegacyIdMap.block("lily_of_the_valley"), LegacyIdMap.block("wither_rose"));
        LegacyIdMap.add(int2ObjectMap, 175, LegacyIdMap.block("sunflower"), LegacyIdMap.block("lilac"), LegacyIdMap.block("tall_grass"), LegacyIdMap.block("large_fern"), LegacyIdMap.block("rose_bush"), LegacyIdMap.block("peony"), LegacyIdMap.block("tall_seagrass"));
        LegacyIdMap.add(int2ObjectMap, 51, LegacyIdMap.block("fire"));
        LegacyIdMap.add(int2ObjectMap, 111, LegacyIdMap.block("lily_pad"));
    }

    private static BlockEntry block(String string) {
        return new BlockEntry(new NamespacedId("minecraft", string), Collections.emptyMap());
    }

    private static void addMany(Int2ObjectMap<List<BlockEntry>> int2ObjectMap, int n, List<String> list, Function<String, BlockEntry> function) {
        ArrayList<BlockEntry> arrayList = new ArrayList<BlockEntry>();
        for (String string : list) {
            arrayList.add((BlockEntry)function.apply((Object)string));
        }
        int2ObjectMap.put(n, arrayList);
    }

    private static void add(Int2ObjectMap<List<BlockEntry>> int2ObjectMap, int n, BlockEntry ... blockEntryArray) {
        int2ObjectMap.put(n, Arrays.asList(blockEntryArray));
    }
}

