/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gl.uniform;

import net.coderbot.iris.gl.IrisRenderSystem;
import net.coderbot.iris.gl.uniform.FloatSupplier;
import net.coderbot.iris.gl.uniform.Uniform;
import net.coderbot.iris.gl.uniform.ValueUpdateNotifier;

public class FloatUniform
extends Uniform {
    private float cachedValue = 0.0f;
    private final FloatSupplier value;

    FloatUniform(int n, FloatSupplier floatSupplier) {
        this(n, floatSupplier, null);
    }

    FloatUniform(int n, FloatSupplier floatSupplier, ValueUpdateNotifier valueUpdateNotifier) {
        super(n, valueUpdateNotifier);
        this.value = floatSupplier;
    }

    @Override
    public void update() {
        this.updateValue();
        if (this.notifier != null) {
            this.notifier.setListener(this::updateValue);
        }
    }

    private void updateValue() {
        float f = this.value.getAsFloat();
        if (this.cachedValue != f) {
            this.cachedValue = f;
            IrisRenderSystem.uniform1f(this.location, f);
        }
    }
}

