/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass.metadata;

import com.google.gson.JsonObject;
import dev.lambdaurora.lambdabettergrass.metadata.LBGLayer;
import dev.lambdaurora.lambdabettergrass.model.LBGBakedModel;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1100;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_4730;
import org.jetbrains.annotations.Nullable;

public class LBGMetadata {
    public final class_2960 id;
    protected final class_3300 resourceManager;
    protected final List<class_4730> textures = new ArrayList<class_4730>();
    private final List<LBGLayer> layers = new ArrayList<LBGLayer>();
    private int lastLayerIndex = 0;
    protected class_1100 snowyVariant = null;
    protected Consumer<class_1087> snowyModelVariantProvider = null;
    protected class_1087 snowyModelVariant = null;

    public LBGMetadata(class_3300 resourceManager, class_2960 id, JsonObject json) {
        this.id = id;
        this.resourceManager = resourceManager;
        if (json.has("layers")) {
            json.getAsJsonArray("layers").forEach(layer -> this.layers.add(new LBGLayer(this, layer.getAsJsonObject())));
        }
        this.buildTextures();
        Int2ObjectArrayMap parentLayers = new Int2ObjectArrayMap();
        for (LBGLayer layer2 : this.layers) {
            if (!parentLayers.containsKey(layer2.colorIndex)) {
                parentLayers.put(layer2.colorIndex, (Object)layer2);
                continue;
            }
            LBGLayer.mergeLayers((LBGLayer)parentLayers.get(layer2.colorIndex), layer2);
        }
        this.layers.clear();
        this.layers.addAll((Collection<LBGLayer>)parentLayers.values());
    }

    protected int nextLayerIndex() {
        return this.lastLayerIndex++;
    }

    private void buildTextures() {
        for (LBGLayer layer : this.layers) {
            layer.buildTextures();
        }
    }

    public void bakeTextures(Function<class_4730, class_1058> textureGetter) {
        for (LBGLayer layer : this.layers) {
            layer.bakeTextures(textureGetter);
        }
    }

    public Optional<LBGLayer> getLayer(int colorIndex) {
        for (LBGLayer layer : this.layers) {
            if (layer.colorIndex != colorIndex) continue;
            return Optional.of(layer);
        }
        return Optional.empty();
    }

    public Collection<class_4730> getTextures() {
        return this.textures;
    }

    @Nullable
    public class_1100 getSnowyVariant() {
        return this.snowyVariant;
    }

    @Nullable
    public class_1087 getSnowyModelVariant() {
        return this.snowyModelVariant;
    }

    public void propagate(LBGBakedModel model) {
        if (this.snowyModelVariantProvider != null) {
            this.snowyModelVariantProvider.accept((class_1087)model);
        }
    }

    public String toString() {
        return "LBGMetadata{id=" + this.id + ", layers=" + this.layers + ", snowyVariant=" + this.snowyVariant + "}";
    }
}

