/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass.metadata;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.mojang.logging.LogUtils;
import dev.lambdaurora.lambdabettergrass.metadata.LBGCompiledLayerMetadata;
import dev.lambdaurora.lambdabettergrass.metadata.LBGLayerMetadata;
import dev.lambdaurora.lambdabettergrass.metadata.LBGLayerType;
import dev.lambdaurora.lambdabettergrass.metadata.LBGState;
import dev.lambdaurora.lambdabettergrass.model.LBGLayerUnbakedModel;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_790;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class LBGLayerState
extends LBGState {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final JsonObject DEFAULT_METADATA_LAYER_JSON = new JsonObject();
    private final Map<String, List<LBGLayerMetadata>> metadatas = new Object2ObjectOpenHashMap();
    private final class_2248 block;

    public LBGLayerState(class_2960 id, class_3300 resourceManager, JsonObject json, class_790.class_791 deserializationContext) {
        super(id);
        this.block = (class_2248)class_2378.field_11146.method_10223(new class_2960(id.method_12836(), id.method_12832().substring("bettergrass/states/".length())));
        if (json.has("variants")) {
            JsonObject variants = json.getAsJsonObject("variants");
            variants.entrySet().forEach(entry -> {
                JsonObject variant = ((JsonElement)entry.getValue()).getAsJsonObject();
                if (variant.has("data")) {
                    this.loadVariant((String)entry.getKey(), variant, resourceManager, deserializationContext);
                }
            });
        } else if (json.has("data")) {
            this.loadVariant("*", json, resourceManager, deserializationContext);
        } else {
            LOGGER.warn("Invalid state definition for {}, missing data or variants entry.", (Object)id);
        }
    }

    private void loadVariant(String variant, JsonObject json, class_3300 resourceManager, class_790.class_791 deserializationContext) {
        class_2960 metadataId = class_2960.method_12829((String)json.get("data").getAsString());
        class_2960 metadataResourceId = new class_2960(metadataId.method_12836(), metadataId.method_12832() + ".json");
        LBGLayerType.forEach(type -> this.putOrReplaceMetadata(variant, metadataId, (LBGLayerType)type, DEFAULT_METADATA_LAYER_JSON, deserializationContext));
        List resources = resourceManager.method_14489(metadataResourceId);
        for (class_3298 resource : resources) {
            try (InputStreamReader reader = new InputStreamReader(resource.method_14482());){
                JsonObject metadataJson = JsonParser.parseReader((Reader)reader).getAsJsonObject();
                for (Map.Entry entry : metadataJson.entrySet()) {
                    LBGLayerType type2 = LBGLayerType.fromName((String)entry.getKey());
                    if (type2 == null || !((JsonElement)entry.getValue()).isJsonObject()) continue;
                    this.putOrReplaceMetadata(variant, metadataId, type2, ((JsonElement)entry.getValue()).getAsJsonObject(), deserializationContext);
                }
            }
            catch (IOException e) {
                LOGGER.warn("Cannot load metadata file \"" + metadataId + "\" from layer state \"" + this.id + "\" (variant: \"" + variant + "\").", (Throwable)e);
            }
        }
    }

    private void putOrReplaceMetadata(String variant, class_2960 metadataId, LBGLayerType type, JsonObject metadataJson, class_790.class_791 deserializationContext) {
        List metadatas = this.metadatas.computeIfAbsent(variant, v -> new ArrayList());
        Iterator it = metadatas.iterator();
        while (it.hasNext()) {
            LBGLayerMetadata next = (LBGLayerMetadata)it.next();
            if (next.layerType != type) continue;
            it.remove();
            break;
        }
        if (this.block != class_2246.field_10124) {
            type.apply(this.block);
        }
        metadatas.add(new LBGLayerMetadata(metadataId, type, metadataJson, deserializationContext));
    }

    public void forEach(String[] variant, Consumer<LBGLayerMetadata> consumer) {
        for (Map.Entry<String, List<LBGLayerMetadata>> entry : this.metadatas.entrySet()) {
            if (!this.matchVariant(variant, entry.getKey().split(","))) continue;
            entry.getValue().forEach(consumer);
            return;
        }
    }

    @Override
    @Nullable
    public class_1100 getCustomUnbakedModel(class_1091 modelId, class_1100 originalModel, Function<class_2960, class_1100> modelGetter) {
        String[] modelVariant = modelId.method_4740().split(",");
        for (Map.Entry<String, List<LBGLayerMetadata>> entry : this.metadatas.entrySet()) {
            if (!entry.getKey().equals("*") && !this.matchVariant(modelVariant, entry.getKey().split(","))) continue;
            ArrayList<LBGCompiledLayerMetadata> metadatas = new ArrayList<LBGCompiledLayerMetadata>();
            entry.getValue().forEach(metadata -> {
                LBGLayerMetadata.LayerUnbakedModels models = metadata.getCustomUnbakedModel(modelId, originalModel, modelGetter);
                if (models.isEmpty()) {
                    return;
                }
                metadatas.add(new LBGCompiledLayerMetadata(metadata.layerType, metadata.offset(), models));
            });
            if (metadatas.size() != 0) {
                return new LBGLayerUnbakedModel(originalModel, metadatas);
            }
            return null;
        }
        return null;
    }

    static {
        DEFAULT_METADATA_LAYER_JSON.addProperty("layer", Boolean.valueOf(true));
    }
}

