/*
 * Decompiled with CFR 0.152.
 */
package dev.lambdaurora.lambdabettergrass;

import dev.lambdaurora.lambdabettergrass.LBGMode;
import dev.lambdaurora.lambdabettergrass.LambdaBetterGrass;
import dev.lambdaurora.lambdabettergrass.shadow.nightconfig.core.file.FileConfig;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;

public class LBGConfig {
    private static final LBGMode DEFAULT_MODE = LBGMode.FANCY;
    private static final boolean DEFAULT_BETTER_LAYER = true;
    private static final boolean DEFAULT_DEBUG = false;
    public static final Path CONFIG_FILE_PATH = Paths.get("config/lambdabettergrass.toml", new String[0]);
    protected final FileConfig config;
    private final LambdaBetterGrass mod;
    private LBGMode mode;
    private boolean betterLayer;

    public LBGConfig(@NotNull LambdaBetterGrass mod) {
        this.mod = mod;
        this.config = FileConfig.builder(CONFIG_FILE_PATH).concurrent().defaultResource("/lambdabettergrass.toml").autoreload().autosave().build();
    }

    public void load() {
        this.config.load();
        this.mode = LBGMode.byId(this.config.getOrElse("mode", DEFAULT_MODE.getName())).orElse(DEFAULT_MODE);
        this.betterLayer = this.config.getOrElse("better_layer", Boolean.valueOf(true));
        this.mod.log("Configuration loaded.");
    }

    public void reset() {
        this.setMode(DEFAULT_MODE);
        this.setBetterLayer(true);
        this.setDebug(false);
    }

    public LBGMode getMode() {
        return this.mode;
    }

    public void setMode(@NotNull LBGMode mode) {
        this.mode = mode;
        this.config.set("mode", (Object)mode.getName());
    }

    public boolean hasBetterLayer() {
        return this.betterLayer;
    }

    public void setBetterLayer(boolean betterSnow) {
        this.betterLayer = betterSnow;
        this.config.set("better_layer", (Object)betterSnow);
    }

    public boolean isDebug() {
        return this.config.getOrElse("debug", Boolean.valueOf(false));
    }

    public void setDebug(boolean debug) {
        this.config.set("debug", (Object)debug);
    }
}

