/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.util;

import com.google.gson.Gson;
import com.google.gson.reflect.TypeToken;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class Translator {
    private static final Map<String, String> fallbackTranslations;
    private static Map<String, String> translations;

    private Translator() {
    }

    public static void setLanguage(String language) {
        translations = Translator.load(language);
    }

    public static boolean isValidLanguage(String language) {
        return Translator.class.getClassLoader().getResource("lang/" + language + ".json") != null;
    }

    public static String translateKey(String key, boolean prefixed, Object ... args) {
        StringBuilder translation = new StringBuilder();
        String message = translations.getOrDefault(key, fallbackTranslations.getOrDefault(key, "Missing translation"));
        if (prefixed) {
            translation.append("[Chunky] ");
        }
        translation.append(String.format(message, args));
        return translation.toString();
    }

    public static String translate(String key, Object ... args) {
        return Translator.translateKey(key, false, args);
    }

    public static void addCustomTranslation(String key, String message) {
        fallbackTranslations.put(key, message);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Map<String, String> load(String language) {
        InputStream input = Translator.class.getClassLoader().getResourceAsStream("lang/" + language + ".json");
        if (input == null) return Collections.emptyMap();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(input, StandardCharsets.UTF_8));){
            String s;
            StringBuilder lang = new StringBuilder();
            while ((s = reader.readLine()) != null) {
                lang.append(s);
            }
            Map map = (Map)new Gson().fromJson(lang.toString(), new TypeToken<HashMap<String, String>>(){}.getType());
            return map;
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Collections.emptyMap();
    }

    static {
        translations = Collections.emptyMap();
        fallbackTranslations = Translator.load("en");
    }
}

