/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.platform.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.GenerationTask;
import org.popcraft.chunky.Selection;
import org.popcraft.chunky.platform.Config;
import org.popcraft.chunky.platform.World;
import org.popcraft.chunky.util.Input;
import org.popcraft.chunky.util.Parameter;
import org.popcraft.chunky.util.Translator;

public class GsonConfig
implements Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final Supplier<Chunky> chunky;
    private final Path savePath;
    private ConfigModel configModel = new ConfigModel();

    public GsonConfig(Supplier<Chunky> chunky, Path savePath) {
        this.chunky = chunky;
        this.savePath = savePath;
        if (Files.exists(this.savePath, new LinkOption[0])) {
            this.reload();
        } else {
            this.saveConfig();
        }
        Translator.setLanguage(this.getLanguage());
    }

    @Override
    public Path getDirectory() {
        return this.savePath.getParent();
    }

    @Override
    public Optional<GenerationTask> loadTask(World world) {
        Map tasks = Optional.ofNullable(this.configModel.tasks).orElse(new HashMap());
        TaskModel taskModel = (TaskModel)tasks.get(world.getName());
        if (taskModel == null) {
            return Optional.empty();
        }
        boolean cancelled = Optional.ofNullable(taskModel.cancelled).orElse(false);
        double radiusX = Optional.ofNullable(taskModel.radius).orElse(500.0);
        double radiusZ = Optional.ofNullable(taskModel.radiusZ).orElse(radiusX);
        Selection.Builder selection = Selection.builder(this.chunky.get(), world).centerX(Optional.ofNullable(taskModel.centerX).orElse(0.0)).centerZ(Optional.ofNullable(taskModel.centerZ).orElse(0.0)).radiusX(radiusX).radiusZ(radiusZ).pattern(Parameter.of(Optional.ofNullable(taskModel.iterator).orElse("concentric"))).shape(Optional.ofNullable(taskModel.shape).orElse("square"));
        long count = taskModel.count;
        long time = taskModel.time;
        return Optional.of(new GenerationTask(this.chunky.get(), selection.build(), count, time, cancelled));
    }

    @Override
    public List<GenerationTask> loadTasks() {
        ArrayList<GenerationTask> generationTasks = new ArrayList<GenerationTask>();
        this.chunky.get().getServer().getWorlds().forEach(world -> this.loadTask((World)world).ifPresent(generationTasks::add));
        return generationTasks;
    }

    @Override
    public void saveTask(GenerationTask generationTask) {
        if (this.configModel.tasks == null) {
            this.configModel.tasks = new HashMap();
        }
        Map tasks = this.configModel.tasks;
        Selection selection = generationTask.getSelection();
        TaskModel taskModel = tasks.getOrDefault(selection.world().getName(), new TaskModel());
        String shape = generationTask.getShape().name();
        taskModel.cancelled = generationTask.isCancelled();
        taskModel.radius = selection.radiusX();
        if ("rectangle".equals(shape) || "ellipse".equals(shape)) {
            taskModel.radiusZ = selection.radiusZ();
        }
        taskModel.centerX = selection.centerX();
        taskModel.centerZ = selection.centerZ();
        taskModel.iterator = generationTask.getChunkIterator().name();
        taskModel.shape = shape;
        taskModel.count = generationTask.getCount();
        taskModel.time = generationTask.getTotalTime();
        tasks.put(selection.world().getName(), taskModel);
        this.saveConfig();
    }

    @Override
    public void saveTasks() {
        this.chunky.get().getGenerationTasks().values().forEach(this::saveTask);
    }

    @Override
    public void cancelTask(World world) {
        this.loadTask(world).ifPresent(generationTask -> {
            generationTask.stop(true);
            this.saveTask((GenerationTask)generationTask);
        });
    }

    @Override
    public void cancelTasks() {
        this.loadTasks().forEach(generationTask -> {
            generationTask.stop(true);
            this.saveTask((GenerationTask)generationTask);
        });
    }

    @Override
    public int getVersion() {
        return Optional.ofNullable(this.configModel.version).orElse(0);
    }

    @Override
    public String getLanguage() {
        return Optional.ofNullable(this.configModel.language).map(Input::checkLanguage).orElse("en");
    }

    @Override
    public boolean getContinueOnRestart() {
        return Optional.ofNullable(this.configModel.continueOnRestart).orElse(false);
    }

    @Override
    public boolean isSilent() {
        return Optional.ofNullable(this.configModel.silent).orElse(false);
    }

    @Override
    public void setSilent(boolean silent) {
        this.configModel.silent = silent;
    }

    @Override
    public int getUpdateInterval() {
        return Optional.ofNullable(this.configModel.updateInterval).orElse(1);
    }

    @Override
    public void setUpdateInterval(int updateInterval) {
        this.configModel.updateInterval = updateInterval;
    }

    @Override
    public void reload() {
        try (BufferedReader reader = Files.newBufferedReader(this.savePath);){
            this.configModel = (ConfigModel)GSON.fromJson((Reader)reader, ConfigModel.class);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveConfig() {
        try {
            Files.createDirectories(this.savePath.getParent(), new FileAttribute[0]);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try (BufferedWriter writer = Files.newBufferedWriter(this.savePath, new OpenOption[0]);){
            GSON.toJson((Object)this.configModel, (Appendable)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private static class TaskModel {
        private Boolean cancelled;
        private Double radius;
        private Double radiusZ;
        private Double centerX;
        private Double centerZ;
        private String iterator;
        private String shape;
        private Long count;
        private Long time;

        private TaskModel() {
        }

        public Boolean getCancelled() {
            return this.cancelled;
        }

        public void setCancelled(Boolean cancelled) {
            this.cancelled = cancelled;
        }

        public Double getRadius() {
            return this.radius;
        }

        public void setRadius(Double radius) {
            this.radius = radius;
        }

        public Double getRadiusZ() {
            return this.radiusZ;
        }

        public void setRadiusZ(Double radiusZ) {
            this.radiusZ = radiusZ;
        }

        public Double getCenterX() {
            return this.centerX;
        }

        public void setCenterX(Double centerX) {
            this.centerX = centerX;
        }

        public Double getCenterZ() {
            return this.centerZ;
        }

        public void setCenterZ(Double centerZ) {
            this.centerZ = centerZ;
        }

        public String getIterator() {
            return this.iterator;
        }

        public void setIterator(String iterator) {
            this.iterator = iterator;
        }

        public String getShape() {
            return this.shape;
        }

        public void setShape(String shape) {
            this.shape = shape;
        }

        public Long getCount() {
            return this.count;
        }

        public void setCount(Long count) {
            this.count = count;
        }

        public Long getTime() {
            return this.time;
        }

        public void setTime(Long time) {
            this.time = time;
        }
    }

    private static class ConfigModel {
        private Integer version = 1;
        private String language = "en";
        private Boolean continueOnRestart = false;
        private Boolean silent = false;
        private Integer updateInterval = 1;
        private Map<String, TaskModel> tasks;

        private ConfigModel() {
        }

        public Integer getVersion() {
            return this.version;
        }

        public void setVersion(Integer version) {
            this.version = version;
        }

        public String getLanguage() {
            return this.language;
        }

        public void setLanguage(String language) {
            this.language = language;
        }

        public Boolean getContinueOnRestart() {
            return this.continueOnRestart;
        }

        public void setContinueOnRestart(Boolean continueOnRestart) {
            this.continueOnRestart = continueOnRestart;
        }

        public Map<String, TaskModel> getTasks() {
            return this.tasks;
        }

        public void setTasks(Map<String, TaskModel> tasks) {
            this.tasks = tasks;
        }

        public boolean isSilent() {
            return this.silent;
        }

        public void setSilent(boolean silent) {
            this.silent = silent;
        }

        public int getUpdateInterval() {
            return this.updateInterval;
        }

        public void setUpdateInterval(int updateInterval) {
            this.updateInterval = updateInterval;
        }
    }
}

