/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.value;

import carpet.CarpetSettings;
import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.Fluff;
import carpet.script.LazyValue;
import carpet.script.Module;
import carpet.script.Tokenizer;
import carpet.script.exception.BreakStatement;
import carpet.script.exception.ContinueStatement;
import carpet.script.exception.ExpressionException;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.ReturnStatement;
import carpet.script.value.FunctionUnpackedArgumentsValue;
import carpet.script.value.ListValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_2519;
import net.minecraft.class_2520;

public class FunctionValue
extends Value
implements Fluff.ILazyFunction {
    private final Expression expression;
    private final Tokenizer.Token token;
    private final String name;
    private final LazyValue body;
    private Map<String, LazyValue> outerState;
    private final List<String> args;
    private final String varArgs;
    private static long variantCounter = 1L;
    private long variant;

    private FunctionValue(Expression expression, Tokenizer.Token token, String name, LazyValue body, List<String> args, String varArgs) {
        this.expression = expression;
        this.token = token;
        this.name = name;
        this.body = body;
        this.args = args;
        this.varArgs = varArgs;
        this.outerState = null;
        this.variant = 0L;
    }

    public FunctionValue(Expression expression, Tokenizer.Token token, String name, LazyValue body, List<String> args, String varArgs, Map<String, LazyValue> outerState) {
        this.expression = expression;
        this.token = token;
        this.name = name;
        this.body = body;
        this.args = args;
        this.varArgs = varArgs;
        this.outerState = outerState;
        this.variant = variantCounter++;
    }

    @Override
    public String getString() {
        return this.name;
    }

    public Module getModule() {
        return this.expression.module;
    }

    @Override
    public String getPrettyString() {
        ArrayList<String> stringArgs = new ArrayList<String>(this.args);
        if (this.outerState != null) {
            stringArgs.addAll(this.outerState.entrySet().stream().map(e -> "outer(" + (String)e.getKey() + ") = " + ((LazyValue)e.getValue()).evalValue(null).getPrettyString()).collect(Collectors.toList()));
        }
        return (this.name.equals("_") ? "<lambda>" : this.name) + "(" + String.join((CharSequence)", ", stringArgs) + ")";
    }

    public String fullName() {
        return (this.name.equals("_") ? "<lambda>" : this.name) + (String)(this.expression.module == null ? "" : "[" + this.expression.module.name() + "]");
    }

    @Override
    public boolean getBoolean() {
        return true;
    }

    protected Value clone() {
        FunctionValue ret = new FunctionValue(this.expression, this.token, this.name, this.body, this.args, this.varArgs);
        ret.outerState = this.outerState;
        ret.variant = this.variant;
        return ret;
    }

    @Override
    public int hashCode() {
        return this.name.hashCode() + (int)this.variant;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof FunctionValue) {
            return this.name.equals(((FunctionValue)o).name) && this.variant == ((FunctionValue)o).variant;
        }
        return false;
    }

    @Override
    public int compareTo(Value o) {
        if (o instanceof FunctionValue) {
            int nameSame = this.name.compareTo(((FunctionValue)o).name);
            if (nameSame != 0) {
                return nameSame;
            }
            return (int)(this.variant - ((FunctionValue)o).variant);
        }
        return this.getString().compareTo(o.getString());
    }

    @Override
    public double readDoubleNumber() {
        return this.getNumParams();
    }

    @Override
    public String getTypeString() {
        return "function";
    }

    @Override
    public Value slice(long from, Long to) {
        throw new InternalExpressionException("Cannot slice a function");
    }

    @Override
    public int getNumParams() {
        return this.args.size();
    }

    @Override
    public boolean numParamsVaries() {
        return this.varArgs != null;
    }

    public LazyValue callInContext(Context c, Context.Type type, List<Value> params) {
        try {
            return this.execute(c, type, this.expression, this.token, params);
        }
        catch (ExpressionException exc) {
            exc.stack.add(this);
            throw exc;
        }
        catch (InternalExpressionException exc) {
            exc.stack.add(this);
            throw new ExpressionException(c, this.expression, this.token, exc.getMessage(), exc.stack);
        }
        catch (ArithmeticException exc) {
            throw new ExpressionException(c, this.expression, this.token, "Your math is wrong, " + exc.getMessage(), Collections.singletonList(this));
        }
    }

    public void checkArgs(int candidates) {
        int actual = this.getArguments().size();
        if (candidates < actual) {
            throw new InternalExpressionException("Function " + this.getPrettyString() + " requires at least " + actual + " arguments");
        }
        if (candidates > actual && this.getVarArgs() == null) {
            throw new InternalExpressionException("Function " + this.getPrettyString() + " requires " + actual + " arguments");
        }
    }

    public static List<Value> unpackArgs(List<LazyValue> lazyParams, Context c) {
        ArrayList<Value> params = new ArrayList<Value>();
        for (LazyValue lv : lazyParams) {
            Value param = lv.evalValue(c, Context.NONE);
            if (param instanceof FunctionUnpackedArgumentsValue) {
                CarpetSettings.LOG.error("How did we get here?");
                params.addAll(((ListValue)param).getItems());
                continue;
            }
            params.add(param);
        }
        return params;
    }

    @Override
    public LazyValue lazyEval(Context c, Context.Type type, Expression e, Tokenizer.Token t, List<LazyValue> lazyParams) {
        List<Value> resolvedParams = FunctionValue.unpackArgs(lazyParams, c);
        return this.execute(c, type, e, t, resolvedParams);
    }

    public LazyValue execute(Context c, Context.Type type, Expression e, Tokenizer.Token t, List<Value> params) {
        Value retVal;
        this.assertArgsOk(params, fixedArgs -> {
            if (fixedArgs.booleanValue()) {
                throw new ExpressionException(c, e, t, "Incorrect number of arguments for function " + this.name + ". Should be " + this.args.size() + ", not " + params.size() + " like " + this.args);
            }
            ArrayList<String> argList = new ArrayList<String>(this.args);
            argList.add("... " + this.varArgs);
            throw new ExpressionException(c, e, t, "Incorrect number of arguments for function " + this.name + ". Should be at least " + this.args.size() + ", not " + params.size() + " like " + argList);
        });
        Context newFrame = c.recreate();
        if (this.outerState != null) {
            this.outerState.forEach(newFrame::setVariable);
        }
        for (int i = 0; i < this.args.size(); ++i) {
            String arg = this.args.get(i);
            Value val = params.get(i).reboundedTo(arg);
            newFrame.setVariable(arg, (cc, tt) -> val);
        }
        if (this.varArgs != null) {
            ArrayList<Value> extraParams = new ArrayList<Value>();
            int mx = params.size();
            for (int i = this.args.size(); i < mx; ++i) {
                extraParams.add(params.get(i).reboundedTo(null));
            }
            Value rest = ListValue.wrap(extraParams).bindTo(this.varArgs);
            newFrame.setVariable(this.varArgs, (cc, tt) -> rest);
        }
        try {
            retVal = this.body.evalValue(newFrame, type);
        }
        catch (BreakStatement | ContinueStatement exc) {
            throw new ExpressionException(c, e, t, "'continue' and 'break' can only be called inside loop function bodies");
        }
        catch (ReturnStatement returnStatement) {
            retVal = returnStatement.retval;
        }
        Value otherRetVal = retVal;
        return (cc, tt) -> otherRetVal;
    }

    public Expression getExpression() {
        return this.expression;
    }

    public Tokenizer.Token getToken() {
        return this.token;
    }

    public List<String> getArguments() {
        return this.args;
    }

    public String getVarArgs() {
        return this.varArgs;
    }

    @Override
    public class_2520 toTag(boolean force) {
        if (!force) {
            throw new NBTSerializableValue.IncompatibleTypeException(this);
        }
        return class_2519.method_23256((String)this.getString());
    }

    public void assertArgsOk(List<?> list, Consumer<Boolean> feedback) {
        int size = list.size();
        if (this.varArgs == null && this.args.size() != size) {
            feedback.accept(true);
        } else if (this.varArgs != null && this.args.size() > size) {
            feedback.accept(false);
        }
    }

    @Override
    public boolean pure() {
        return false;
    }

    @Override
    public boolean transitive() {
        return false;
    }
}

