/*
 * Decompiled with CFR 0.152.
 */
package carpet.script;

import carpet.CarpetServer;
import carpet.CarpetSettings;
import carpet.script.CarpetContext;
import carpet.script.CarpetEventServer;
import carpet.script.CarpetExpression;
import carpet.script.CarpetScriptServer;
import carpet.script.Context;
import carpet.script.LazyValue;
import carpet.script.Module;
import carpet.script.ScriptHost;
import carpet.script.Tokenizer;
import carpet.script.argument.FileArgument;
import carpet.script.argument.FunctionArgument;
import carpet.script.command.CommandArgument;
import carpet.script.command.CommandToken;
import carpet.script.exception.CarpetExpressionException;
import carpet.script.exception.ExpressionException;
import carpet.script.exception.IntegrityException;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.InvalidCallbackException;
import carpet.script.exception.LoadException;
import carpet.script.utils.AppStoreManager;
import carpet.script.value.EntityValue;
import carpet.script.value.FunctionValue;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.utils.CarpetProfiler;
import carpet.utils.Messenger;
import com.google.gson.JsonElement;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.lang.invoke.CallSite;
import java.math.BigInteger;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.SemanticVersion;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import net.fabricmc.loader.api.metadata.version.VersionPredicate;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2338;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5575;
import org.apache.commons.lang3.tuple.Pair;

public class CarpetScriptHost
extends ScriptHost {
    public class_2168 responsibleSource;
    private class_2520 globalState;
    private int saveTimeout = 0;
    public boolean persistenceRequired = true;
    public Map<Value, Value> appConfig;
    public Map<String, CommandArgument> appArgTypes;
    Predicate<class_2168> commandValidator;
    boolean isRuleApp;
    public AppStoreManager.StoreNode storeSource;

    private CarpetScriptHost(CarpetScriptServer server, Module code, boolean perUser, ScriptHost parent, Map<Value, Value> config, Map<String, CommandArgument> argTypes, Predicate<class_2168> commandValidator, boolean isRuleApp) {
        super(code, server, perUser, parent);
        if (parent == null && code != null) {
            this.globalState = this.loadState();
        } else if (parent != null) {
            this.persistenceRequired = ((CarpetScriptHost)parent).persistenceRequired;
            this.strict = parent.strict;
        }
        this.appConfig = config;
        this.appArgTypes = argTypes;
        this.commandValidator = commandValidator;
        this.isRuleApp = isRuleApp;
        this.storeSource = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CarpetScriptHost create(CarpetScriptServer scriptServer, Module module, boolean perPlayer, class_2168 source, Predicate<class_2168> commandValidator, boolean isRuleApp, AppStoreManager.StoreNode storeSource) {
        CarpetScriptHost host = new CarpetScriptHost(scriptServer, module, perPlayer, null, Collections.emptyMap(), new HashMap<String, CommandArgument>(), commandValidator, isRuleApp);
        if (module != null) {
            try {
                host.setChatErrorSnooper(source);
                CarpetExpression ex = new CarpetExpression(host.main, module.code(), source, new class_2338(0, 0, 0));
                ex.getExpr().asATextSource();
                host.storeSource = storeSource;
                ex.scriptRunCommand(host, new class_2338(source.method_9222()));
            }
            catch (CarpetExpressionException e) {
                host.handleErrorWithStack("Error while evaluating expression", e);
                throw new LoadException();
            }
            catch (ArithmeticException ae) {
                host.handleErrorWithStack("Math doesn't compute", ae);
                throw new LoadException();
            }
            catch (StackOverflowError soe) {
                host.handleErrorWithStack("Your thoughts are too deep", soe);
            }
            finally {
                host.storeSource = null;
            }
        }
        return host;
    }

    private static int execute(CommandContext<class_2168> ctx, String hostName, FunctionArgument funcSpec, List<String> paramNames) throws CommandSyntaxException {
        CarpetProfiler.ProfilerToken currentSection = CarpetProfiler.start_section(null, "Scarpet command", CarpetProfiler.TYPE.GENERAL);
        CarpetScriptHost cHost = CarpetServer.scriptServer.modules.get(hostName).retrieveOwnForExecution((class_2168)ctx.getSource());
        List<String> argNames = funcSpec.function.getArguments();
        if (argNames.size() - funcSpec.args.size() != paramNames.size()) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)("Target function " + funcSpec.function.getPrettyString() + " as wrong number of arguments, required " + paramNames.size() + ", found " + argNames.size() + " with " + funcSpec.args.size() + " provided"))).create();
        }
        ArrayList<Value> args = new ArrayList<Value>(argNames.size());
        for (String s : paramNames) {
            args.add(CommandArgument.getValue(ctx, s, cHost));
        }
        args.addAll(funcSpec.args);
        Value response = cHost.handleCommand((class_2168)ctx.getSource(), funcSpec.function, args);
        int intres = (int)response.readInteger();
        CarpetProfiler.end_current_section(currentSection);
        return intres;
    }

    public LiteralArgumentBuilder<class_2168> addPathToCommand(LiteralArgumentBuilder<class_2168> command, List<CommandToken> path, FunctionArgument functionSpec) throws CommandSyntaxException {
        String hostName = this.main.name();
        List commandArgs = path.stream().filter(t -> t.isArgument).map(t -> t.surface).collect(Collectors.toList());
        if (commandArgs.size() != functionSpec.function.getNumParams() - functionSpec.args.size()) {
            throw CommandArgument.error("Number of parameters in function " + functionSpec.function.fullName() + " doesn't match parameters for a command");
        }
        if (path.isEmpty()) {
            return (LiteralArgumentBuilder)command.executes(c -> CarpetScriptHost.execute((CommandContext<class_2168>)c, hostName, functionSpec, Collections.emptyList()));
        }
        ArrayList<CommandToken> reversedPath = new ArrayList<CommandToken>(path);
        Collections.reverse(reversedPath);
        ArgumentBuilder argChain = ((CommandToken)reversedPath.get(0)).getCommandNode(this).executes(c -> CarpetScriptHost.execute((CommandContext<class_2168>)c, hostName, functionSpec, commandArgs));
        for (int i = 1; i < reversedPath.size(); ++i) {
            argChain = ((CommandToken)reversedPath.get(i)).getCommandNode(this).then(argChain);
        }
        return (LiteralArgumentBuilder)command.then(argChain);
    }

    public LiteralArgumentBuilder<class_2168> getNewCommandTree(List<Pair<List<CommandToken>, FunctionArgument>> entries, Predicate<class_2168> useValidator) throws CommandSyntaxException {
        String hostName = this.main.name();
        Predicate<class_2168> configValidator = this.getCommandConfigPermissions();
        LiteralArgumentBuilder<class_2168> command = (LiteralArgumentBuilder<class_2168>)class_2170.method_9247((String)hostName).requires(player -> CarpetServer.scriptServer.modules.containsKey(hostName) && useValidator.test((class_2168)player) && configValidator.test((class_2168)player));
        for (Pair<List<CommandToken>, FunctionArgument> commandData : entries) {
            command = this.addPathToCommand(command, (List)commandData.getKey(), (FunctionArgument)commandData.getValue());
        }
        return command;
    }

    public Predicate<class_2168> getCommandConfigPermissions() throws CommandSyntaxException {
        Value confValue = this.appConfig.get(StringValue.of("command_permission"));
        if (confValue == null) {
            return s -> true;
        }
        if (confValue instanceof NumericValue) {
            int level = ((NumericValue)confValue).getInt();
            if (level < 1 || level > 4) {
                throw CommandArgument.error("Numeric permission level for custom commands should be between 1 and 4");
            }
            return s -> s.method_9259(level);
        }
        if (!(confValue instanceof FunctionValue)) {
            String perm;
            switch (perm = confValue.getString().toLowerCase(Locale.ROOT)) {
                case "ops": {
                    return s -> s.method_9259(2);
                }
                case "server": {
                    return s -> !(s.method_9228() instanceof class_3222);
                }
                case "players": {
                    return s -> s.method_9228() instanceof class_3222;
                }
                case "all": {
                    return s -> true;
                }
            }
            throw CommandArgument.error("Unknown command permission: " + perm);
        }
        FunctionValue fun = (FunctionValue)confValue;
        if (fun.getNumParams() != 1) {
            throw CommandArgument.error("Custom command permission function should expect 1 argument");
        }
        String hostName = this.getName();
        return s -> {
            try {
                CarpetProfiler.ProfilerToken currentSection = CarpetProfiler.start_section(null, "Scarpet command", CarpetProfiler.TYPE.GENERAL);
                CarpetScriptHost cHost = null;
                cHost = CarpetServer.scriptServer.modules.get(hostName).retrieveOwnForExecution((class_2168)s);
                Value response = cHost.handleCommand((class_2168)s, fun, Collections.singletonList(s.method_9228() instanceof class_3222 ? new EntityValue(s.method_9228()) : Value.NULL));
                boolean res = response.getBoolean();
                CarpetProfiler.end_current_section(currentSection);
                return res;
            }
            catch (CommandSyntaxException e) {
                Messenger.m(s, "rb Unable to run app command: " + e.getMessage());
                return false;
            }
        };
    }

    @Override
    protected ScriptHost duplicate() {
        return new CarpetScriptHost(this.scriptServer(), this.main, false, this, this.appConfig, this.appArgTypes, this.commandValidator, this.isRuleApp);
    }

    @Override
    protected void setupUserHost(ScriptHost host) {
        super.setupUserHost(host);
        CarpetScriptHost child = (CarpetScriptHost)host;
        CarpetEventServer.Event.transferAllHostEventsToChild(child);
        FunctionValue onStart = child.getFunction("__on_start");
        if (onStart != null) {
            child.callNow(onStart, Collections.emptyList());
        }
    }

    @Override
    public void addUserDefinedFunction(Context ctx, Module module, String funName, FunctionValue function) {
        super.addUserDefinedFunction(ctx, module, funName, function);
        if (ctx.host.main != module) {
            return;
        }
        if (funName.startsWith("__")) {
            if (funName.startsWith("__on_")) {
                String event = funName.replaceFirst("__on_", "");
                if (CarpetEventServer.Event.byName.containsKey(event)) {
                    this.scriptServer().events.addBuiltInEvent(event, this, function, null);
                }
            } else if (funName.equals("__config") && !this.readConfig()) {
                throw new InternalExpressionException("Invalid app config (via '__config()' function)");
            }
        }
    }

    private boolean readConfig() {
        try {
            FunctionValue configFunction = this.getFunction("__config");
            if (configFunction == null) {
                return false;
            }
            Value ret = this.callNow(configFunction, Collections.emptyList());
            if (!(ret instanceof MapValue)) {
                return false;
            }
            Map<Value, Value> config = ((MapValue)ret).getMap();
            this.setPerPlayer(config.getOrDefault(new StringValue("scope"), new StringValue("player")).getString().equalsIgnoreCase("player"));
            this.persistenceRequired = config.getOrDefault(new StringValue("stay_loaded"), Value.TRUE).getBoolean();
            this.strict = config.getOrDefault(StringValue.of("strict"), Value.FALSE).getBoolean();
            Value loadRequirements = config.get(new StringValue("requires"));
            if (loadRequirements instanceof FunctionValue) {
                Value reqResult = this.callNow((FunctionValue)loadRequirements, Collections.emptyList());
                if (reqResult.getBoolean()) {
                    throw new LoadException(reqResult.getString());
                }
            } else {
                this.checkModVersionRequirements(loadRequirements);
            }
            if (this.storeSource != null) {
                Value libraries;
                Value resources = config.get(new StringValue("resources"));
                if (resources != null) {
                    if (!(resources instanceof ListValue)) {
                        throw new InternalExpressionException("App resources not defined as a list");
                    }
                    for (Value resource : ((ListValue)resources).getItems()) {
                        AppStoreManager.addResource(this, this.storeSource, resource);
                    }
                }
                if ((libraries = config.get(new StringValue("libraries"))) != null) {
                    if (!(libraries instanceof ListValue)) {
                        throw new InternalExpressionException("App libraries not defined as a list");
                    }
                    for (Value library : ((ListValue)libraries).getItems()) {
                        AppStoreManager.addLibrary(this, this.storeSource, library);
                    }
                }
            }
            this.appConfig = config;
        }
        catch (NullPointerException ignored) {
            return false;
        }
        return true;
    }

    public void readCustomArgumentTypes() throws CommandSyntaxException {
        Value arguments = this.appConfig.get(StringValue.of("arguments"));
        if (arguments != null) {
            if (!(arguments instanceof MapValue)) {
                throw CommandArgument.error("'arguments' element in config should be a map");
            }
            this.appArgTypes.clear();
            for (Map.Entry<Value, Value> typeData : ((MapValue)arguments).getMap().entrySet()) {
                String argument = typeData.getKey().getString();
                Value spec = typeData.getValue();
                if (!(spec instanceof MapValue)) {
                    throw CommandArgument.error("Spec for '" + argument + "' should be a map");
                }
                Map<String, Value> specData = ((MapValue)spec).getMap().entrySet().stream().collect(Collectors.toMap(e -> ((Value)e.getKey()).getString(), Map.Entry::getValue));
                this.appArgTypes.put(argument, CommandArgument.buildFromConfig(argument, specData, this));
            }
        }
    }

    public Boolean addAppCommands(Consumer<class_2561> notifier) {
        try {
            this.readCustomArgumentTypes();
        }
        catch (CommandSyntaxException e) {
            notifier.accept(Messenger.c("r Error when handling of setting up custom argument types: " + e.getMessage()));
            return false;
        }
        if (this.appConfig.get(StringValue.of("commands")) != null) {
            try {
                LiteralArgumentBuilder<class_2168> command = this.readCommands(this.commandValidator);
                if (command != null) {
                    this.scriptServer().server.method_3734().method_9235().register(command);
                    return true;
                }
                return false;
            }
            catch (CommandSyntaxException cse) {
                notifier.accept(Messenger.c("r Failed to build command system for " + this.getName() + " thus failed to load the app: ", cse.getRawMessage()));
                return null;
            }
        }
        return this.addLegacyCommand(notifier);
    }

    public void checkModVersionRequirements(Value reqs) {
        if (reqs == null) {
            return;
        }
        if (!(reqs instanceof MapValue)) {
            throw new InternalExpressionException("`requires` field must be a map of mod dependencies or a function to be executed");
        }
        Map<Value, Value> requirements = ((MapValue)reqs).getMap();
        for (Map.Entry<Value, Value> requirement : requirements.entrySet()) {
            Version presentVersion;
            VersionPredicate predicate;
            String requiredModId = requirement.getKey().getString();
            String stringPredicate = requirement.getValue().getString();
            try {
                predicate = VersionPredicate.parse((String)stringPredicate);
            }
            catch (VersionParsingException e) {
                throw new InternalExpressionException("Failed to parse version conditions for '" + requiredModId + "' in 'requires': " + e.getMessage());
            }
            ModContainer mod = FabricLoader.getInstance().getModContainer(requiredModId).orElse(null);
            if (mod != null && (predicate.test((Object)(presentVersion = mod.getMetadata().getVersion())) || FabricLoader.getInstance().isDevelopmentEnvironment() && !(presentVersion instanceof SemanticVersion))) continue;
            throw new LoadException(String.format("%s requires a version of mod '%s' matching '%s', which is missing!", this.getName(), requiredModId, stringPredicate));
        }
    }

    private Boolean addLegacyCommand(Consumer<class_2561> notifier) {
        Predicate<class_2168> configValidator;
        if (this.main == null) {
            return false;
        }
        if (this.getFunction("__command") == null) {
            return false;
        }
        if (this.scriptServer().isInvalidCommandRoot(this.getName())) {
            notifier.accept(Messenger.c("gi Tried to mask vanilla command."));
            return null;
        }
        try {
            configValidator = this.getCommandConfigPermissions();
        }
        catch (CommandSyntaxException e) {
            notifier.accept(Messenger.c("rb " + e.getMessage()));
            return null;
        }
        String hostName = this.getName();
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)hostName).requires(player -> this.scriptServer().modules.containsKey(hostName) && this.commandValidator.test((class_2168)player) && configValidator.test((class_2168)player))).executes(c -> {
            CarpetScriptHost targetHost = this.scriptServer().modules.get(hostName).retrieveOwnForExecution((class_2168)c.getSource());
            Value response = targetHost.handleCommandLegacy((class_2168)c.getSource(), "__command", null, "");
            if (!response.isNull()) {
                Messenger.m((class_2168)c.getSource(), "gi " + response.getString());
            }
            return (int)response.readInteger();
        });
        boolean hasTypeSupport = this.appConfig.getOrDefault(StringValue.of("legacy_command_type_support"), Value.FALSE).getBoolean();
        for (String function : this.globalFunctionNames(this.main, s -> !s.startsWith("_")).sorted().collect(Collectors.toList())) {
            if (hasTypeSupport) {
                try {
                    FunctionValue functionValue = this.getFunction(function);
                    command = this.addPathToCommand((LiteralArgumentBuilder<class_2168>)command, CommandToken.parseSpec(CommandToken.specFromSignature(functionValue), this), FunctionArgument.fromCommandSpec(this, functionValue));
                    continue;
                }
                catch (CommandSyntaxException e) {
                    return false;
                }
            }
            command = (LiteralArgumentBuilder)command.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)function).requires(player -> this.scriptServer().modules.containsKey(hostName) && this.scriptServer().modules.get(hostName).getFunction(function) != null)).executes(c -> {
                CarpetScriptHost targetHost = this.scriptServer().modules.get(hostName).retrieveOwnForExecution((class_2168)c.getSource());
                Value response = targetHost.handleCommandLegacy((class_2168)c.getSource(), function, null, "");
                if (!response.isNull()) {
                    Messenger.m((class_2168)c.getSource(), "gi " + response.getString());
                }
                return (int)response.readInteger();
            })).then(class_2170.method_9244((String)"args...", (ArgumentType)StringArgumentType.greedyString()).executes(c -> {
                CarpetScriptHost targetHost = this.scriptServer().modules.get(hostName).retrieveOwnForExecution((class_2168)c.getSource());
                Value response = targetHost.handleCommandLegacy((class_2168)c.getSource(), function, null, StringArgumentType.getString((CommandContext)c, (String)"args..."));
                if (!response.isNull()) {
                    Messenger.m((class_2168)c.getSource(), "gi " + response.getString());
                }
                return (int)response.readInteger();
            })));
        }
        this.scriptServer().server.method_3734().method_9235().register(command);
        return true;
    }

    public LiteralArgumentBuilder<class_2168> readCommands(Predicate<class_2168> useValidator) throws CommandSyntaxException {
        Value commands = this.appConfig.get(StringValue.of("commands"));
        if (commands == null) {
            return null;
        }
        if (!(commands instanceof MapValue)) {
            throw CommandArgument.error("'commands' element in config should be a map");
        }
        ArrayList<Pair<List<CommandToken>, FunctionArgument>> commandEntries = new ArrayList<Pair<List<CommandToken>, FunctionArgument>>();
        for (Map.Entry commandsData : ((MapValue)commands).getMap().entrySet().stream().sorted(Map.Entry.comparingByKey()).collect(Collectors.toList())) {
            List<CommandToken> elements = CommandToken.parseSpec(((Value)commandsData.getKey()).getString(), this);
            FunctionArgument funSpec = FunctionArgument.fromCommandSpec(this, (Value)commandsData.getValue());
            commandEntries.add((Pair<List<CommandToken>, FunctionArgument>)Pair.of(elements, (Object)funSpec));
        }
        commandEntries.sort(new ListComparator());
        if (!this.appConfig.getOrDefault(StringValue.of("allow_command_conflicts"), Value.FALSE).getBoolean()) {
            block1: for (int i = 0; i < commandEntries.size() - 1; ++i) {
                List first = (List)((Pair)commandEntries.get(i)).getKey();
                List other = (List)((Pair)commandEntries.get(i + 1)).getKey();
                int checkSize = Math.min(first.size(), other.size());
                for (int t = 0; t < checkSize; ++t) {
                    CommandToken tik = (CommandToken)first.get(t);
                    CommandToken tok = (CommandToken)other.get(t);
                    if (tik.isArgument && tok.isArgument && !tik.surface.equals(tok.surface)) {
                        throw CommandArgument.error("Conflicting commands: \n - [" + first.stream().map(tt -> tt.surface).collect(Collectors.joining(" ")) + "] at " + tik.surface + "\n - [" + other.stream().map(tt -> tt.surface).collect(Collectors.joining(" ")) + "] at " + tok.surface + "\n");
                    }
                    if (!tik.equals(tok)) continue block1;
                }
            }
        }
        return this.getNewCommandTree(commandEntries, useValidator);
    }

    @Override
    protected Module getModuleOrLibraryByName(String name) {
        Module module = this.scriptServer().getModule(name, true);
        if (module == null) {
            throw new InternalExpressionException("Unable to locate package: " + name);
        }
        return module;
    }

    @Override
    protected void runModuleCode(Context c, Module module) {
        CarpetContext cc = (CarpetContext)c;
        CarpetExpression ex = new CarpetExpression(module, module.code(), cc.s, cc.origin);
        ex.getExpr().asATextSource();
        ex.scriptRunCommand(this, cc.origin);
    }

    @Override
    public void delFunction(Module module, String funName) {
        super.delFunction(module, funName);
        if (funName.startsWith("__on_")) {
            String event = funName.replaceFirst("__on_", "");
            this.scriptServer().events.removeBuiltInEvent(event, this, funName);
        }
    }

    public CarpetScriptHost retrieveForExecution(class_2168 source, class_3222 player) {
        CarpetScriptHost target = null;
        if (!this.perUser) {
            target = this;
        } else if (player != null) {
            target = (CarpetScriptHost)this.retrieveForExecution(player.method_5820());
        }
        if (target != null && target.errorSnooper == null) {
            target.setChatErrorSnooper(source);
        }
        return target;
    }

    public CarpetScriptHost retrieveOwnForExecution(class_2168 source) throws CommandSyntaxException {
        class_3222 player;
        if (!this.perUser) {
            if (this.errorSnooper == null) {
                this.setChatErrorSnooper(source);
            }
            return this;
        }
        try {
            player = source.method_9207();
        }
        catch (CommandSyntaxException ignored) {
            throw new SimpleCommandExceptionType((Message)class_2561.method_43470((String)"Cannot run player based apps without the player context")).create();
        }
        CarpetScriptHost userHost = (CarpetScriptHost)this.retrieveForExecution(player.method_5820());
        if (userHost.errorSnooper == null) {
            userHost.setChatErrorSnooper(source);
        }
        return userHost;
    }

    public Value handleCommandLegacy(class_2168 source, String call, List<Integer> coords, String arg) {
        try {
            CarpetProfiler.ProfilerToken currentSection = CarpetProfiler.start_section(null, "Scarpet command", CarpetProfiler.TYPE.GENERAL);
            Value res = this.callLegacy(source, call, coords, arg);
            CarpetProfiler.end_current_section(currentSection);
            return res;
        }
        catch (CarpetExpressionException exc) {
            this.handleErrorWithStack("Error while running custom command", exc);
        }
        catch (ArithmeticException ae) {
            this.handleErrorWithStack("Math doesn't compute", ae);
        }
        catch (StackOverflowError soe) {
            this.handleErrorWithStack("Your thoughts are too deep", soe);
        }
        return Value.NULL;
    }

    public Value handleCommand(class_2168 source, FunctionValue function, List<Value> args) {
        try {
            return this.scriptServer().events.handleEvents.getWhileDisabled(() -> this.call(source, function, args));
        }
        catch (CarpetExpressionException exc) {
            this.handleErrorWithStack("Error while running custom command", exc);
        }
        catch (ArithmeticException ae) {
            this.handleErrorWithStack("Math doesn't compute", ae);
        }
        catch (StackOverflowError soe) {
            this.handleErrorWithStack("Your thoughts are too deep", soe);
        }
        return Value.NULL;
    }

    public Value callLegacy(class_2168 source, String call, List<Integer> coords, String arg) {
        if (CarpetServer.scriptServer.stopAll) {
            throw new CarpetExpressionException("SCARPET PAUSED (unpause with /script resume)", null);
        }
        FunctionValue function = this.getFunction(call);
        if (function == null) {
            throw new CarpetExpressionException("Couldn't find function '" + call + "' in app '" + this.getName() + "'", null);
        }
        ArrayList<LazyValue> argv = new ArrayList<LazyValue>();
        if (coords != null) {
            for (Integer n : coords) {
                argv.add((c, t) -> new NumericValue(n.intValue()));
            }
        }
        String sign = "";
        for (Tokenizer.Token tok : Tokenizer.simplepass(arg)) {
            switch (tok.type) {
                case VARIABLE: {
                    LazyValue var = this.getGlobalVariable(tok.surface);
                    if (var == null) break;
                    argv.add(var);
                    break;
                }
                case STRINGPARAM: {
                    argv.add((c, t) -> new StringValue(tok.surface));
                    sign = "";
                    break;
                }
                case LITERAL: {
                    String finalSign;
                    try {
                        finalSign = sign;
                        argv.add((c, t) -> new NumericValue(finalSign + tok.surface));
                        sign = "";
                        break;
                    }
                    catch (NumberFormatException exception) {
                        throw new CarpetExpressionException("Fail: " + sign + tok.surface + " seems like a number but it is not a number. Use quotes to ensure its a string", null);
                    }
                }
                case HEX_LITERAL: {
                    String finalSign;
                    try {
                        finalSign = sign;
                        argv.add((c, t) -> new NumericValue(new BigInteger(finalSign + tok.surface.substring(2), 16).doubleValue()));
                        sign = "";
                        break;
                    }
                    catch (NumberFormatException exception) {
                        throw new CarpetExpressionException("Fail: " + sign + tok.surface + " seems like a number but it is not a number. Use quotes to ensure its a string", null);
                    }
                }
                case OPERATOR: 
                case UNARY_OPERATOR: {
                    if ((tok.surface.equals("-") || tok.surface.equals("-u")) && sign.isEmpty()) {
                        sign = "-";
                        break;
                    }
                    throw new CarpetExpressionException("Fail: operators, like " + tok.surface + " are not allowed in invoke", null);
                }
                case FUNCTION: {
                    throw new CarpetExpressionException("Fail: passing functions like " + tok.surface + "() to invoke is not allowed", null);
                }
                case OPEN_PAREN: 
                case COMMA: 
                case CLOSE_PAREN: 
                case MARKER: {
                    throw new CarpetExpressionException("Fail: " + tok.surface + " is not allowed in invoke", null);
                }
            }
        }
        List<String> list = function.getArguments();
        if (argv.size() != list.size()) {
            String error = "Fail: stored function " + call + " takes " + list.size() + " arguments, not " + argv.size() + ":\n";
            for (int i = 0; i < Math.max(argv.size(), list.size()); ++i) {
                error = error + (i < list.size() ? list.get(i) : "??") + " => " + (i < argv.size() ? ((LazyValue)argv.get(i)).evalValue(null).getString() : "??") + "\n";
            }
            throw new CarpetExpressionException(error, null);
        }
        try {
            this.assertAppIntegrity(function.getModule());
            CarpetContext context = new CarpetContext(this, source, class_2338.field_10980);
            return this.scriptServer().events.handleEvents.getWhileDisabled(() -> function.getExpression().evalValue(() -> function.lazyEval(context, Context.VOID, function.getExpression(), function.getToken(), argv), context, Context.VOID));
        }
        catch (ExpressionException e) {
            throw new CarpetExpressionException(e.getMessage(), e.stack);
        }
    }

    public Value call(class_2168 source, FunctionValue function, List<Value> argv) {
        if (CarpetServer.scriptServer.stopAll) {
            throw new CarpetExpressionException("SCARPET PAUSED (unpause with /script resume)", null);
        }
        List<String> args = function.getArguments();
        if (argv.size() != args.size()) {
            String error = "Fail: stored function " + function.getPrettyString() + " takes " + args.size() + " arguments, not " + argv.size() + ":\n";
            for (int i = 0; i < Math.max(argv.size(), args.size()); ++i) {
                error = error + (i < args.size() ? args.get(i) : "??") + " => " + (i < argv.size() ? argv.get(i).getString() : "??") + "\n";
            }
            throw new CarpetExpressionException(error, null);
        }
        try {
            this.assertAppIntegrity(function.getModule());
            CarpetContext context = new CarpetContext(this, source, class_2338.field_10980);
            return function.getExpression().evalValue(() -> function.execute(context, Context.VOID, function.getExpression(), function.getToken(), argv), context, Context.VOID);
        }
        catch (ExpressionException e) {
            throw new CarpetExpressionException(e.getMessage(), e.stack);
        }
    }

    public Value callUDF(class_2338 pos, class_2168 source, FunctionValue fun, List<Value> argv) throws InvalidCallbackException, IntegrityException {
        if (CarpetServer.scriptServer.stopAll) {
            return Value.NULL;
        }
        try {
            fun.assertArgsOk(argv, b -> {
                throw new InternalExpressionException("");
            });
        }
        catch (InternalExpressionException ignored) {
            throw new InvalidCallbackException();
        }
        try {
            this.assertAppIntegrity(fun.getModule());
            CarpetContext context = new CarpetContext(this, source, pos);
            return fun.getExpression().evalValue(() -> fun.execute(context, Context.VOID, fun.getExpression(), fun.getToken(), argv), context, Context.VOID);
        }
        catch (ExpressionException e) {
            this.handleExpressionException("Callback failed", e);
            return Value.NULL;
        }
    }

    public Value callNow(FunctionValue fun, List<Value> arguments) {
        class_3222 player = this.user == null ? null : this.scriptServer().server.method_3760().method_14566(this.user);
        class_2168 source = player != null ? player.method_5671() : this.scriptServer().server.method_3739();
        return this.scriptServer().events.handleEvents.getWhileDisabled(() -> {
            try {
                return this.callUDF(class_2338.field_10980, source, fun, arguments);
            }
            catch (InvalidCallbackException ignored) {
                return Value.NULL;
            }
        });
    }

    @Override
    public void onClose() {
        super.onClose();
        FunctionValue closing = this.getFunction("__on_close");
        if (!(closing == null || this.parent == null && this.isPerUser())) {
            this.callNow(closing, Collections.emptyList());
        }
        if (this.user == null) {
            String markerName = "__scarpet_marker_" + (this.getName() == null ? "" : this.getName());
            for (class_3218 world : this.scriptServer().server.method_3738()) {
                for (class_1297 e : world.method_18198((class_5575)class_1299.field_6131, as -> as.method_5752().contains(markerName))) {
                    e.method_31472();
                }
            }
            if (this.saveTimeout > 0) {
                this.dumpState();
            }
        }
    }

    private void dumpState() {
        Module.saveData(this.main, this.globalState);
    }

    private class_2520 loadState() {
        return Module.getData(this.main);
    }

    public class_2520 readFileTag(FileArgument fdesc) {
        if (this.getName() == null && !fdesc.isShared) {
            return null;
        }
        if (fdesc.resource != null) {
            return fdesc.getNbtData(this.main);
        }
        if (this.parent == null) {
            return this.globalState;
        }
        return ((CarpetScriptHost)this.parent).globalState;
    }

    public boolean writeTagFile(class_2520 tag, FileArgument fdesc) {
        if (this.getName() == null && !fdesc.isShared) {
            return false;
        }
        if (fdesc.resource != null) {
            return fdesc.saveNbtData(this.main, tag);
        }
        CarpetScriptHost responsibleHost = this.parent != null ? (CarpetScriptHost)this.parent : this;
        responsibleHost.globalState = tag;
        if (responsibleHost.saveTimeout == 0) {
            responsibleHost.dumpState();
            responsibleHost.saveTimeout = 200;
        }
        return true;
    }

    public boolean removeResourceFile(FileArgument fdesc) {
        if (this.getName() == null && !fdesc.isShared) {
            return false;
        }
        return fdesc.dropExistingFile(this.main);
    }

    public boolean appendLogFile(FileArgument fdesc, List<String> data) {
        if (this.getName() == null && !fdesc.isShared) {
            return false;
        }
        return fdesc.appendToTextFile(this.main, data);
    }

    public List<String> readTextResource(FileArgument fdesc) {
        if (this.getName() == null && !fdesc.isShared) {
            return null;
        }
        return fdesc.listFile(this.main);
    }

    public JsonElement readJsonFile(FileArgument fdesc) {
        if (this.getName() == null && !fdesc.isShared) {
            return null;
        }
        return fdesc.readJsonFile(this.main);
    }

    public Stream<String> listFolder(FileArgument fdesc) {
        if (this.getName() == null && !fdesc.isShared) {
            return null;
        }
        return fdesc.listFolder(this.main);
    }

    public boolean applyActionForResource(String path, boolean shared, Consumer<Path> action) {
        FileArgument fdesc = FileArgument.resourceFromPath(path, FileArgument.Reason.CREATE, shared);
        return fdesc.findPathAndApply(this.main, action);
    }

    public void tick() {
        if (this.saveTimeout > 0) {
            --this.saveTimeout;
            if (this.saveTimeout == 0) {
                this.dumpState();
            }
        }
    }

    public void setChatErrorSnooper(class_2168 source) {
        this.responsibleSource = source;
        this.errorSnooper = (expr, token, ctx, message) -> {
            try {
                source.method_9207();
            }
            catch (CommandSyntaxException e) {
                return null;
            }
            String shebang = message + " in " + expr.getModuleName();
            if (token != null) {
                String[] lines = expr.getCodeString().split("\n");
                shebang = lines.length > 1 ? shebang + " at line " + (token.lineno + 1) + ", pos " + (token.linepos + 1) : shebang + " at pos " + (token.pos + 1);
                Messenger.m(source, "r " + shebang);
                if (lines.length > 1 && token.lineno > 0) {
                    Messenger.m(source, CarpetScriptHost.withLocals("l", lines[token.lineno - 1], ctx));
                }
                Messenger.m(source, CarpetScriptHost.withLocals("l", lines[token.lineno].substring(0, token.linepos), ctx), "r  HERE>> ", CarpetScriptHost.withLocals("l", lines[token.lineno].substring(token.linepos), ctx));
                if (lines.length > 1 && token.lineno < lines.length - 1) {
                    Messenger.m(source, CarpetScriptHost.withLocals("l", lines[token.lineno + 1], ctx));
                }
            } else {
                Messenger.m(source, "r " + shebang);
            }
            return new ArrayList();
        };
    }

    private static class_2561 withLocals(String format, String line, Context context) {
        format = (String)format + " ";
        ArrayList<CallSite> stringsToFormat = new ArrayList<CallSite>();
        TreeMap<Integer, String> posToLocal = new TreeMap<Integer, String>();
        for (String local : context.variables.keySet()) {
            int pos = line.indexOf(local);
            while (pos != -1) {
                posToLocal.merge(pos, local, (existingLocal, newLocal) -> {
                    if (newLocal.length() > existingLocal.length()) {
                        return local;
                    }
                    return existingLocal;
                });
                pos = line.indexOf(local, pos + 1);
            }
        }
        int lastPos = 0;
        for (Map.Entry foundLocal : posToLocal.entrySet()) {
            String value;
            if ((Integer)foundLocal.getKey() < lastPos) continue;
            stringsToFormat.add((CallSite)((Object)((String)format + line.substring(lastPos, (Integer)foundLocal.getKey()))));
            stringsToFormat.add((CallSite)((Object)((String)format + (String)foundLocal.getValue())));
            Value val = context.variables.get(foundLocal.getValue()).evalValue(context);
            String type = val.getTypeString();
            try {
                value = val.getPrettyString();
            }
            catch (StackOverflowError e) {
                value = "Exception while rendering variable, there seems to be a recursive reference in there";
            }
            stringsToFormat.add((CallSite)((Object)("^ Value of '" + (String)foundLocal.getValue() + "' at position (" + type + "): \n" + value)));
            lastPos = (Integer)foundLocal.getKey() + ((String)foundLocal.getValue()).length();
        }
        if (line.length() != lastPos) {
            stringsToFormat.add((CallSite)((Object)((String)format + line.substring(lastPos, line.length()))));
        }
        return Messenger.c(stringsToFormat.toArray());
    }

    @Override
    public void resetErrorSnooper() {
        this.responsibleSource = null;
        super.resetErrorSnooper();
    }

    public void handleErrorWithStack(String intro, Throwable exception) {
        if (this.responsibleSource != null) {
            if (exception instanceof CarpetExpressionException) {
                ((CarpetExpressionException)exception).printStack(this.responsibleSource);
            }
            String message = exception.getMessage();
            Messenger.m(this.responsibleSource, "r " + intro + (String)(message == null || message.isEmpty() ? "" : ": " + message));
        } else {
            CarpetSettings.LOG.error(intro + ": " + exception.getMessage());
        }
    }

    @Override
    public synchronized void handleExpressionException(String message, ExpressionException exc) {
        this.handleErrorWithStack(message, new CarpetExpressionException(exc.getMessage(), exc.stack));
    }

    @Deprecated(forRemoval=true)
    public CarpetScriptServer getScriptServer() {
        return this.scriptServer();
    }

    @Override
    public CarpetScriptServer scriptServer() {
        return (CarpetScriptServer)super.scriptServer();
    }

    @Override
    public boolean issueDeprecation(String feature) {
        if (super.issueDeprecation(feature)) {
            Messenger.m(this.responsibleSource, "rb '" + feature + "' is deprecated and soon will be removed. Please consult the docs for their replacement");
            return true;
        }
        return false;
    }

    static class ListComparator<T extends Comparable<T>>
    implements Comparator<Pair<List<T>, ?>> {
        ListComparator() {
        }

        @Override
        public int compare(Pair<List<T>, ?> p1, Pair<List<T>, ?> p2) {
            List o1 = (List)p1.getKey();
            List o2 = (List)p2.getKey();
            for (int i = 0; i < Math.min(o1.size(), o2.size()); ++i) {
                int c = ((Comparable)o1.get(i)).compareTo((Comparable)o2.get(i));
                if (c == 0) continue;
                return c;
            }
            return Integer.compare(o1.size(), o2.size());
        }
    }
}

