/*
 * Decompiled with CFR 0.152.
 */
package carpet.helpers;

import carpet.fakes.RedstoneWireBlockInterface;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2457;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4538;

public class RedstoneWireTurbo {
    private final class_2457 wire;
    private List<UpdateNode> updateQueue0 = new ArrayList<UpdateNode>();
    private List<UpdateNode> updateQueue1 = new ArrayList<UpdateNode>();
    private List<UpdateNode> updateQueue2 = new ArrayList<UpdateNode>();
    private static final boolean[] update_redstone = new boolean[]{true, true, false, false, true, true, false, true, true, false, false, false, true, true, false, false, false, true, true, false, true, true, false, false};
    private static final int North = 0;
    private static final int East = 1;
    private static final int South = 2;
    private static final int West = 3;
    private static final char[] dirname = new char[]{'N', 'E', 'S', 'W'};
    private static final int[] forward_is_north = new int[]{2, 3, 16, 19, 0, 4, 1, 5, 7, 8, 17, 20, 12, 13, 18, 21, 6, 9, 22, 14, 11, 10, 23, 15};
    private static final int[] forward_is_east = new int[]{2, 3, 16, 19, 4, 1, 5, 0, 17, 20, 12, 13, 18, 21, 7, 8, 22, 14, 11, 15, 23, 9, 6, 10};
    private static final int[] forward_is_south = new int[]{2, 3, 16, 19, 1, 5, 0, 4, 12, 13, 18, 21, 7, 8, 17, 20, 11, 15, 23, 10, 6, 14, 22, 9};
    private static final int[] forward_is_west = new int[]{2, 3, 16, 19, 5, 0, 4, 1, 18, 21, 7, 8, 17, 20, 12, 13, 23, 10, 6, 9, 22, 15, 11, 14};
    private static final int[][] reordering = new int[][]{forward_is_north, forward_is_east, forward_is_south, forward_is_west};
    private final Map<class_2338, UpdateNode> nodeCache = new HashMap<class_2338, UpdateNode>();
    private static final boolean old_current_change = false;
    private int currentWalkLayer = 0;
    private static final int[] rs_neighbors = new int[]{4, 5, 6, 7};
    private static final int[] rs_neighbors_up = new int[]{9, 11, 13, 15};
    private static final int[] rs_neighbors_dn = new int[]{8, 10, 12, 14};

    public RedstoneWireTurbo(class_2457 wire) {
        this.wire = wire;
    }

    public static class_2338[] computeAllNeighbors(class_2338 pos) {
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        class_2338[] n = new class_2338[]{new class_2338(x - 1, y, z), new class_2338(x + 1, y, z), new class_2338(x, y - 1, z), new class_2338(x, y + 1, z), new class_2338(x, y, z - 1), new class_2338(x, y, z + 1), new class_2338(x - 2, y, z), new class_2338(x - 1, y - 1, z), new class_2338(x - 1, y + 1, z), new class_2338(x - 1, y, z - 1), new class_2338(x - 1, y, z + 1), new class_2338(x + 2, y, z), new class_2338(x + 1, y - 1, z), new class_2338(x + 1, y + 1, z), new class_2338(x + 1, y, z - 1), new class_2338(x + 1, y, z + 1), new class_2338(x, y - 2, z), new class_2338(x, y - 1, z - 1), new class_2338(x, y - 1, z + 1), new class_2338(x, y + 2, z), new class_2338(x, y + 1, z - 1), new class_2338(x, y + 1, z + 1), new class_2338(x, y, z - 2), new class_2338(x, y, z + 2)};
        return n;
    }

    private static void orientNeighbors(UpdateNode[] src, UpdateNode[] dst, int heading) {
        int[] re = reordering[heading];
        for (int i = 0; i < 24; ++i) {
            dst[i] = src[re[i]];
        }
    }

    private void identifyNode(class_1937 worldIn, UpdateNode upd1) {
        class_2680 oldState;
        class_2338 pos = upd1.self;
        upd1.currentState = oldState = worldIn.method_8320(pos);
        class_2248 block = oldState.method_26204();
        if (block != this.wire) {
            upd1.type = UpdateNode.Type.OTHER;
            return;
        }
        if (!oldState.method_26184((class_4538)worldIn, pos)) {
            class_2248.method_9497((class_2680)oldState, (class_1937)worldIn, (class_2338)pos);
            worldIn.method_8650(pos, false);
            upd1.type = UpdateNode.Type.OTHER;
            return;
        }
        upd1.type = UpdateNode.Type.REDSTONE;
    }

    private static int computeHeading(int rx, int rz) {
        int code = rx + 1 + 3 * (rz + 1);
        switch (code) {
            case 0: {
                int j = ThreadLocalRandom.current().nextInt(0, 1);
                return j == 0 ? 0 : 3;
            }
            case 1: {
                return 0;
            }
            case 2: {
                int j = ThreadLocalRandom.current().nextInt(0, 1);
                return j == 0 ? 0 : 1;
            }
            case 3: {
                return 3;
            }
            case 4: {
                return ThreadLocalRandom.current().nextInt(0, 4);
            }
            case 5: {
                return 1;
            }
            case 6: {
                int j = ThreadLocalRandom.current().nextInt(0, 1);
                return j == 0 ? 2 : 3;
            }
            case 7: {
                return 2;
            }
            case 8: {
                int j = ThreadLocalRandom.current().nextInt(0, 1);
                return j == 0 ? 2 : 1;
            }
        }
        return ThreadLocalRandom.current().nextInt(0, 4);
    }

    private void updateNode(class_1937 worldIn, UpdateNode upd1, int layer) {
        class_2338 pos = upd1.self;
        upd1.visited = true;
        class_2680 oldState = upd1.currentState;
        class_2680 newState = this.calculateCurrentChanges(worldIn, upd1);
        if (newState != oldState) {
            upd1.currentState = newState;
            this.propagateChanges(worldIn, upd1, layer);
        }
    }

    private void findNeighbors(class_1937 worldIn, UpdateNode upd1) {
        int heading;
        class_2338 pos = upd1.self;
        class_2338[] neighbors = RedstoneWireTurbo.computeAllNeighbors(pos);
        UpdateNode[] neighbor_nodes = new UpdateNode[24];
        upd1.neighbor_nodes = new UpdateNode[24];
        for (int i = 0; i < 24; ++i) {
            class_2338 pos2 = neighbors[i];
            UpdateNode upd2 = this.nodeCache.get(pos2);
            if (upd2 == null) {
                upd2 = new UpdateNode();
                upd2.self = pos2;
                upd2.parent = pos;
                this.nodeCache.put(pos2, upd2);
                this.identifyNode(worldIn, upd2);
            }
            if (!update_redstone[i] && upd2.type == UpdateNode.Type.REDSTONE) continue;
            neighbor_nodes[i] = upd2;
        }
        boolean fromWest = neighbor_nodes[0].visited || neighbor_nodes[7].visited || neighbor_nodes[8].visited;
        boolean fromEast = neighbor_nodes[1].visited || neighbor_nodes[12].visited || neighbor_nodes[13].visited;
        boolean fromNorth = neighbor_nodes[4].visited || neighbor_nodes[17].visited || neighbor_nodes[20].visited;
        boolean fromSouth = neighbor_nodes[5].visited || neighbor_nodes[18].visited || neighbor_nodes[21].visited;
        int cx = 0;
        int cz = 0;
        if (fromWest) {
            ++cx;
        }
        if (fromEast) {
            --cx;
        }
        if (fromNorth) {
            ++cz;
        }
        if (fromSouth) {
            --cz;
        }
        if (cx == 0 && cz == 0) {
            heading = RedstoneWireTurbo.computeHeading(upd1.xbias, upd1.zbias);
            for (int i = 0; i < 24; ++i) {
                UpdateNode nn = neighbor_nodes[i];
                if (nn == null) continue;
                nn.xbias = upd1.xbias;
                nn.zbias = upd1.zbias;
            }
        } else {
            if (cx != 0 && cz != 0) {
                if (upd1.xbias != 0) {
                    cz = 0;
                }
                if (upd1.zbias != 0) {
                    cx = 0;
                }
            }
            heading = RedstoneWireTurbo.computeHeading(cx, cz);
            for (int i = 0; i < 24; ++i) {
                UpdateNode nn = neighbor_nodes[i];
                if (nn == null) continue;
                nn.xbias = cx;
                nn.zbias = cz;
            }
        }
        RedstoneWireTurbo.orientNeighbors(neighbor_nodes, upd1.neighbor_nodes, heading);
    }

    private void propagateChanges(class_1937 worldIn, UpdateNode upd1, int layer) {
        if (upd1.neighbor_nodes == null) {
            this.findNeighbors(worldIn, upd1);
        }
        class_2338 pos = upd1.self;
        int x = pos.method_10263();
        int y = pos.method_10264();
        int z = pos.method_10260();
        int layer1 = layer + 1;
        for (int i = 0; i < 24; ++i) {
            UpdateNode upd2 = upd1.neighbor_nodes[i];
            if (upd2 == null || layer1 <= upd2.layer) continue;
            upd2.layer = layer1;
            this.updateQueue1.add(upd2);
            upd2.parent = pos;
        }
        int layer2 = layer + 2;
        for (int i = 0; i < 4; ++i) {
            UpdateNode upd2 = upd1.neighbor_nodes[i];
            if (upd2 == null || layer2 <= upd2.layer) continue;
            upd2.layer = layer2;
            this.updateQueue2.add(upd2);
            upd2.parent = pos;
        }
    }

    private void shiftQueue() {
        List<UpdateNode> t = this.updateQueue0;
        t.clear();
        this.updateQueue0 = this.updateQueue1;
        this.updateQueue1 = this.updateQueue2;
        this.updateQueue2 = t;
    }

    private void breadthFirstWalk(class_1937 worldIn) {
        this.shiftQueue();
        this.currentWalkLayer = 1;
        while (this.updateQueue0.size() > 0 || this.updateQueue1.size() > 0) {
            List<UpdateNode> thisLayer = this.updateQueue0;
            for (UpdateNode upd : thisLayer) {
                if (upd.type == UpdateNode.Type.REDSTONE) {
                    this.updateNode(worldIn, upd, this.currentWalkLayer);
                    continue;
                }
                worldIn.method_8320(upd.self).method_26181(worldIn, upd.self, (class_2248)this.wire, upd.parent, false);
            }
            this.shiftQueue();
            ++this.currentWalkLayer;
        }
        this.currentWalkLayer = 0;
    }

    private class_2680 scheduleReentrantNeighborChanged(class_1937 worldIn, class_2338 pos, class_2680 newState, class_2338 source) {
        UpdateNode upd;
        UpdateNode src;
        if (source != null && (src = this.nodeCache.get(source)) == null) {
            src = new UpdateNode();
            src.self = source;
            src.parent = source;
            src.visited = true;
            this.identifyNode(worldIn, src);
            this.nodeCache.put(source, src);
        }
        if ((upd = this.nodeCache.get(pos)) == null) {
            upd = new UpdateNode();
            upd.self = pos;
            upd.parent = pos;
            upd.visited = true;
            this.identifyNode(worldIn, upd);
            this.nodeCache.put(pos, upd);
        }
        upd.currentState = newState;
        if (upd.neighbor_nodes != null) {
            for (int i = 0; i < 24; ++i) {
                UpdateNode upd2 = upd.neighbor_nodes[i];
                if (upd2 == null) continue;
                upd2.type = UpdateNode.Type.UNKNOWN;
                upd2.currentState = null;
                this.identifyNode(worldIn, upd2);
            }
        }
        this.propagateChanges(worldIn, upd, this.currentWalkLayer);
        return newState;
    }

    public class_2680 updateSurroundingRedstone(class_1937 worldIn, class_2338 pos, class_2680 state, class_2338 source) {
        class_2680 newState = ((RedstoneWireBlockInterface)this.wire).updateLogicPublic(worldIn, pos, state);
        if (newState == state) {
            return state;
        }
        if (this.currentWalkLayer > 0 || this.nodeCache.size() > 0) {
            return this.scheduleReentrantNeighborChanged(worldIn, pos, newState, source);
        }
        if (source != null) {
            UpdateNode src = new UpdateNode();
            src.self = source;
            src.parent = source;
            src.visited = true;
            this.nodeCache.put(source, src);
            this.identifyNode(worldIn, src);
        }
        UpdateNode upd = new UpdateNode();
        upd.self = pos;
        upd.parent = source != null ? source : pos;
        upd.currentState = newState;
        upd.type = UpdateNode.Type.REDSTONE;
        upd.visited = true;
        this.nodeCache.put(pos, upd);
        this.propagateChanges(worldIn, upd, 0);
        this.breadthFirstWalk(worldIn);
        this.nodeCache.clear();
        return newState;
    }

    private class_2680 calculateCurrentChanges(class_1937 worldIn, UpdateNode upd) {
        class_2680 state = upd.currentState;
        int i = (Integer)state.method_11654((class_2769)class_2457.field_11432);
        int j = 0;
        j = RedstoneWireTurbo.getMaxCurrentStrength(upd, j);
        int l = 0;
        ((RedstoneWireBlockInterface)this.wire).setWiresGivePower(false);
        int k = worldIn.method_8482(upd.self);
        ((RedstoneWireBlockInterface)this.wire).setWiresGivePower(true);
        if (k < 15) {
            if (upd.neighbor_nodes == null) {
                this.findNeighbors(worldIn, upd);
            }
            UpdateNode center_up = upd.neighbor_nodes[1];
            boolean center_up_is_cube = center_up.currentState.method_26212((class_1922)worldIn, center_up.self);
            for (int m = 0; m < 4; ++m) {
                int n = rs_neighbors[m];
                UpdateNode neighbor = upd.neighbor_nodes[n];
                l = RedstoneWireTurbo.getMaxCurrentStrength(neighbor, l);
                boolean neighbor_is_cube = neighbor.currentState.method_26212((class_1922)worldIn, neighbor.self);
                if (!neighbor_is_cube) {
                    UpdateNode neighbor_down = upd.neighbor_nodes[rs_neighbors_dn[m]];
                    l = RedstoneWireTurbo.getMaxCurrentStrength(neighbor_down, l);
                    continue;
                }
                if (center_up_is_cube) continue;
                UpdateNode neighbor_up = upd.neighbor_nodes[rs_neighbors_up[m]];
                l = RedstoneWireTurbo.getMaxCurrentStrength(neighbor_up, l);
            }
        }
        if (k > (j = l - 1)) {
            j = k;
        }
        if (i != j) {
            state = (class_2680)state.method_11657((class_2769)class_2457.field_11432, (Comparable)Integer.valueOf(j));
            if (worldIn.method_8320(upd.self).method_26204() == class_2246.field_10091 && worldIn.method_8652(upd.self, state, 18)) {
                this.updateNeighborShapes(worldIn, upd.self, state);
            }
        }
        return state;
    }

    public void updateNeighborShapes(class_1937 level, class_2338 pos, class_2680 state) {
        for (class_2350 dir : class_2248.field_23157) {
            class_2338 neighborPos = pos.method_10093(dir);
            class_2680 neighborState = level.method_8320(neighborPos);
            class_2680 newState = neighborState.method_26191(dir.method_10153(), state, (class_1936)level, neighborPos, pos);
            class_2248.method_30094((class_2680)neighborState, (class_2680)newState, (class_1936)level, (class_2338)neighborPos, (int)2);
        }
    }

    private static int getMaxCurrentStrength(UpdateNode upd, int strength) {
        if (upd.type != UpdateNode.Type.REDSTONE) {
            return strength;
        }
        int i = (Integer)upd.currentState.method_11654((class_2769)class_2457.field_11432);
        return i > strength ? i : strength;
    }

    private static class UpdateNode {
        class_2680 currentState;
        UpdateNode[] neighbor_nodes;
        class_2338 self;
        class_2338 parent;
        Type type = Type.UNKNOWN;
        int layer;
        boolean visited;
        int xbias;
        int zbias;

        private UpdateNode() {
        }

        public static enum Type {
            UNKNOWN,
            REDSTONE,
            OTHER;

        }
    }
}

