/*
 * Decompiled with CFR 0.152.
 */
package carpet.commands;

import carpet.CarpetServer;
import carpet.CarpetSettings;
import carpet.script.CarpetEventServer;
import carpet.script.CarpetExpression;
import carpet.script.CarpetScriptHost;
import carpet.script.CarpetScriptServer;
import carpet.script.Expression;
import carpet.script.LazyValue;
import carpet.script.ScriptHost;
import carpet.script.Tokenizer;
import carpet.script.exception.CarpetExpressionException;
import carpet.script.utils.AppStoreManager;
import carpet.script.value.FunctionValue;
import carpet.script.value.Value;
import carpet.settings.SettingsManager;
import carpet.utils.CarpetProfiler;
import carpet.utils.Messenger;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2247;
import net.minecraft.class_2248;
import net.minecraft.class_2252;
import net.minecraft.class_2257;
import net.minecraft.class_2262;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2586;
import net.minecraft.class_2694;
import net.minecraft.class_3218;
import net.minecraft.class_3341;
import net.minecraft.class_3829;
import net.minecraft.class_4538;
import net.minecraft.class_7157;
import org.apache.commons.lang3.StringUtils;

public class ScriptCommand {
    private static final TreeSet<String> scarpetFunctions;
    private static final TreeSet<String> APIFunctions;

    public static List<String> suggestFunctions(ScriptHost host, String previous, String prefix) {
        int quoteCount = StringUtils.countMatches((CharSequence)(previous = previous.replace("\\'", "")), (char)'\'');
        if (quoteCount % 2 == 1) {
            return Collections.emptyList();
        }
        int maxLen = prefix.length() < 3 ? prefix.length() * 2 + 1 : 1234;
        String eventPrefix = prefix.startsWith("__on_") ? prefix.substring(5) : null;
        List<String> scarpetMatches = scarpetFunctions.stream().filter(s -> s.startsWith(prefix) && s.length() <= maxLen).map(s -> s + "(").collect(Collectors.toList());
        scarpetMatches.addAll(APIFunctions.stream().filter(s -> s.startsWith(prefix) && s.length() <= maxLen).map(s -> s + "(").collect(Collectors.toList()));
        if (eventPrefix != null) {
            scarpetMatches.addAll(CarpetEventServer.Event.publicEvents(null).stream().filter(e -> e.name.startsWith(eventPrefix)).map(s -> "__on_" + s.name + "(").collect(Collectors.toList()));
        }
        scarpetMatches.addAll(host.globalFunctionNames(host.main, s -> s.startsWith(prefix)).map(s -> s + "(").collect(Collectors.toList()));
        scarpetMatches.addAll(host.globalVariableNames(host.main, s -> s.startsWith(prefix)).collect(Collectors.toList()));
        return scarpetMatches;
    }

    private static CompletableFuture<Suggestions> suggestCode(CommandContext<class_2168> context, SuggestionsBuilder suggestionsBuilder) throws CommandSyntaxException {
        char ch;
        CarpetScriptHost currentHost = ScriptCommand.getHost(context);
        String previous = suggestionsBuilder.getRemaining().toLowerCase(Locale.ROOT);
        int strlen = previous.length();
        StringBuilder lastToken = new StringBuilder();
        for (int idx = strlen - 1; idx >= 0 && (Character.isLetterOrDigit(ch = previous.charAt(idx)) || ch == '_'); --idx) {
            lastToken.append(ch);
        }
        if (lastToken.length() == 0) {
            return suggestionsBuilder.buildFuture();
        }
        String prefix = lastToken.reverse().toString();
        String previousString = previous.substring(0, previous.length() - prefix.length());
        ScriptCommand.suggestFunctions(currentHost, previousString, prefix).forEach(text -> suggestionsBuilder.suggest(previousString + text));
        return suggestionsBuilder.buildFuture();
    }

    private static CompletableFuture<Suggestions> suggestDownloadableApps(CommandContext<class_2168> context, SuggestionsBuilder suggestionsBuilder) throws CommandSyntaxException {
        return CompletableFuture.supplyAsync(() -> {
            String previous = suggestionsBuilder.getRemaining();
            try {
                AppStoreManager.suggestionsFromPath(previous).forEach(arg_0 -> ((SuggestionsBuilder)suggestionsBuilder).suggest(arg_0));
            }
            catch (IOException e) {
                CarpetSettings.LOG.warn("Exception when fetching app store structure", (Throwable)e);
            }
            return suggestionsBuilder.build();
        });
    }

    public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 commandBuildContext) {
        LiteralArgumentBuilder b = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"globals").executes(context -> ScriptCommand.listGlobals((CommandContext<class_2168>)context, false))).then(class_2170.method_9247((String)"all").executes(context -> ScriptCommand.listGlobals((CommandContext<class_2168>)context, true)));
        LiteralArgumentBuilder o = (LiteralArgumentBuilder)class_2170.method_9247((String)"stop").executes(cc -> {
            CarpetServer.scriptServer.stopAll = true;
            return 1;
        });
        LiteralArgumentBuilder u = (LiteralArgumentBuilder)class_2170.method_9247((String)"resume").executes(cc -> {
            CarpetServer.scriptServer.stopAll = false;
            return 1;
        });
        LiteralArgumentBuilder l = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"run").requires(player -> SettingsManager.canUseCommand(player, CarpetSettings.commandScriptACE))).then(class_2170.method_9244((String)"expr", (ArgumentType)StringArgumentType.greedyString()).suggests(ScriptCommand::suggestCode).executes(cc -> ScriptCommand.compute((CommandContext<class_2168>)cc, StringArgumentType.getString((CommandContext)cc, (String)"expr"))));
        LiteralArgumentBuilder s = (LiteralArgumentBuilder)class_2170.method_9247((String)"invoke").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"call", (ArgumentType)StringArgumentType.word()).suggests((cc, bb) -> class_2172.method_9265(ScriptCommand.suggestFunctionCalls((CommandContext<class_2168>)cc), (SuggestionsBuilder)bb)).executes(cc -> ScriptCommand.invoke((CommandContext<class_2168>)cc, StringArgumentType.getString((CommandContext)cc, (String)"call"), null, null, ""))).then(class_2170.method_9244((String)"arguments", (ArgumentType)StringArgumentType.greedyString()).executes(cc -> ScriptCommand.invoke((CommandContext<class_2168>)cc, StringArgumentType.getString((CommandContext)cc, (String)"call"), null, null, StringArgumentType.getString((CommandContext)cc, (String)"arguments")))));
        LiteralArgumentBuilder c = (LiteralArgumentBuilder)class_2170.method_9247((String)"invokepoint").then(class_2170.method_9244((String)"call", (ArgumentType)StringArgumentType.word()).suggests((cc, bb) -> class_2172.method_9265(ScriptCommand.suggestFunctionCalls((CommandContext<class_2168>)cc), (SuggestionsBuilder)bb)).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"origin", (ArgumentType)class_2262.method_9698()).executes(cc -> ScriptCommand.invoke((CommandContext<class_2168>)cc, StringArgumentType.getString((CommandContext)cc, (String)"call"), class_2262.method_9697((CommandContext)cc, (String)"origin"), null, ""))).then(class_2170.method_9244((String)"arguments", (ArgumentType)StringArgumentType.greedyString()).executes(cc -> ScriptCommand.invoke((CommandContext<class_2168>)cc, StringArgumentType.getString((CommandContext)cc, (String)"call"), class_2262.method_9697((CommandContext)cc, (String)"origin"), null, StringArgumentType.getString((CommandContext)cc, (String)"arguments"))))));
        LiteralArgumentBuilder h = (LiteralArgumentBuilder)class_2170.method_9247((String)"invokearea").then(class_2170.method_9244((String)"call", (ArgumentType)StringArgumentType.word()).suggests((cc, bb) -> class_2172.method_9265(ScriptCommand.suggestFunctionCalls((CommandContext<class_2168>)cc), (SuggestionsBuilder)bb)).then(class_2170.method_9244((String)"from", (ArgumentType)class_2262.method_9698()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"to", (ArgumentType)class_2262.method_9698()).executes(cc -> ScriptCommand.invoke((CommandContext<class_2168>)cc, StringArgumentType.getString((CommandContext)cc, (String)"call"), class_2262.method_9697((CommandContext)cc, (String)"from"), class_2262.method_9697((CommandContext)cc, (String)"to"), ""))).then(class_2170.method_9244((String)"arguments", (ArgumentType)StringArgumentType.greedyString()).executes(cc -> ScriptCommand.invoke((CommandContext<class_2168>)cc, StringArgumentType.getString((CommandContext)cc, (String)"call"), class_2262.method_9697((CommandContext)cc, (String)"from"), class_2262.method_9697((CommandContext)cc, (String)"to"), StringArgumentType.getString((CommandContext)cc, (String)"arguments")))))));
        LiteralArgumentBuilder i = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"scan").requires(player -> player.method_9259(2))).then(class_2170.method_9244((String)"origin", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"from", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"to", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"expr", (ArgumentType)StringArgumentType.greedyString()).suggests(ScriptCommand::suggestCode).executes(cc -> ScriptCommand.scriptScan((CommandContext<class_2168>)cc, class_2262.method_9697((CommandContext)cc, (String)"origin"), class_2262.method_9697((CommandContext)cc, (String)"from"), class_2262.method_9697((CommandContext)cc, (String)"to"), StringArgumentType.getString((CommandContext)cc, (String)"expr")))))));
        LiteralArgumentBuilder e = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"fill").requires(player -> player.method_9259(2))).then(class_2170.method_9244((String)"origin", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"from", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"to", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"expr", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"block", (ArgumentType)class_2257.method_9653((class_7157)commandBuildContext)).executes(cc -> ScriptCommand.scriptFill((CommandContext<class_2168>)cc, class_2262.method_9697((CommandContext)cc, (String)"origin"), class_2262.method_9697((CommandContext)cc, (String)"from"), class_2262.method_9697((CommandContext)cc, (String)"to"), StringArgumentType.getString((CommandContext)cc, (String)"expr"), class_2257.method_9655((CommandContext)cc, (String)"block"), null, "solid"))).then(class_2170.method_9247((String)"replace").then(class_2170.method_9244((String)"filter", (ArgumentType)class_2252.method_9645((class_7157)commandBuildContext)).executes(cc -> ScriptCommand.scriptFill((CommandContext<class_2168>)cc, class_2262.method_9697((CommandContext)cc, (String)"origin"), class_2262.method_9697((CommandContext)cc, (String)"from"), class_2262.method_9697((CommandContext)cc, (String)"to"), StringArgumentType.getString((CommandContext)cc, (String)"expr"), class_2257.method_9655((CommandContext)cc, (String)"block"), class_2252.method_9644((CommandContext)cc, (String)"filter"), "solid")))))))));
        LiteralArgumentBuilder t = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"outline").requires(player -> player.method_9259(2))).then(class_2170.method_9244((String)"origin", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"from", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"to", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"expr", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"block", (ArgumentType)class_2257.method_9653((class_7157)commandBuildContext)).executes(cc -> ScriptCommand.scriptFill((CommandContext<class_2168>)cc, class_2262.method_9697((CommandContext)cc, (String)"origin"), class_2262.method_9697((CommandContext)cc, (String)"from"), class_2262.method_9697((CommandContext)cc, (String)"to"), StringArgumentType.getString((CommandContext)cc, (String)"expr"), class_2257.method_9655((CommandContext)cc, (String)"block"), null, "outline"))).then(class_2170.method_9247((String)"replace").then(class_2170.method_9244((String)"filter", (ArgumentType)class_2252.method_9645((class_7157)commandBuildContext)).executes(cc -> ScriptCommand.scriptFill((CommandContext<class_2168>)cc, class_2262.method_9697((CommandContext)cc, (String)"origin"), class_2262.method_9697((CommandContext)cc, (String)"from"), class_2262.method_9697((CommandContext)cc, (String)"to"), StringArgumentType.getString((CommandContext)cc, (String)"expr"), class_2257.method_9655((CommandContext)cc, (String)"block"), class_2252.method_9644((CommandContext)cc, (String)"filter"), "outline")))))))));
        LiteralArgumentBuilder a = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"load").requires(player -> SettingsManager.canUseCommand(player, CarpetSettings.commandScriptACE))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"app", (ArgumentType)StringArgumentType.word()).suggests((cc, bb) -> class_2172.method_9265(CarpetServer.scriptServer.listAvailableModules(true), (SuggestionsBuilder)bb)).executes(cc -> {
            boolean success = CarpetServer.scriptServer.addScriptHost((class_2168)cc.getSource(), StringArgumentType.getString((CommandContext)cc, (String)"app"), null, true, false, false, null);
            return success ? 1 : 0;
        })).then(class_2170.method_9247((String)"global").executes(cc -> {
            boolean success = CarpetServer.scriptServer.addScriptHost((class_2168)cc.getSource(), StringArgumentType.getString((CommandContext)cc, (String)"app"), null, false, false, false, null);
            return success ? 1 : 0;
        })));
        LiteralArgumentBuilder f = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"unload").requires(player -> SettingsManager.canUseCommand(player, CarpetSettings.commandScriptACE))).then(class_2170.method_9244((String)"app", (ArgumentType)StringArgumentType.word()).suggests((cc, bb) -> class_2172.method_9265(CarpetServer.scriptServer.unloadableModules, (SuggestionsBuilder)bb)).executes(cc -> {
            boolean success = CarpetServer.scriptServer.removeScriptHost((class_2168)cc.getSource(), StringArgumentType.getString((CommandContext)cc, (String)"app"), true, false);
            return success ? 1 : 0;
        }));
        LiteralArgumentBuilder q = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"event").requires(player -> SettingsManager.canUseCommand(player, CarpetSettings.commandScriptACE))).executes(cc -> ScriptCommand.listEvents((class_2168)cc.getSource()))).then(class_2170.method_9247((String)"add_to").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"event", (ArgumentType)StringArgumentType.word()).suggests((cc, bb) -> class_2172.method_9265((Iterable)CarpetEventServer.Event.publicEvents(CarpetServer.scriptServer).stream().map(ev -> ev.name).collect(Collectors.toList()), (SuggestionsBuilder)bb)).then(class_2170.method_9244((String)"call", (ArgumentType)StringArgumentType.word()).suggests((cc, bb) -> class_2172.method_9265(ScriptCommand.suggestFunctionCalls((CommandContext<class_2168>)cc), (SuggestionsBuilder)bb)).executes(cc -> CarpetServer.scriptServer.events.addEventFromCommand((class_2168)cc.getSource(), StringArgumentType.getString((CommandContext)cc, (String)"event"), null, StringArgumentType.getString((CommandContext)cc, (String)"call")) ? 1 : 0))).then(class_2170.method_9247((String)"from").then(class_2170.method_9244((String)"app", (ArgumentType)StringArgumentType.word()).suggests((cc, bb) -> class_2172.method_9265(CarpetServer.scriptServer.modules.keySet(), (SuggestionsBuilder)bb)).then(class_2170.method_9244((String)"call", (ArgumentType)StringArgumentType.word()).suggests((cc, bb) -> class_2172.method_9265(ScriptCommand.suggestFunctionCalls((CommandContext<class_2168>)cc), (SuggestionsBuilder)bb)).executes(cc -> CarpetServer.scriptServer.events.addEventFromCommand((class_2168)cc.getSource(), StringArgumentType.getString((CommandContext)cc, (String)"event"), StringArgumentType.getString((CommandContext)cc, (String)"app"), StringArgumentType.getString((CommandContext)cc, (String)"call")) ? 1 : 0))))))).then(class_2170.method_9247((String)"remove_from").then(class_2170.method_9244((String)"event", (ArgumentType)StringArgumentType.word()).suggests((cc, bb) -> class_2172.method_9265((Iterable)CarpetEventServer.Event.publicEvents(CarpetServer.scriptServer).stream().filter(CarpetEventServer.Event::isNeeded).map(ev -> ev.name).collect(Collectors.toList()), (SuggestionsBuilder)bb)).then(class_2170.method_9244((String)"call", (ArgumentType)StringArgumentType.greedyString()).suggests((cc, bb) -> class_2172.method_9264(CarpetEventServer.Event.getEvent((String)StringArgumentType.getString((CommandContext)cc, (String)"event"), (CarpetScriptServer)CarpetServer.scriptServer).handler.inspectCurrentCalls().stream().map(CarpetEventServer.Callback::toString), (SuggestionsBuilder)bb)).executes(cc -> CarpetServer.scriptServer.events.removeEventFromCommand((class_2168)cc.getSource(), StringArgumentType.getString((CommandContext)cc, (String)"event"), StringArgumentType.getString((CommandContext)cc, (String)"call")) ? 1 : 0))));
        LiteralArgumentBuilder d = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"download").requires(player -> SettingsManager.canUseCommand(player, CarpetSettings.commandScriptACE))).then(class_2170.method_9244((String)"path", (ArgumentType)StringArgumentType.greedyString()).suggests(ScriptCommand::suggestDownloadableApps).executes(cc -> AppStoreManager.downloadScript((class_2168)cc.getSource(), StringArgumentType.getString((CommandContext)cc, (String)"path"))));
        LiteralArgumentBuilder r = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(player -> SettingsManager.canUseCommand(player, CarpetSettings.commandScriptACE))).then(class_2170.method_9244((String)"app", (ArgumentType)StringArgumentType.word()).suggests((cc, bb) -> class_2172.method_9265(CarpetServer.scriptServer.unloadableModules, (SuggestionsBuilder)bb)).executes(cc -> {
            boolean success = CarpetServer.scriptServer.uninstallApp((class_2168)cc.getSource(), StringArgumentType.getString((CommandContext)cc, (String)"app"));
            return success ? 1 : 0;
        }));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"script").requires(player -> SettingsManager.canUseCommand(player, CarpetSettings.commandScript))).then((ArgumentBuilder)b)).then((ArgumentBuilder)u)).then((ArgumentBuilder)o)).then((ArgumentBuilder)l)).then((ArgumentBuilder)s)).then((ArgumentBuilder)c)).then((ArgumentBuilder)h)).then((ArgumentBuilder)i)).then((ArgumentBuilder)e)).then((ArgumentBuilder)t)).then((ArgumentBuilder)a)).then((ArgumentBuilder)f)).then((ArgumentBuilder)q)).then((ArgumentBuilder)d)).then((ArgumentBuilder)r));
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"script").requires(player -> SettingsManager.canUseCommand(player, CarpetSettings.commandScript))).then(class_2170.method_9247((String)"in").then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)class_2170.method_9244((String)"app", (ArgumentType)StringArgumentType.word()).suggests((cc, bb) -> class_2172.method_9265(CarpetServer.scriptServer.modules.keySet(), (SuggestionsBuilder)bb)).then((ArgumentBuilder)b)).then((ArgumentBuilder)u)).then((ArgumentBuilder)o)).then((ArgumentBuilder)l)).then((ArgumentBuilder)s)).then((ArgumentBuilder)c)).then((ArgumentBuilder)h)).then((ArgumentBuilder)i)).then((ArgumentBuilder)e)).then((ArgumentBuilder)t))));
    }

    private static CarpetScriptHost getHost(CommandContext<class_2168> context) throws CommandSyntaxException {
        CarpetScriptHost host;
        try {
            String name = StringArgumentType.getString(context, (String)"app").toLowerCase(Locale.ROOT);
            CarpetScriptHost parentHost = CarpetServer.scriptServer.modules.getOrDefault(name, CarpetServer.scriptServer.globalHost);
            host = parentHost.retrieveOwnForExecution((class_2168)context.getSource());
        }
        catch (IllegalArgumentException ignored) {
            host = CarpetServer.scriptServer.globalHost;
        }
        host.setChatErrorSnooper((class_2168)context.getSource());
        return host;
    }

    private static Collection<String> suggestFunctionCalls(CommandContext<class_2168> c) throws CommandSyntaxException {
        CarpetScriptHost host = ScriptCommand.getHost(c);
        return host.globalFunctionNames(host.main, s -> !s.startsWith("_")).sorted().collect(Collectors.toList());
    }

    private static int listEvents(class_2168 source) {
        Messenger.m(source, "w Lists ALL event handlers:");
        for (CarpetEventServer.Event event : CarpetEventServer.Event.getAllEvents(CarpetServer.scriptServer, null)) {
            boolean shownEvent = false;
            for (CarpetEventServer.Callback c : event.handler.inspectCurrentCalls()) {
                if (!shownEvent) {
                    Messenger.m(source, "w Handlers for " + event.name + ": ");
                    shownEvent = true;
                }
                Messenger.m(source, "w  - " + c.function.getString() + (String)(c.host == null ? "" : " (from " + c.host + ")"));
            }
        }
        return 1;
    }

    private static int listGlobals(CommandContext<class_2168> context, boolean all) throws CommandSyntaxException {
        CarpetScriptHost host = ScriptCommand.getHost(context);
        class_2168 source = (class_2168)context.getSource();
        Messenger.m(source, "lb Stored functions" + (String)(host == CarpetServer.scriptServer.globalHost ? ":" : " in " + host.getName() + ":"));
        host.globalFunctionNames(host.main, str -> all || !str.startsWith("__")).sorted().forEach(s -> {
            FunctionValue fun = host.getFunction((String)s);
            if (fun == null) {
                Messenger.m(source, "gb " + s, "g  - unused import");
                Messenger.m(source, "gi ----------------");
                return;
            }
            Expression expr = fun.getExpression();
            Tokenizer.Token tok = fun.getToken();
            List<String> snippet = expr.getExpressionSnippet(tok);
            Messenger.m(source, "wb " + fun.fullName(), "t  defined at: line " + (tok.lineno + 1) + " pos " + (tok.linepos + 1));
            for (String snippetLine : snippet) {
                Messenger.m(source, "w " + snippetLine);
            }
            Messenger.m(source, "gi ----------------");
        });
        Messenger.m(source, "w  ");
        Messenger.m(source, "lb Global variables" + (String)(host == CarpetServer.scriptServer.globalHost ? ":" : " in " + host.getName() + ":"));
        host.globalVariableNames(host.main, s -> s.startsWith("global_")).sorted().forEach(s -> {
            LazyValue variable = host.getGlobalVariable((String)s);
            if (variable == null) {
                Messenger.m(source, "gb " + s, "g  - unused import");
            } else {
                Messenger.m(source, "wb " + s + ": ", "w " + variable.evalValue(null).getPrettyString());
            }
        });
        return 1;
    }

    public static int handleCall(class_2168 source, CarpetScriptHost host, Supplier<Value> call) {
        try {
            CarpetProfiler.ProfilerToken currentSection = CarpetProfiler.start_section(null, "Scarpet run", CarpetProfiler.TYPE.GENERAL);
            host.setChatErrorSnooper(source);
            long start = System.nanoTime();
            Value result = call.get();
            long time = (System.nanoTime() - start) / 1000L;
            String metric = "\u00b5s";
            if (time > 5000L) {
                time /= 1000L;
                metric = "ms";
            }
            if (time > 10000L) {
                time /= 1000L;
                metric = "s";
            }
            Messenger.m(source, "wi  = ", "wb " + result.getString(), "gi  (" + time + metric + ")");
            int intres = (int)result.readInteger();
            CarpetProfiler.end_current_section(currentSection);
            return intres;
        }
        catch (CarpetExpressionException e) {
            host.handleErrorWithStack("Error while evaluating expression", e);
        }
        catch (ArithmeticException ae) {
            host.handleErrorWithStack("Math doesn't compute", ae);
        }
        catch (StackOverflowError soe) {
            host.handleErrorWithStack("Your thoughts are too deep", soe);
        }
        return 0;
    }

    private static int invoke(CommandContext<class_2168> context, String call, class_2338 pos1, class_2338 pos2, String args) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        CarpetScriptHost host = ScriptCommand.getHost(context);
        if (call.startsWith("__")) {
            Messenger.m(source, "r Hidden functions are only callable in scripts");
            return 0;
        }
        ArrayList<Integer> positions = new ArrayList<Integer>();
        if (pos1 != null) {
            positions.add(pos1.method_10263());
            positions.add(pos1.method_10264());
            positions.add(pos1.method_10260());
        }
        if (pos2 != null) {
            positions.add(pos2.method_10263());
            positions.add(pos2.method_10264());
            positions.add(pos2.method_10260());
        }
        return ScriptCommand.handleCall(source, host, () -> host.callLegacy(source, call, positions, args));
    }

    private static int compute(CommandContext<class_2168> context, String expr) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        CarpetScriptHost host = ScriptCommand.getHost(context);
        return ScriptCommand.handleCall(source, host, () -> {
            CarpetExpression ex = new CarpetExpression(host.main, expr, source, new class_2338(0, 0, 0));
            return ex.scriptRunCommand(host, new class_2338(source.method_9222()));
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int scriptScan(CommandContext<class_2168> context, class_2338 origin, class_2338 a, class_2338 b, String expr) throws CommandSyntaxException {
        class_2168 source = (class_2168)context.getSource();
        CarpetScriptHost host = ScriptCommand.getHost(context);
        class_3341 area = class_3341.method_34390((class_2382)a, (class_2382)b);
        CarpetExpression cexpr = new CarpetExpression(host.main, expr, source, origin);
        int int_1 = area.method_35414() * area.method_14660() * area.method_14663();
        if (int_1 > CarpetSettings.fillLimit) {
            Messenger.m(source, "r too many blocks to evaluate: " + int_1);
            return 1;
        }
        int successCount = 0;
        CarpetSettings.impendingFillSkipUpdates.set(!CarpetSettings.fillUpdates);
        try {
            for (int x = area.method_35415(); x <= area.method_35418(); ++x) {
                for (int y = area.method_35416(); y <= area.method_35419(); ++y) {
                    for (int z = area.method_35417(); z <= area.method_35420(); ++z) {
                        try {
                            if (!cexpr.fillAndScanCommand(host, x, y, z)) continue;
                            ++successCount;
                            continue;
                        }
                        catch (ArithmeticException arithmeticException) {
                            // empty catch block
                        }
                    }
                }
            }
        }
        catch (CarpetExpressionException exc) {
            host.handleErrorWithStack("Error while processing command", exc);
            int n = 0;
            return n;
        }
        finally {
            CarpetSettings.impendingFillSkipUpdates.set(false);
        }
        Messenger.m(source, "w Expression successful in " + successCount + " out of " + int_1 + " blocks");
        return successCount;
    }

    private static int scriptFill(CommandContext<class_2168> context, class_2338 origin, class_2338 a, class_2338 b, String expr, class_2247 block, Predicate<class_2694> replacement, String mode) throws CommandSyntaxException {
        int z;
        int y;
        int x;
        class_2168 source = (class_2168)context.getSource();
        CarpetScriptHost host = ScriptCommand.getHost(context);
        class_3341 area = class_3341.method_34390((class_2382)a, (class_2382)b);
        CarpetExpression cexpr = new CarpetExpression(host.main, expr, source, origin);
        int int_1 = area.method_35414() * area.method_14660() * area.method_14663();
        if (int_1 > CarpetSettings.fillLimit) {
            Messenger.m(source, "r too many blocks to evaluate: " + int_1);
            return 1;
        }
        boolean[][][] volume = new boolean[area.method_35414()][area.method_14660()][area.method_14663()];
        class_2338.class_2339 mbpos = origin.method_25503();
        class_3218 world = source.method_9225();
        for (int x2 = area.method_35415(); x2 <= area.method_35418(); ++x2) {
            for (int y2 = area.method_35416(); y2 <= area.method_35419(); ++y2) {
                for (int z2 = area.method_35417(); z2 <= area.method_35420(); ++z2) {
                    try {
                        if (!cexpr.fillAndScanCommand(host, x2, y2, z2)) continue;
                        volume[x2 - area.method_35415()][y2 - area.method_35416()][z2 - area.method_35417()] = true;
                        continue;
                    }
                    catch (CarpetExpressionException e) {
                        host.handleErrorWithStack("Exception while filling the area", e);
                        return 0;
                    }
                    catch (ArithmeticException e) {
                        // empty catch block
                    }
                }
            }
        }
        int maxx = area.method_35414() - 1;
        int maxy = area.method_14660() - 1;
        int maxz = area.method_14663() - 1;
        if ("outline".equalsIgnoreCase(mode)) {
            boolean[][][] newVolume = new boolean[area.method_35414()][area.method_14660()][area.method_14663()];
            for (x = 0; x <= maxx; ++x) {
                for (y = 0; y <= maxy; ++y) {
                    for (z = 0; z <= maxz; ++z) {
                        if (!volume[x][y][z] || !(x != 0 && !volume[x - 1][y][z] || x != maxx && !volume[x + 1][y][z] || y != 0 && !volume[x][y - 1][z] || y != maxy && !volume[x][y + 1][z] || z != 0 && !volume[x][y][z - 1]) && (z == maxz || volume[x][y][z + 1])) continue;
                        newVolume[x][y][z] = true;
                    }
                }
            }
            volume = newVolume;
        }
        int affected = 0;
        CarpetSettings.impendingFillSkipUpdates.set(!CarpetSettings.fillUpdates);
        for (x = 0; x <= maxx; ++x) {
            for (y = 0; y <= maxy; ++y) {
                for (z = 0; z <= maxz; ++z) {
                    if (!volume[x][y][z]) continue;
                    mbpos.method_10103(x + area.method_35415(), y + area.method_35416(), z + area.method_35417());
                    if (replacement != null && !replacement.test(new class_2694((class_4538)world, (class_2338)mbpos, true))) continue;
                    class_2586 tileentity = world.method_8321((class_2338)mbpos);
                    class_3829.method_16825((Object)tileentity);
                    if (!block.method_9495(world, (class_2338)mbpos, 2)) continue;
                    ++affected;
                }
            }
        }
        CarpetSettings.impendingFillSkipUpdates.set(false);
        if (CarpetSettings.fillUpdates && block != null) {
            for (x = 0; x <= maxx; ++x) {
                for (y = 0; y <= maxy; ++y) {
                    for (z = 0; z <= maxz; ++z) {
                        if (!volume[x][y][z]) continue;
                        mbpos.method_10103(x + area.method_35415(), y + area.method_35416(), z + area.method_35417());
                        class_2248 blokc = world.method_8320((class_2338)mbpos).method_26204();
                        world.method_8408((class_2338)mbpos, blokc);
                    }
                }
            }
        }
        Messenger.m(source, "gi Affected " + affected + " blocks in " + area.method_35414() * area.method_14660() * area.method_14663() + " block volume");
        return 1;
    }

    static {
        Set<String> allFunctions = new CarpetExpression(null, "null", null, null).getExpr().getFunctionNames();
        scarpetFunctions = new TreeSet<String>(Expression.none.getFunctionNames());
        APIFunctions = allFunctions.stream().filter(s -> !scarpetFunctions.contains(s)).collect(Collectors.toCollection(TreeSet::new));
    }
}

