/*
 * Decompiled with CFR 0.152.
 */
package com.jaquadro.minecraft.storagedrawers.item;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.jaquadro.minecraft.storagedrawers.api.storage.EmptyDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributes;
import com.jaquadro.minecraft.storagedrawers.api.storage.IDrawerAttributesModifiable;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;

public class ItemKey
extends Item {
    public static Capability<IDrawerAttributes> DRAWER_ATTRIBUTES_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IDrawerAttributes>(){});
    private final Multimap<Attribute, AttributeModifier> modifiers;

    public ItemKey(Item.Properties properties) {
        super(properties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", 2.0, AttributeModifier.Operation.ADDITION));
        this.modifiers = builder.build();
    }

    public boolean m_6777_(BlockState state, Level worldIn, BlockPos pos, Player player) {
        return !player.m_7500_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7373_(ItemStack stack, @Nullable Level worldIn, List<Component> tooltip, TooltipFlag flagIn) {
        super.m_7373_(stack, worldIn, tooltip, flagIn);
        tooltip.add((Component)new TextComponent("").m_7220_(this.m_41466_()).m_130940_(ChatFormatting.GRAY));
    }

    @OnlyIn(value=Dist.CLIENT)
    public Component m_41466_() {
        return new TranslatableComponent(this.m_5524_() + ".desc");
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        return slot == EquipmentSlot.MAINHAND ? this.modifiers : super.getAttributeModifiers(slot, stack);
    }

    public InteractionResult m_6225_(UseOnContext context) {
        BlockEntity tile = context.m_43725_().m_7702_(context.m_8083_());
        if (tile == null) {
            return InteractionResult.PASS;
        }
        IDrawerAttributes attrs = (IDrawerAttributes)tile.getCapability(DRAWER_ATTRIBUTES_CAPABILITY, null).orElse((Object)EmptyDrawerAttributes.EMPTY);
        if (!(attrs instanceof IDrawerAttributesModifiable)) {
            return InteractionResult.PASS;
        }
        this.handleDrawerAttributes((IDrawerAttributesModifiable)attrs);
        return InteractionResult.SUCCESS;
    }

    protected void handleDrawerAttributes(IDrawerAttributesModifiable attrs) {
    }
}

