/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedbackpacksvh.data;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.p3pp3rf1y.sophisticatedbackpacks.api.CapabilityBackpackWrapper;
import net.p3pp3rf1y.sophisticatedbackpacks.backpack.BackpackStorage;

public class SnapshotStorage
extends SavedData {
    private final Map<UUID, CompoundTag> backpackSnapshots = new HashMap<UUID, CompoundTag>();
    private static final SnapshotStorage emptySnapshotStorage = new SnapshotStorage();

    public static SnapshotStorage get() {
        MinecraftServer server;
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            ServerLevel overworld = server.m_129880_(Level.f_46428_);
            DimensionDataStorage storage = overworld.m_8895_();
            return (SnapshotStorage)storage.m_164861_(SnapshotStorage::load, SnapshotStorage::new, "sbsnapshots");
        }
        return emptySnapshotStorage;
    }

    public void createSnapshot(ItemStack backpack) {
        backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(backpackWrapper -> backpackWrapper.getContentsUuid().ifPresent(backpackUuid -> {
            this.backpackSnapshots.put((UUID)backpackUuid, BackpackStorage.get().getOrCreateBackpackContents(backpackUuid).m_6426_());
            this.m_77762_();
        }));
    }

    public void restoreContentsFromSnapshot(ItemStack backpack) {
        backpack.getCapability(CapabilityBackpackWrapper.getCapabilityInstance()).ifPresent(backpackWrapper -> {
            backpackWrapper.getContentsUuid().ifPresent(backpackUuid -> {
                if (this.backpackSnapshots.containsKey(backpackUuid)) {
                    BackpackStorage.get().setBackpackContents(backpackUuid, this.backpackSnapshots.get(backpackUuid).m_6426_());
                }
            });
            backpackWrapper.onContentsNbtUpdated();
        });
    }

    public static SnapshotStorage load(CompoundTag nbt) {
        SnapshotStorage storage = new SnapshotStorage();
        SnapshotStorage.readSnapshotContents(nbt, storage);
        return storage;
    }

    private static void readSnapshotContents(CompoundTag nbt, SnapshotStorage storage) {
        for (Tag n : nbt.m_128437_("backpackSnapshots", 10)) {
            CompoundTag uuidContentsPair = (CompoundTag)n;
            UUID uuid = NbtUtils.m_129233_((Tag)Objects.requireNonNull(uuidContentsPair.m_128423_("uuid")));
            CompoundTag contents = uuidContentsPair.m_128469_("contents");
            storage.backpackSnapshots.put(uuid, contents);
        }
    }

    public CompoundTag m_7176_(CompoundTag compoundTag) {
        CompoundTag ret = new CompoundTag();
        this.writeSnapshotContents(ret);
        return ret;
    }

    private void writeSnapshotContents(CompoundTag ret) {
        ListTag backpackContentsNbt = new ListTag();
        for (Map.Entry<UUID, CompoundTag> entry : this.backpackSnapshots.entrySet()) {
            CompoundTag uuidContentsPair = new CompoundTag();
            uuidContentsPair.m_128365_("uuid", (Tag)NbtUtils.m_129226_((UUID)entry.getKey()));
            uuidContentsPair.m_128365_("contents", (Tag)entry.getValue());
            backpackContentsNbt.add((Object)uuidContentsPair);
        }
        ret.m_128365_("backpackSnapshots", (Tag)backpackContentsNbt);
    }
}

