/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.helpers;

import cofh.lib.item.IAugmentableItem;
import cofh.lib.util.helpers.MathHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;

public class AugmentableHelper {
    private AugmentableHelper() {
    }

    public static boolean isAugmentableItem(ItemStack stack) {
        return !stack.m_41619_() && stack.m_41720_() instanceof IAugmentableItem;
    }

    public static List<ItemStack> readAugmentsFromItem(ItemStack stack) {
        ListTag augmentTag = AugmentableHelper.getAugmentNBT(stack);
        if (augmentTag.isEmpty()) {
            return Collections.emptyList();
        }
        return AugmentableHelper.getAugments(augmentTag);
    }

    public static void writeAugmentsToItem(ItemStack stack, List<ItemStack> augments) {
        AugmentableHelper.writeAugmentsToItem(stack, AugmentableHelper.convertAugments(augments));
    }

    public static List<ItemStack> getAugments(ItemStack augmentable) {
        return !AugmentableHelper.isAugmentableItem(augmentable) ? Collections.emptyList() : ((IAugmentableItem)augmentable.m_41720_()).getAugments(augmentable);
    }

    public static int getAugmentSlots(ItemStack augmentable) {
        return !AugmentableHelper.isAugmentableItem(augmentable) ? 0 : MathHelper.clamp(((IAugmentableItem)augmentable.m_41720_()).getAugmentSlots(augmentable), 0, 9);
    }

    public static boolean validAugment(ItemStack augmentable, ItemStack augment, List<ItemStack> augments) {
        return AugmentableHelper.isAugmentableItem(augmentable) && ((IAugmentableItem)augmentable.m_41720_()).validAugment(augmentable, augment, augments);
    }

    public static void setAugments(ItemStack stack, List<ItemStack> augments) {
        if (!AugmentableHelper.isAugmentableItem(stack)) {
            return;
        }
        ((IAugmentableItem)stack.m_41720_()).setAugments(stack, augments);
    }

    public static void setAttribute(CompoundTag subTag, String attribute, float value) {
        subTag.m_128350_(attribute, value);
    }

    public static void setAttributeFromAugmentMax(CompoundTag subTag, CompoundTag augmentData, String attribute) {
        float mod = Math.max(AugmentableHelper.getAttributeMod(augmentData, attribute), AugmentableHelper.getAttributeMod(subTag, attribute));
        if (mod > 0.0f) {
            subTag.m_128350_(attribute, mod);
        }
    }

    public static void setAttributeFromAugmentAdd(CompoundTag subTag, CompoundTag augmentData, String attribute) {
        float mod = AugmentableHelper.getAttributeMod(augmentData, attribute) + AugmentableHelper.getAttributeMod(subTag, attribute);
        subTag.m_128350_(attribute, mod);
    }

    public static void setAttributeFromAugmentString(CompoundTag subTag, CompoundTag augmentData, String attribute) {
        String mod = AugmentableHelper.getAttributeModString(augmentData, attribute);
        if (!mod.isEmpty()) {
            subTag.m_128359_(attribute, mod);
        }
    }

    public static float getAttributeMod(CompoundTag augmentData, String key) {
        return augmentData.m_128457_(key);
    }

    public static String getAttributeModString(CompoundTag augmentData, String key) {
        return augmentData.m_128461_(key);
    }

    public static float getAttributeModWithDefault(CompoundTag augmentData, String key, float defaultValue) {
        return augmentData.m_128441_(key) ? augmentData.m_128457_(key) : defaultValue;
    }

    public static String getAttributeModWithDefault(CompoundTag augmentData, String key, String defaultValue) {
        return augmentData.m_128441_(key) ? augmentData.m_128461_(key) : defaultValue;
    }

    public static float getPropertyWithDefault(ItemStack container, String key, float defaultValue) {
        CompoundTag subTag = container.m_41737_("Properties");
        return subTag == null ? defaultValue : AugmentableHelper.getAttributeModWithDefault(subTag, key, defaultValue);
    }

    public static String getPropertyWithDefault(ItemStack container, String key, String defaultValue) {
        CompoundTag subTag = container.m_41737_("Properties");
        return subTag == null ? defaultValue : AugmentableHelper.getAttributeModWithDefault(subTag, key, defaultValue);
    }

    private static void writeAugmentsToItem(ItemStack stack, ListTag list) {
        CompoundTag nbt = stack.m_41737_("BlockEntityTag");
        if (nbt != null) {
            nbt.m_128365_("Augments", (Tag)list);
            return;
        }
        if (stack.m_41720_() instanceof BlockItem) {
            nbt = new CompoundTag();
            nbt.m_128365_("Augments", (Tag)list);
            stack.m_41700_("BlockEntityTag", (Tag)nbt);
            return;
        }
        stack.m_41700_("Augments", (Tag)list);
    }

    private static List<ItemStack> getAugments(ListTag list) {
        ArrayList ret = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            ret.add(ItemStack.m_41712_((CompoundTag)list.m_128728_(i)));
        }
        return ret.isEmpty() ? Collections.emptyList() : ret;
    }

    private static ListTag getAugmentNBT(ItemStack stack) {
        if (stack.m_41783_() == null) {
            return new ListTag();
        }
        CompoundTag nbt = stack.m_41737_("BlockEntityTag");
        if (nbt != null) {
            return nbt.m_128441_("Augments") ? nbt.m_128437_("Augments", 10) : new ListTag();
        }
        return stack.m_41783_().m_128437_("Augments", 10);
    }

    private static ListTag convertAugments(List<ItemStack> augments) {
        ListTag list = new ListTag();
        for (ItemStack augment : augments) {
            list.add((Object)augment.m_41739_(new CompoundTag()));
        }
        return list;
    }
}

