/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.util.control;

import cofh.lib.util.SocialUtils;
import cofh.lib.util.helpers.SecurityHelper;
import com.mojang.authlib.GameProfile;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.scores.Team;

public interface ISecurable {
    public AccessMode getAccess();

    public GameProfile getOwner();

    public void setAccess(AccessMode var1);

    public boolean setOwner(GameProfile var1);

    default public String getOwnerName() {
        return this.getOwner().getName();
    }

    default public boolean canAccess(Entity entity) {
        return this.getAccess().matches(this.getOwner(), entity);
    }

    default public boolean isSecurable() {
        return true;
    }

    default public boolean hasSecurity() {
        return !SecurityHelper.isDefaultProfile(this.getOwner());
    }

    public static enum AccessMode {
        PUBLIC,
        PRIVATE,
        FRIENDS,
        TEAM;

        public static final AccessMode[] VALUES;

        public boolean matches(GameProfile owner, Entity entity) {
            UUID ownerID = owner.getId();
            if (SecurityHelper.isDefaultUUID(ownerID)) {
                return true;
            }
            UUID otherID = SecurityHelper.getID(entity);
            switch (this) {
                case PRIVATE: {
                    return ownerID.equals(otherID);
                }
                case FRIENDS: {
                    ServerPlayer player;
                    return ownerID.equals(otherID) || entity instanceof ServerPlayer && SocialUtils.isFriendOrSelf(owner, player = (ServerPlayer)entity);
                }
                case TEAM: {
                    if (ownerID.equals(otherID)) {
                        return true;
                    }
                    Team team = entity.m_5647_();
                    if (team == null) {
                        return false;
                    }
                    return team.m_6809_().contains(owner.getName());
                }
            }
            return true;
        }

        public boolean isPublic() {
            return this == PUBLIC;
        }

        public boolean isPrivate() {
            return this == PRIVATE;
        }

        public boolean isTeamOnly() {
            return this == TEAM;
        }

        public boolean isFriendsOnly() {
            return this == FRIENDS;
        }

        static {
            VALUES = AccessMode.values();
        }
    }
}

