/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.inventory;

import cofh.lib.inventory.ItemStorageCoFH;
import cofh.lib.inventory.ManagedItemHandler;
import cofh.lib.inventory.SimpleItemHandler;
import cofh.lib.inventory.SimpleItemInv;
import cofh.lib.util.IInventoryCallback;
import cofh.lib.util.StorageGroup;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.EmptyHandler;

public class ManagedItemInv
extends SimpleItemInv {
    protected List<ItemStorageCoFH> inputSlots = new ArrayList<ItemStorageCoFH>();
    protected List<ItemStorageCoFH> catalystSlots = new ArrayList<ItemStorageCoFH>();
    protected List<ItemStorageCoFH> outputSlots = new ArrayList<ItemStorageCoFH>();
    protected List<ItemStorageCoFH> internalSlots = new ArrayList<ItemStorageCoFH>();
    protected IItemHandler inputHandler;
    protected IItemHandler outputHandler;
    protected IItemHandler ioHandler;
    protected IItemHandler accessibleHandler;
    protected IItemHandler internalHandler;

    public ManagedItemInv(IInventoryCallback callback) {
        super(callback);
    }

    public ManagedItemInv(IInventoryCallback callback, String tag) {
        super(callback, tag);
    }

    public void addSlots(StorageGroup group, int amount) {
        for (int i = 0; i < amount; ++i) {
            this.addSlot(new ItemStorageCoFH(), group);
        }
    }

    public void addSlots(StorageGroup group, int amount, Predicate<ItemStack> validator) {
        for (int i = 0; i < amount; ++i) {
            this.addSlot(new ItemStorageCoFH(validator), group);
        }
    }

    public void addSlot(ItemStorageCoFH slot, StorageGroup group) {
        this.slots.add(slot);
        switch (group) {
            case CATALYST: {
                this.catalystSlots.add(slot);
            }
            case INPUT: {
                this.inputSlots.add(slot);
                break;
            }
            case OUTPUT: {
                this.outputSlots.add(slot);
                break;
            }
            case INTERNAL: {
                this.internalSlots.add(slot);
                break;
            }
            case ACCESSIBLE: {
                this.inputSlots.add(slot);
                this.outputSlots.add(slot);
                break;
            }
        }
    }

    public void initHandlers() {
        ((ArrayList)this.slots).trimToSize();
        ((ArrayList)this.inputSlots).trimToSize();
        ((ArrayList)this.catalystSlots).trimToSize();
        ((ArrayList)this.outputSlots).trimToSize();
        ((ArrayList)this.internalSlots).trimToSize();
        this.inputHandler = new ManagedItemHandler(this.callback, this.inputSlots, Collections.emptyList());
        this.outputHandler = new ManagedItemHandler(this.callback, Collections.emptyList(), this.outputSlots);
        this.ioHandler = new ManagedItemHandler(this.callback, this.inputSlots, this.outputSlots).restrict();
        this.accessibleHandler = new ManagedItemHandler(this.callback, this.inputSlots, this.outputSlots);
        this.internalHandler = new SimpleItemHandler(this.callback, this.internalSlots);
        this.allHandler = new SimpleItemHandler(this.callback, this.slots);
    }

    public boolean hasInputSlots() {
        return this.inputSlots.size() > 0;
    }

    public boolean hasOutputSlots() {
        return this.outputSlots.size() > 0;
    }

    public boolean hasAccessibleSlots() {
        return this.hasInputSlots() || this.hasOutputSlots();
    }

    public List<ItemStorageCoFH> getInputSlots() {
        return this.inputSlots;
    }

    public List<ItemStorageCoFH> getOutputSlots() {
        return this.outputSlots;
    }

    public List<ItemStorageCoFH> getInternalSlots() {
        return this.internalSlots;
    }

    @Override
    public IItemHandler getHandler(StorageGroup group) {
        if (this.allHandler == null) {
            this.initHandlers();
        }
        switch (group) {
            case INPUT: {
                return this.inputHandler;
            }
            case OUTPUT: {
                return this.outputHandler;
            }
            case INPUT_OUTPUT: {
                return this.ioHandler;
            }
            case ACCESSIBLE: {
                return this.accessibleHandler;
            }
            case INTERNAL: {
                return this.internalHandler;
            }
            case ALL: {
                return this.allHandler;
            }
        }
        return EmptyHandler.INSTANCE;
    }
}

