/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.fluid;

import cofh.lib.item.ContainerType;
import cofh.lib.item.IContainerItem;
import cofh.lib.util.helpers.MathHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public interface IFluidContainerItem
extends IContainerItem {
    default public CompoundTag getOrCreateTankTag(ItemStack container) {
        return container.m_41784_();
    }

    default public int getSpace(ItemStack container) {
        return this.getCapacity(container) - this.getFluidAmount(container);
    }

    default public int getScaledFluidStored(ItemStack container, int scale) {
        return MathHelper.round((double)this.getFluidAmount(container) * (double)scale / (double)this.getCapacity(container));
    }

    default public int getFluidAmount(ItemStack container) {
        return this.getFluid(container).getAmount();
    }

    default public FluidStack getFluid(ItemStack container) {
        CompoundTag tag = this.getOrCreateTankTag(container);
        if (!tag.m_128441_("Fluid")) {
            return FluidStack.EMPTY;
        }
        return FluidStack.loadFluidStackFromNBT((CompoundTag)tag.m_128469_("Fluid"));
    }

    default public boolean isFluidValid(ItemStack container, FluidStack resource) {
        return true;
    }

    public int getCapacity(ItemStack var1);

    default public int fill(ItemStack container, FluidStack resource, IFluidHandler.FluidAction action) {
        CompoundTag containerTag = this.getOrCreateTankTag(container);
        if (resource.isEmpty() || !this.isFluidValid(container, resource)) {
            return 0;
        }
        int capacity = this.getCapacity(container);
        if (this.isCreative(container, ContainerType.FLUID)) {
            if (action.execute()) {
                CompoundTag fluidTag = resource.writeToNBT(new CompoundTag());
                fluidTag.m_128405_("Amount", capacity);
                containerTag.m_128365_("Fluid", (Tag)fluidTag);
            }
            return resource.getAmount();
        }
        if (action.simulate()) {
            if (!containerTag.m_128441_("Fluid")) {
                return Math.min(capacity, resource.getAmount());
            }
            FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundTag)containerTag.m_128469_("Fluid"));
            if (stack.isEmpty()) {
                return Math.min(capacity, resource.getAmount());
            }
            if (!stack.isFluidEqual(resource)) {
                return 0;
            }
            return Math.min(capacity - stack.getAmount(), resource.getAmount());
        }
        if (!containerTag.m_128441_("Fluid")) {
            CompoundTag fluidTag = resource.writeToNBT(new CompoundTag());
            if (capacity < resource.getAmount()) {
                fluidTag.m_128405_("Amount", capacity);
                containerTag.m_128365_("Fluid", (Tag)fluidTag);
                return capacity;
            }
            fluidTag.m_128405_("Amount", resource.getAmount());
            containerTag.m_128365_("Fluid", (Tag)fluidTag);
            return resource.getAmount();
        }
        CompoundTag fluidTag = containerTag.m_128469_("Fluid");
        FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundTag)fluidTag);
        if (stack.isEmpty() || !stack.isFluidEqual(resource)) {
            return 0;
        }
        int filled = capacity - stack.getAmount();
        if (resource.getAmount() < filled) {
            stack.grow(resource.getAmount());
            filled = resource.getAmount();
        } else {
            stack.setAmount(capacity);
        }
        containerTag.m_128365_("Fluid", (Tag)stack.writeToNBT(fluidTag));
        return filled;
    }

    default public FluidStack drain(ItemStack container, int maxDrain, IFluidHandler.FluidAction action) {
        int drained;
        CompoundTag containerTag = this.getOrCreateTankTag(container);
        if (maxDrain <= 0 || !containerTag.m_128441_("Fluid")) {
            return FluidStack.EMPTY;
        }
        FluidStack stack = FluidStack.loadFluidStackFromNBT((CompoundTag)containerTag.m_128469_("Fluid"));
        if (stack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        boolean creative = this.isCreative(container, ContainerType.FLUID);
        int n = drained = creative ? maxDrain : Math.min(stack.getAmount(), maxDrain);
        if (action.execute() && !creative) {
            if (maxDrain >= stack.getAmount()) {
                containerTag.m_128473_("Fluid");
                return stack;
            }
            CompoundTag fluidTag = containerTag.m_128469_("Fluid");
            fluidTag.m_128405_("Amount", fluidTag.m_128451_("Amount") - drained);
            containerTag.m_128365_("Fluid", (Tag)fluidTag);
        }
        stack.setAmount(drained);
        return stack;
    }
}

