/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.config.world;

import cofh.lib.config.IBaseConfig;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.common.ForgeConfigSpec;

public abstract class FeatureConfig
implements IBaseConfig {
    private Set<BiomeDictionary.Type> storedBiomes = null;
    private Set<BiomeDictionary.Type> storedRestrictions = null;
    protected List<BiomeDictionary.Type> biomes;
    protected List<BiomeDictionary.Type> biomeRestrictions;
    protected ForgeConfigSpec.ConfigValue<String> configBiomes;
    protected ForgeConfigSpec.ConfigValue<String> configBiomeRestrictions;
    protected Supplier<ConfiguredStructureFeature<?, ?>> structure = null;

    public FeatureConfig(List<BiomeDictionary.Type> biomeTypes, List<BiomeDictionary.Type> biomeRestrictions) {
        this.biomes = biomeTypes;
        this.biomeRestrictions = biomeRestrictions;
    }

    public boolean isFeature() {
        return true;
    }

    public abstract GenerationStep.Decoration getStage();

    public abstract boolean shouldSpawn();

    public Set<BiomeDictionary.Type> getBiomes() {
        if (this.storedBiomes == null) {
            this.storedBiomes = Stream.of(((String)this.configBiomes.get()).split(",")).map(x$0 -> BiomeDictionary.Type.getType((String)x$0, (BiomeDictionary.Type[])new BiomeDictionary.Type[0])).collect(Collectors.toSet());
        }
        return this.storedBiomes;
    }

    public Set<BiomeDictionary.Type> getBiomeRestrictions() {
        if (this.storedRestrictions == null) {
            this.storedRestrictions = Stream.of(((String)this.configBiomeRestrictions.get()).split(",")).map(x$0 -> BiomeDictionary.Type.getType((String)x$0, (BiomeDictionary.Type[])new BiomeDictionary.Type[0])).collect(Collectors.toSet());
        }
        return this.storedRestrictions;
    }

    @Override
    public void apply(ForgeConfigSpec.Builder builder) {
    }

    @Override
    public void refresh() {
    }
}

