/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.capability.templates;

import cofh.lib.capability.templates.AreaEffectItemWrapper;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.AreaEffectHelper;
import cofh.lib.util.references.EnsorcReferences;
import com.google.common.collect.ImmutableList;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class AreaEffectMiningItemWrapper
extends AreaEffectItemWrapper {
    private final int radius;
    private final int depth;
    private final Type type;

    public AreaEffectMiningItemWrapper(ItemStack containerIn, int radius, int depth, Type type) {
        super(containerIn);
        this.radius = radius;
        this.depth = depth;
        this.type = type;
    }

    public AreaEffectMiningItemWrapper(ItemStack containerIn, int radius, Type type) {
        this(containerIn, radius, 1, type);
    }

    @Override
    public ImmutableList<BlockPos> getAreaEffectBlocks(BlockPos pos, Player player) {
        if (this.type == Type.SICKLE) {
            return AreaEffectHelper.getBlocksCentered(this.areaEffectItem, pos, player, this.radius, this.depth);
        }
        return AreaEffectHelper.getBreakableBlocksRadius(this.areaEffectItem, pos, player, this.radius + Utils.getItemEnchantmentLevel(EnsorcReferences.EXCAVATING, this.areaEffectItem));
    }

    public static enum Type {
        EXCAVATOR,
        HAMMER,
        SICKLE;

    }
}

