/*
 * Decompiled with CFR 0.152.
 */
package cofh.lib.block.impl.rails;

import cofh.lib.block.IDismantleable;
import cofh.lib.util.Utils;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.helpers.MathHelper;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.RailShape;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public class CrossoverRailBlock
extends BaseRailBlock
implements IDismantleable {
    protected float maxSpeed = 0.4f;

    public CrossoverRailBlock(BlockBehaviour.Properties builder) {
        super(true, builder);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(this.m_7978_(), (Comparable)RailShape.NORTH_SOUTH)).m_61124_((Property)f_152149_, (Comparable)Boolean.valueOf(false)));
    }

    public CrossoverRailBlock speed(float maxSpeed) {
        this.maxSpeed = MathHelper.clamp(maxSpeed, 0.0f, 1.0f);
        return this;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{this.m_7978_(), f_152149_});
    }

    public float getRailMaxSpeed(BlockState state, Level world, BlockPos pos, AbstractMinecart cart) {
        return this.maxSpeed;
    }

    public Property<RailShape> m_7978_() {
        return Constants.RAIL_STRAIGHT_FLAT;
    }

    public boolean canMakeSlopes(BlockState state, BlockGetter world, BlockPos pos) {
        return false;
    }

    public RailShape getRailDirection(BlockState state, BlockGetter world, BlockPos pos, @Nullable AbstractMinecart cart) {
        if (cart != null) {
            double absZ;
            double absX = Math.abs(cart.m_20184_().f_82479_);
            if (absX > (absZ = Math.abs(cart.m_20184_().f_82481_))) {
                return RailShape.EAST_WEST;
            }
            if (absZ > absX) {
                return RailShape.NORTH_SOUTH;
            }
        }
        return (RailShape)state.m_61143_(this.m_7978_());
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return state;
    }

    public BlockState m_6943_(BlockState state, Mirror mirrorIn) {
        return state;
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (Utils.isWrench(player.m_21120_(handIn))) {
            if (player.m_36341_()) {
                if (this.canDismantle(worldIn, pos, state, player)) {
                    this.dismantleBlock(worldIn, pos, state, (HitResult)hit, player, false);
                    return InteractionResult.SUCCESS;
                }
            } else {
                BlockState rotState = this.rotate(state, (LevelAccessor)worldIn, pos, Rotation.CLOCKWISE_90);
                if (rotState != state) {
                    worldIn.m_46597_(pos, rotState);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        return InteractionResult.PASS;
    }
}

