/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.helpers.vfx;

import cofh.core.util.helpers.RenderHelper;
import cofh.core.util.helpers.vfx.RenderTypes;
import cofh.lib.util.helpers.MathHelper;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Matrix3f;
import com.mojang.math.Matrix4f;
import com.mojang.math.Vector3f;
import com.mojang.math.Vector4f;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.SortedMap;
import java.util.SplittableRandom;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec2;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public final class VFXHelper {
    private static final SortedMap<Float, List<int[]>> shockwaveOffsets = VFXHelper.getOffsets(16);
    public static final List<RenderType> chunkRenderTypes = RenderType.m_110506_();
    private static final Vector3f[][] arcs = VFXHelper.getRandomArcs(new Random(), 8, 48);
    private static final int WIND_SEGMENTS = 48;
    public static final float WIND_INCR = 0.1308997f;

    public static float lengthSqr(Vector3f vec) {
        return MathHelper.distSqr(vec.m_122239_(), vec.m_122260_(), vec.m_122269_());
    }

    public static float length(Vector3f vec) {
        return MathHelper.dist(vec.m_122239_(), vec.m_122260_(), vec.m_122269_());
    }

    public static VFXNode interpolate(VFXNode a, VFXNode b, float d) {
        return new VFXNode(MathHelper.interpolate(a.xp, b.xp, d), MathHelper.interpolate(a.xn, b.xn, d), MathHelper.interpolate(a.yp, b.yp, d), MathHelper.interpolate(a.yn, b.yn, d), MathHelper.interpolate(a.z, b.z, d), MathHelper.interpolate(a.width, b.width, d));
    }

    private static VFXNode interpolateCap(VFXNode a, VFXNode b) {
        return VFXHelper.interpolate(a, b, 1.0f + b.width * 0.5f / MathHelper.dist(a.xMid() - b.xMid(), a.yMid() - b.yMid(), a.z - b.z));
    }

    public static Vector4f subtract(Vector4f a, Vector4f b) {
        return new Vector4f(a.m_123601_() - b.m_123601_(), a.m_123615_() - b.m_123615_(), a.m_123616_() - b.m_123616_(), a.m_123617_() - b.m_123617_());
    }

    public static int packRGBA(float r, float g, float b, float a) {
        return VFXHelper.packRGBA((int)(255.0f * r), (int)(255.0f * g), (int)(255.0f * b), (int)(255.0f * a));
    }

    public static int packRGBA(int r, int g, int b, int a) {
        return r << 24 | g << 16 | b << 8 | a;
    }

    public static Vector4f mid(Vector4f a, Vector4f b) {
        return new Vector4f((a.m_123601_() + b.m_123601_()) * 0.5f, (a.m_123615_() + b.m_123615_()) * 0.5f, (a.m_123616_() + b.m_123616_()) * 0.5f, (a.m_123617_() + b.m_123617_()) * 0.5f);
    }

    private static void renderNodes(Matrix3f normal, VertexConsumer builder, int packedLight, VFXNode[] nodes, int r, int g, int b, int a) {
        nodes[0].renderStart(normal, builder, packedLight, r, g, b, a);
        int count = nodes.length - 1;
        for (int i = 1; i < count; ++i) {
            nodes[i].renderMid(normal, builder, packedLight, r, g, b, a);
        }
        nodes[count].renderEnd(normal, builder, packedLight, r, g, b, a);
    }

    private static void renderNodesCapped(Matrix3f normal, MultiBufferSource buffer, RenderType midType, RenderType capType, int packedLight, VFXNode[] nodes, int r, int g, int b, int a) {
        if (nodes.length < 2) {
            return;
        }
        VertexConsumer consumer = buffer.m_6299_(midType);
        VFXHelper.renderNodes(normal, consumer, packedLight, nodes, r, g, b, a);
        consumer = buffer.m_6299_(capType);
        VFXHelper.interpolateCap(nodes[1], nodes[0]).renderStart(normal, consumer, packedLight, r, g, b, a, 0.0f, 0.0f, 1.0f, 0.5f);
        nodes[0].renderEnd(normal, consumer, packedLight, r, g, b, a, 0.0f, 0.0f, 1.0f, 0.5f);
        nodes[nodes.length - 1].renderStart(normal, consumer, packedLight, r, g, b, a, 0.0f, 0.5f, 1.0f, 1.0f);
        VFXHelper.interpolateCap(nodes[nodes.length - 2], nodes[nodes.length - 1]).renderEnd(normal, consumer, packedLight, r, g, b, a, 0.0f, 0.5f, 1.0f, 1.0f);
    }

    public static Vec2 axialPerp(Vector4f start, Vector4f end, float width) {
        float x = -start.m_123601_();
        float y = -start.m_123615_();
        if (Math.abs(start.m_123616_()) > 0.0f) {
            float ratio = end.m_123616_() / start.m_123616_();
            x = end.m_123601_() + x * ratio;
            y = end.m_123615_() + y * ratio;
        } else if (Math.abs(end.m_123616_()) <= 0.0f) {
            x += end.m_123601_();
            y += end.m_123615_();
        }
        if (start.m_123616_() > 0.0f) {
            x = -x;
            y = -y;
        }
        if (x * x + y * y > 0.0f) {
            float normalize = width * 0.5f / MathHelper.dist(x, y);
            x *= normalize;
            y *= normalize;
        }
        return new Vec2(-y, x);
    }

    public static Vec2 axialPerp(Vector3f start, Vector3f end, float width) {
        float x = -start.m_122239_();
        float y = -start.m_122260_();
        if (Math.abs(start.m_122269_()) > 0.0f) {
            float ratio = end.m_122269_() / start.m_122269_();
            x = end.m_122239_() + x * ratio;
            y = end.m_122260_() + y * ratio;
        } else if (Math.abs(end.m_122269_()) <= 0.0f) {
            x += end.m_122239_();
            y += end.m_122260_();
        }
        if (start.m_122269_() > 0.0f) {
            x = -x;
            y = -y;
        }
        if (x * x + y * y > 0.0f) {
            float normalize = width * 0.5f / MathHelper.dist(x, y);
            x *= normalize;
            y *= normalize;
        }
        return new Vec2(-y, x);
    }

    public static void transformVertical(PoseStack stack, Vector3f dir) {
        boolean neg;
        dir.m_122278_();
        boolean bl = neg = dir.m_122260_() < 0.0f;
        if ((double)(dir.m_122239_() * dir.m_122239_() + dir.m_122269_() * dir.m_122269_()) > 0.001) {
            dir.m_122279_(Vector3f.f_122225_);
            float angle = -MathHelper.asin(VFXHelper.length(dir));
            if (neg) {
                angle = -((float)Math.PI + angle);
            }
            dir.m_122278_();
            stack.m_85845_(dir.m_122270_(angle));
        } else if (neg) {
            stack.m_85845_(Vector3f.f_122223_.m_122270_((float)Math.PI));
        }
    }

    public static void transformVertical(PoseStack stack, Vector3f start, Vector3f end) {
        Vector3f diff = end.m_122281_();
        diff.m_122267_(start);
        float scale = VFXHelper.length(diff);
        stack.m_85837_((double)start.m_122239_(), (double)start.m_122260_(), (double)start.m_122269_());
        VFXHelper.transformVertical(stack, diff);
        stack.m_85841_(scale, scale, scale);
    }

    public static void renderTest(PoseStack stack, MultiBufferSource buffer) {
        RenderType type = RenderTypes.FLAT_TRANSLUCENT;
        VertexConsumer builder = buffer.m_6299_(type);
        Vector4f center = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
        center.m_123607_(stack.m_85850_().m_85861_());
        Matrix3f normal = stack.m_85850_().m_85864_();
        float xp = center.m_123601_() + 0.5f;
        float xn = center.m_123601_() - 0.5f;
        float yp = center.m_123615_() + 0.5f;
        float yn = center.m_123615_() - 0.5f;
        float z = center.m_123616_();
        int r = 255;
        int g = 0;
        int b = 255;
        int a = 128;
        int packedLight = 0xF000F0;
        builder.m_5483_((double)xp, (double)yp, (double)z).m_6122_(r, g, b, a).m_7421_(0.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_5483_((double)xn, (double)yp, (double)z).m_6122_(r, g, b, a).m_7421_(0.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_5483_((double)xn, (double)yn, (double)z).m_6122_(r, g, b, a).m_7421_(1.0f, 1.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
        builder.m_5483_((double)xp, (double)yn, (double)z).m_6122_(r, g, b, a).m_7421_(1.0f, 0.0f).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
    }

    public static void renderTest(PoseStack stack) {
        VFXHelper.renderTest(stack, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_());
    }

    private static void renderSkeleton(VertexConsumer builder, VFXNode[] nodes) {
        VFXNode node = nodes[0];
        float xm = node.xMid();
        float ym = node.yMid();
        builder.m_5483_((double)node.xp, (double)node.yp, (double)node.z).m_6122_(255, 0, 0, 255).m_5752_();
        builder.m_5483_((double)xm, (double)ym, (double)node.z).m_6122_(255, 0, 0, 255).m_5752_();
        builder.m_5483_((double)xm, (double)ym, (double)node.z).m_6122_(0, 0, 255, 255).m_5752_();
        builder.m_5483_((double)node.xn, (double)node.yn, (double)node.z).m_6122_(0, 0, 255, 255).m_5752_();
        builder.m_5483_((double)xm, (double)ym, (double)node.z).m_6122_(255, 255, 255, 255).m_5752_();
        for (int i = 1; i < nodes.length - 1; ++i) {
            node = nodes[i];
            xm = node.xMid();
            ym = node.yMid();
            builder.m_5483_((double)xm, (double)ym, (double)node.z).m_6122_(255, 255, 255, 255).m_5752_();
            builder.m_5483_((double)node.xp, (double)node.yp, (double)node.z).m_6122_(255, 0, 0, 255).m_5752_();
            builder.m_5483_((double)xm, (double)ym, (double)node.z).m_6122_(255, 0, 0, 255).m_5752_();
            builder.m_5483_((double)xm, (double)ym, (double)node.z).m_6122_(0, 0, 255, 255).m_5752_();
            builder.m_5483_((double)node.xn, (double)node.yn, (double)node.z).m_6122_(0, 0, 255, 255).m_5752_();
            builder.m_5483_((double)xm, (double)ym, (double)node.z).m_6122_(255, 255, 255, 255).m_5752_();
        }
        node = nodes[nodes.length - 1];
        xm = node.xMid();
        ym = node.yMid();
        builder.m_5483_((double)xm, (double)ym, (double)node.z).m_6122_(255, 255, 255, 255).m_5752_();
        builder.m_5483_((double)node.xp, (double)node.yp, (double)node.z).m_6122_(255, 0, 0, 255).m_5752_();
        builder.m_5483_((double)xm, (double)ym, (double)node.z).m_6122_(255, 0, 0, 255).m_5752_();
        builder.m_5483_((double)xm, (double)ym, (double)node.z).m_6122_(0, 0, 255, 255).m_5752_();
        builder.m_5483_((double)node.xn, (double)node.yn, (double)node.z).m_6122_(0, 0, 255, 255).m_5752_();
    }

    private static void renderSkeleton(VFXNode[] nodes) {
        VFXHelper.renderSkeleton(Minecraft.m_91087_().m_91269_().m_110104_().m_6299_((RenderType)RenderType.f_110371_), nodes);
    }

    public static void renderShockwave(PoseStack stack, MultiBufferSource buffer, BlockAndTintGetter level, BlockPos origin, float time, float radius, float heightScale, Predicate<BlockPos> canRender) {
        BlockRenderDispatcher renderer = RenderHelper.renderBlock();
        SortedMap<Float, List<int[]>> blocks = shockwaveOffsets.subMap(Float.valueOf(Math.min(time - 5.0f, radius)), Float.valueOf(Math.min(time, radius + 1.0f)));
        for (Float dist : blocks.keySet()) {
            float progress = time - dist.floatValue();
            double height = (double)heightScale * 0.16 * (double)(radius - dist.floatValue() * 0.5f) * (double)progress * (double)(5.0f - progress) / (double)radius;
            block1: for (int[] offset : (List)blocks.get(dist)) {
                for (int y = 1; y >= -1; --y) {
                    BlockPos pos = origin.m_142082_(offset[0], y, offset[1]);
                    BlockState state = level.m_8055_(pos);
                    if (!canRender.test(pos)) continue;
                    if (state.m_60799_() != RenderShape.MODEL) continue block1;
                    stack.m_85836_();
                    stack.m_85837_((double)offset[0], height + (double)y, (double)offset[1]);
                    stack.m_85841_(1.01f, 1.01f, 1.01f);
                    for (RenderType type : chunkRenderTypes) {
                        if (!ItemBlockRenderTypes.canRenderInLayer((BlockState)state, (RenderType)type)) continue;
                        ForgeHooksClient.setRenderType((RenderType)type);
                        renderer.renderBatched(state, pos.m_142300_(Direction.UP), level, stack, buffer.m_6299_(type), false, new Random(), (IModelData)EmptyModelData.INSTANCE);
                    }
                    stack.m_85849_();
                    continue block1;
                }
            }
        }
        ForgeHooksClient.setRenderType(null);
    }

    public static void renderShockwave(PoseStack stack, MultiBufferSource buffer, BlockAndTintGetter world, BlockPos origin, float time, float radius, float heightScale) {
        VFXHelper.renderShockwave(stack, buffer, world, origin, time, radius, heightScale, pos -> {
            BlockState state = world.m_8055_(pos);
            return !state.m_60795_() && state.m_60796_((BlockGetter)world, pos) && state.m_60838_((BlockGetter)world, pos) && !state.m_155947_() && !world.m_8055_(pos.m_7494_()).m_60838_((BlockGetter)world, pos.m_7494_());
        });
    }

    private static SortedMap<Float, List<int[]>> getOffsets(int maxRadius) {
        TreeMap<Float, List<int[]>> blocks = new TreeMap<Float, List<int[]>>();
        float maxSqr = maxRadius * maxRadius;
        for (int x = 0; x <= MathHelper.ceil(maxRadius); ++x) {
            for (int z = 0; z <= x; ++z) {
                int distSqr = x * x + z * z;
                if (!((float)distSqr < maxSqr)) continue;
                float dist = MathHelper.sqrt(distSqr);
                if (!blocks.containsKey(Float.valueOf(dist))) {
                    blocks.put(Float.valueOf(dist), new ArrayList());
                }
                VFXHelper.addReflections((List)blocks.get(Float.valueOf(dist)), x, z);
            }
        }
        return blocks;
    }

    private static void addReflections(List<int[]> list, int x, int z) {
        list.add(new int[]{x, z});
        list.add(new int[]{-x, -z});
        if (z != 0) {
            list.add(new int[]{-x, z});
            list.add(new int[]{x, -z});
        }
        if (x != 0 && x != z) {
            list.add(new int[]{z, x});
            list.add(new int[]{-z, -x});
            if (z != 0) {
                list.add(new int[]{-z, x});
                list.add(new int[]{z, -x});
            }
        }
    }

    public static void renderStraightArcs(PoseStack poseStackIn, MultiBufferSource buffer, int packedLight, int arcCount, float arcWidth, float widthVar, long seed, int coreRGBA, int glowRGBA, float taperOffset) {
        SplittableRandom rand = new SplittableRandom(seed);
        poseStackIn.m_85836_();
        int nodeCount = arcs[0].length;
        int first = MathHelper.clamp((int)((float)nodeCount * (taperOffset - 0.25f) + 1.0f), 0, nodeCount);
        int last = MathHelper.clamp((int)((float)nodeCount * (1.25f + taperOffset) + 1.0f), 0, nodeCount);
        if (last - first > 1) {
            PoseStack.Pose stackEntry = poseStackIn.m_85850_();
            Matrix4f pose = stackEntry.m_85861_();
            Matrix3f normal = stackEntry.m_85864_();
            Vector4f start = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f);
            start.m_123607_(pose);
            Vector4f end = new Vector4f(0.0f, 1.0f, 0.0f, 1.0f);
            end.m_123607_(pose);
            Vec2 perp = VFXHelper.axialPerp(start, end, 1.0f);
            Vector3f[][] randomArcs = new Vector3f[nodeCount][arcCount];
            float[] rotations = new float[arcCount];
            for (int i = 0; i < arcCount; ++i) {
                randomArcs[i] = arcs[rand.nextInt(arcs.length)];
                rotations[i] = (float)rand.nextDouble(360.0);
            }
            float incr = 1.0f / (float)nodeCount;
            for (int i = 0; i < arcCount; ++i) {
                poseStackIn.m_85845_(Vector3f.f_122225_.m_122240_(rotations[i]));
                Vector3f[] arc = randomArcs[i];
                VFXNode[] outer = new VFXNode[last - first];
                VFXNode[] inner = new VFXNode[last - first];
                for (int j = first; j < last; ++j) {
                    Vector4f center = new Vector4f(0.0f, arc[j].m_122260_(), 0.0f, 1.0f);
                    center.m_123607_(pose);
                    Vector4f pos = new Vector4f(arc[j]);
                    pos.m_123607_(pose);
                    float dot = VFXHelper.subtract(pos, center).m_123613_(new Vector4f(perp.f_82470_, perp.f_82471_, 0.0f, 0.0f));
                    float xc = center.m_123601_() + perp.f_82470_ * dot * 3.0f;
                    float yc = center.m_123615_() + perp.f_82471_ * dot * 3.0f;
                    float width = Math.max(arcWidth + (float)rand.nextDouble(-1.0, 1.0) * widthVar, 0.0f) * MathHelper.clamp(4.0f * (0.75f - Math.abs((float)j * incr - 0.5f - taperOffset)), 0.0f, 1.0f);
                    float xw = perp.f_82470_ * width;
                    float yw = perp.f_82471_ * width;
                    inner[j - first] = new VFXNode(xc + xw, xc - xw, yc + yw, yc - yw, center.m_123616_(), width);
                    width = Math.max(width, arcWidth);
                    outer[j - first] = new VFXNode(xc + (xw += perp.f_82470_ * width), xc - xw, yc + (yw += perp.f_82471_ * width), yc - yw, center.m_123616_(), width);
                }
                VFXHelper.renderNodesCapped(normal, buffer, RenderTypes.LINEAR_GLOW, RenderTypes.ROUND_GLOW, packedLight, outer, glowRGBA >> 24 & 0xFF, glowRGBA >> 16 & 0xFF, glowRGBA >> 8 & 0xFF, glowRGBA & 0xFF);
                VFXHelper.renderNodesCapped(normal, buffer, RenderTypes.LINEAR_GLOW, RenderTypes.ROUND_GLOW, packedLight, inner, coreRGBA >> 24 & 0xFF, coreRGBA >> 16 & 0xFF, coreRGBA >> 8 & 0xFF, coreRGBA & 0xFF);
            }
        }
        poseStackIn.m_85849_();
    }

    public static void renderStraightArcs(PoseStack poseStackIn, MultiBufferSource buffer, int packedLightIn, int arcCount, float arcWidth, long seed, int coreRGBA, int glowRGBA, float taperOffset) {
        VFXHelper.renderStraightArcs(poseStackIn, buffer, packedLightIn, arcCount, arcWidth, 0.3f * arcWidth, seed, coreRGBA, glowRGBA, taperOffset);
    }

    public static void renderStraightArcs(PoseStack poseStackIn, MultiBufferSource buffer, int packedLightIn, float length, int arcCount, float arcWidth, long seed, int coreRGBA, int glowRGBA, float taperOffset) {
        poseStackIn.m_85836_();
        poseStackIn.m_85841_(length, length, length);
        VFXHelper.renderStraightArcs(poseStackIn, buffer, packedLightIn, arcCount, arcWidth / Math.abs(length), seed, coreRGBA, glowRGBA, taperOffset);
        poseStackIn.m_85849_();
    }

    public static long getSeedWithTime(long seed, float time, float flickerRate) {
        return seed + (long)(69420 * (int)(time * flickerRate));
    }

    public static long getSeedWithTime(long seed, float time) {
        return VFXHelper.getSeedWithTime(seed, time, 0.75f);
    }

    public static float getTaperOffsetFromTimes(float time, float endTime, float taperTime) {
        float offset = 0.0f;
        if (time < taperTime) {
            offset = 1.25f * (time - taperTime) / taperTime;
        } else if (endTime - time < taperTime) {
            offset = 1.25f * (time + taperTime - endTime) / taperTime;
        }
        return offset;
    }

    public static float getTaperOffsetFromTimes(float time, float startTime, float endTime, float taperTime) {
        return VFXHelper.getTaperOffsetFromTimes(time - startTime, endTime - startTime, taperTime);
    }

    private static Vector3f[][] getRandomArcs(Random random, int arcCount, int nodeCount) {
        Vector3f[][] arcs = new Vector3f[arcCount][nodeCount];
        for (int i = 0; i < arcs.length; ++i) {
            arcs[i] = VFXHelper.getRandomNodes(random, nodeCount);
        }
        return arcs;
    }

    private static Vector3f[] getRandomNodes(Random random, int count) {
        int i;
        TreeSet<Float> ySet = new TreeSet<Float>();
        float e = 0.25f / (float)count;
        ySet.add(Float.valueOf(0.0f));
        ySet.add(Float.valueOf(1.0f));
        count -= 2;
        for (i = 0; i < count * 3 && ySet.size() < count; ++i) {
            float next = random.nextFloat();
            if (ySet.subSet(Float.valueOf(next - e), Float.valueOf(next + e)).size() > 0) continue;
            ySet.add(Float.valueOf(next));
        }
        for (i = count - ySet.size(); i > 0; --i) {
            ySet.add(Float.valueOf(random.nextFloat()));
        }
        Float[] y = (Float[])ySet.toArray(Float[]::new);
        Vector3f[] nodes = new Vector3f[y.length];
        nodes[0] = new Vector3f(0.0f, 0.0f, 0.0f);
        nodes[nodes.length - 1] = new Vector3f(0.0f, 1.0f, 0.0f);
        for (int i2 = 1; i2 < nodes.length - 1; ++i2) {
            float eccentricity = 0.3f * (y[i2].floatValue() - y[i2 - 1].floatValue());
            float centering = Math.min(1.0f, 3.0f - 3.0f * (float)i2 / (float)nodes.length);
            nodes[i2] = new Vector3f(centering * nodes[i2 - 1].m_122239_() + eccentricity * VFXHelper.boundedGaussian(random, 1.65f), y[i2].floatValue(), centering * nodes[i2 - 1].m_122269_() + eccentricity * VFXHelper.boundedGaussian(random, 1.65f));
        }
        return nodes;
    }

    private static float boundedGaussian(Random random, float z) {
        return MathHelper.clamp((float)random.nextGaussian(), -z, z);
    }

    public static Function<Float, Float> getWidthFunc(float width) {
        return index -> Float.valueOf(width * MathHelper.easePlateau(index.floatValue()));
    }

    public static void renderStreamLine(PoseStack stack, VertexConsumer builder, int packedLight, Vector4f[] poss, int rgba, Function<Float, Float> widthFunc) {
        if (poss.length < 3) {
            return;
        }
        int a = rgba & 0xFF;
        if (a <= 0) {
            return;
        }
        int r = rgba >> 24 & 0xFF;
        int g = rgba >> 16 & 0xFF;
        int b = rgba >> 8 & 0xFF;
        PoseStack.Pose stackEntry = stack.m_85850_();
        Matrix4f pose = stackEntry.m_85861_();
        Matrix3f normal = stackEntry.m_85864_();
        for (Vector4f pos : poss) {
            pos.m_123607_(pose);
        }
        int count = poss.length - 1;
        VFXNode[] nodes = new VFXNode[count];
        float increment = 1.0f / (float)(count - 1);
        for (int i = 0; i < count; ++i) {
            Vector4f start = poss[i];
            Vector4f end = poss[i + 1];
            float width = widthFunc.apply(Float.valueOf(increment * (float)i)).floatValue();
            nodes[i] = new VFXNode(VFXHelper.mid(start, end), VFXHelper.axialPerp(start, end, width), width);
        }
        VFXHelper.renderNodes(normal, builder, packedLight, nodes, r, g, b, a);
    }

    public static void renderStreamLine(PoseStack stack, MultiBufferSource buffer, int packedLight, Vector4f[] poss, int rgba, Function<Float, Float> widthFunc) {
        VFXHelper.renderStreamLine(stack, buffer.m_6299_(RenderTypes.FLAT_TRANSLUCENT), packedLight, poss, rgba, widthFunc);
    }

    public static void renderCyclone(PoseStack stack, VertexConsumer builder, int packedLight, int streamCount, float streamWidth, float time, float alphaScale) {
        SplittableRandom rand = new SplittableRandom(69420L);
        streamCount *= 2;
        stack.m_85836_();
        stack.m_85845_(Vector3f.f_122225_.m_122270_(time * 6.2832f));
        for (int i = 0; i < streamCount; ++i) {
            float relRot = ((float)rand.nextDouble() - 0.5f) * time * 0.5f + (float)(2 * i);
            float scale = 1.0f + ((float)rand.nextDouble() + MathHelper.sin(time * 0.1f + (float)i)) * 0.1f;
            float width = streamWidth * ((float)rand.nextDouble() * 0.8f + 0.6f) / scale;
            int alpha = (int)MathHelper.clamp((float)(64 + rand.nextInt(64)) * alphaScale * (MathHelper.bevel((float)rand.nextDouble(4.0) + time * 0.06f) + 1.0f), 0.0f, 255.0f);
            int value = rand.nextInt(32) + 224;
            float y = ((float)rand.nextDouble() + MathHelper.cos(time * 0.2f + (float)i)) * 0.16f;
            int length = rand.nextInt(24) + 24;
            if (alpha <= 0) continue;
            Vector4f[] nodes = new Vector4f[length];
            stack.m_85836_();
            stack.m_85845_(Vector3f.f_122225_.m_122270_(relRot));
            stack.m_85841_(scale, scale, scale);
            for (int j = 0; j < length; ++j) {
                float angle = (float)j * 0.1308997f;
                nodes[j] = new Vector4f(MathHelper.cos(angle) * 0.5f, y, MathHelper.sin(angle) * 0.5f, 1.0f);
            }
            VFXHelper.renderStreamLine(stack, builder, packedLight, nodes, VFXHelper.packRGBA(value, value, value, alpha), VFXHelper.getWidthFunc(width));
            stack.m_85849_();
        }
        stack.m_85849_();
    }

    public static void renderCyclone(PoseStack stack, MultiBufferSource buffer, int packedLight, float radius, float height, int streamCount, float streamWidth, float time, float alphaScale) {
        stack.m_85836_();
        float diameter = radius * 2.0f;
        stack.m_85841_(diameter, height, diameter);
        VFXHelper.renderCyclone(stack, buffer.m_6299_(RenderTypes.FLAT_TRANSLUCENT), packedLight, streamCount, streamWidth, time, alphaScale);
        stack.m_85849_();
    }

    public static class VFXNode {
        public final float xp;
        public final float xn;
        public final float yp;
        public final float yn;
        public final float z;
        public final float width;

        public VFXNode(float xp, float xn, float yp, float yn, float z, float width) {
            this.xp = xp;
            this.xn = xn;
            this.yp = yp;
            this.yn = yn;
            this.z = z;
            this.width = width;
        }

        public VFXNode(Vector4f pos, Vec2 perp, float width) {
            this(pos.m_123601_() + perp.f_82470_, pos.m_123601_() - perp.f_82470_, pos.m_123615_() + perp.f_82471_, pos.m_123615_() - perp.f_82471_, pos.m_123616_(), width);
        }

        public VFXNode(float xp, float xn, float yp, float yn, float z) {
            this(xp, xn, yp, yn, z, MathHelper.dist(xp - xn, yp - yn));
        }

        public float xMid() {
            return (this.xp + this.xn) * 0.5f;
        }

        public float yMid() {
            return (this.yp + this.yn) * 0.5f;
        }

        public VFXNode renderStart(Matrix3f normal, VertexConsumer builder, int packedLight, int r, int g, int b, int a, float u0, float v0, float u1, float v1) {
            builder.m_5483_((double)this.xp, (double)this.yp, (double)this.z).m_6122_(r, g, b, a).m_7421_(u0, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            builder.m_5483_((double)this.xn, (double)this.yn, (double)this.z).m_6122_(r, g, b, a).m_7421_(u1, v0).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            return this;
        }

        public VFXNode renderEnd(Matrix3f normal, VertexConsumer builder, int packedLight, int r, int g, int b, int a, float u0, float v0, float u1, float v1) {
            builder.m_5483_((double)this.xn, (double)this.yn, (double)this.z).m_6122_(r, g, b, a).m_7421_(u1, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            builder.m_5483_((double)this.xp, (double)this.yp, (double)this.z).m_6122_(r, g, b, a).m_7421_(u0, v1).m_86008_(OverlayTexture.f_118083_).m_85969_(packedLight).m_85977_(normal, 0.0f, 1.0f, 0.0f).m_5752_();
            return this;
        }

        public VFXNode renderMid(Matrix3f normal, VertexConsumer builder, int packedLight, int r, int g, int b, int a, float u0, float v0, float u1, float v1, float u2, float v2, float u3, float v3) {
            this.renderEnd(normal, builder, packedLight, r, g, b, a, u0, v0, u1, v1);
            this.renderStart(normal, builder, packedLight, r, g, b, a, u2, v2, u3, v3);
            return this;
        }

        public VFXNode renderMid(Matrix3f normal, VertexConsumer builder, int packedLight, int r, int g, int b, int a, float u0, float v0, float u1, float v1, float u2, float v2) {
            return this.renderMid(normal, builder, packedLight, r, g, b, a, u0, v0, u1, v1, u1, v1, u2, v2);
        }

        public VFXNode renderMid(Matrix3f normal, VertexConsumer builder, int packedLight, int r, int g, int b, int a, float u0, float v0, float u1, float v1) {
            return this.renderMid(normal, builder, packedLight, r, g, b, a, u0, v0, u1, v1, u0, v0, u1, v1);
        }

        public VFXNode renderStart(Matrix3f normal, VertexConsumer builder, int packedLight, int r, int g, int b, int a) {
            return this.renderStart(normal, builder, packedLight, r, g, b, a, 0.0f, 0.0f, 1.0f, 1.0f);
        }

        public VFXNode renderEnd(Matrix3f normal, VertexConsumer builder, int packedLight, int r, int g, int b, int a) {
            return this.renderEnd(normal, builder, packedLight, r, g, b, a, 0.0f, 0.0f, 1.0f, 1.0f);
        }

        public VFXNode renderMid(Matrix3f normal, VertexConsumer builder, int packedLight, int r, int g, int b, int a) {
            return this.renderMid(normal, builder, packedLight, r, g, b, a, 0.0f, 0.0f, 1.0f, 1.0f);
        }

        public String toString() {
            return "{" + this.xp + ", " + this.xn + "}, {" + this.yp + ", " + this.yn + "}, " + this.z;
        }
    }
}

