/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.util.filter;

import cofh.lib.util.filter.IFilter;
import cofh.lib.util.filter.IFilterOptions;
import cofh.lib.util.helpers.ItemHelper;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractItemFilter
implements IFilter,
IFilterOptions {
    public static final int SIZE = 15;
    protected List<ItemStack> items;
    protected Predicate<ItemStack> rules;
    protected boolean allowList = false;
    protected boolean checkNBT = false;

    public AbstractItemFilter(int size) {
        this.items = new ArrayList<ItemStack>(size);
        for (int i = 0; i < size; ++i) {
            this.items.add(ItemStack.f_41583_);
        }
    }

    public int size() {
        return this.items.size();
    }

    public List<ItemStack> getItems() {
        return this.items;
    }

    public void setItems(List<ItemStack> items) {
        this.items = items;
        this.reset();
    }

    public void reset() {
        this.rules = null;
    }

    @Override
    public Predicate<ItemStack> getItemRules() {
        if (this.rules == null) {
            ObjectOpenHashSet itemSet = new ObjectOpenHashSet();
            for (ItemStack item : this.items) {
                itemSet.add(item.m_41720_());
            }
            this.rules = arg_0 -> this.lambda$getItemRules$0((Set)itemSet, arg_0);
        }
        return this.rules;
    }

    @Override
    public IFilter read(CompoundTag nbt) {
        CompoundTag subTag = nbt.m_128469_("Filter");
        ListTag list = subTag.m_128437_("ItemInv", 10);
        for (int i = 0; i < list.size(); ++i) {
            CompoundTag slotTag = list.m_128728_(i);
            byte slot = slotTag.m_128445_("Slot");
            if (slot < 0 || slot >= this.items.size()) continue;
            this.items.set(slot, ItemStack.m_41712_((CompoundTag)slotTag));
        }
        this.allowList = subTag.m_128471_("AllowList");
        this.checkNBT = subTag.m_128471_("CheckNBT");
        return this;
    }

    @Override
    public CompoundTag write(CompoundTag nbt) {
        CompoundTag subTag = new CompoundTag();
        ListTag list = new ListTag();
        for (int i = 0; i < this.items.size(); ++i) {
            if (this.items.get(i).m_41619_()) continue;
            CompoundTag slotTag = new CompoundTag();
            slotTag.m_128344_("Slot", (byte)i);
            this.items.get(i).m_41739_(slotTag);
            list.add((Object)slotTag);
        }
        subTag.m_128365_("ItemInv", (Tag)list);
        subTag.m_128379_("AllowList", this.allowList);
        subTag.m_128379_("CheckNBT", this.checkNBT);
        nbt.m_128365_("Filter", (Tag)subTag);
        return nbt;
    }

    @Override
    public boolean getAllowList() {
        return this.allowList;
    }

    @Override
    public boolean setAllowList(boolean allowList) {
        this.allowList = allowList;
        return true;
    }

    @Override
    public boolean getCheckNBT() {
        return this.checkNBT;
    }

    @Override
    public boolean setCheckNBT(boolean checkNBT) {
        this.checkNBT = checkNBT;
        return true;
    }

    public Component m_5446_() {
        return new TranslatableComponent("info.cofh.item_filter");
    }

    private /* synthetic */ boolean lambda$getItemRules$0(Set itemSet, ItemStack stack) {
        if (stack.m_41619_()) {
            return false;
        }
        if (this.checkNBT) {
            for (ItemStack item : this.items) {
                if (!ItemHelper.itemsEqualWithTags(stack, item)) continue;
                return this.allowList;
            }
            return !this.allowList;
        }
        return this.allowList == itemSet.contains(stack.m_41720_());
    }
}

