/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network.packet.server;

import cofh.core.CoFHCore;
import cofh.core.util.control.IRedstoneControllableTile;
import cofh.lib.network.packet.IPacketServer;
import cofh.lib.network.packet.PacketBase;
import cofh.lib.util.control.IRedstoneControllable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class RedstoneControlPacket
extends PacketBase
implements IPacketServer {
    protected BlockPos pos;
    protected int threshold;
    protected byte mode;

    public RedstoneControlPacket() {
        super(34, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleServer(ServerPlayer player) {
        Level world = player.f_19853_;
        if (!world.m_46749_(this.pos)) {
            return;
        }
        BlockEntity tile = world.m_7702_(this.pos);
        if (tile instanceof IRedstoneControllableTile) {
            ((IRedstoneControllableTile)tile).setControl(this.threshold, IRedstoneControllable.ControlMode.VALUES[this.mode]);
        }
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
        buf.writeInt(this.threshold);
        buf.writeByte((int)this.mode);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
        this.threshold = buf.readInt();
        this.mode = buf.readByte();
    }

    public static void sendToServer(IRedstoneControllableTile tile) {
        RedstoneControlPacket packet = new RedstoneControlPacket();
        packet.pos = tile.pos();
        packet.threshold = tile.redstoneControl().getThreshold();
        packet.mode = (byte)tile.redstoneControl().getMode().ordinal();
        packet.sendToServer();
    }
}

