/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.network.packet.client;

import cofh.core.CoFHCore;
import cofh.core.util.ProxyUtils;
import cofh.lib.network.packet.IPacketClient;
import cofh.lib.network.packet.PacketBase;
import cofh.lib.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class ModelUpdatePacket
extends PacketBase
implements IPacketClient {
    protected BlockPos pos;

    public ModelUpdatePacket() {
        super(8, CoFHCore.PACKET_HANDLER);
    }

    @Override
    public void handleClient() {
        Level level = ProxyUtils.getClientWorld();
        if (level == null) {
            CoFHCore.LOG.error("Client world is null! (Is this being called on the server?)");
            return;
        }
        BlockState state = level.m_8055_(this.pos);
        BlockEntity tile = level.m_7702_(this.pos);
        if (tile != null) {
            tile.requestModelDataUpdate();
        }
        level.m_7260_(this.pos, state, state, 3);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130064_(this.pos);
    }

    @Override
    public void read(FriendlyByteBuf buf) {
        this.pos = buf.m_130135_();
    }

    public static void sendToClient(Level level, BlockPos pos) {
        if (level == null || Utils.isClientWorld(level)) {
            return;
        }
        ModelUpdatePacket packet = new ModelUpdatePacket();
        packet.pos = pos;
        packet.sendToAllAround(packet.pos, 192.0, (ResourceKey<Level>)level.m_46472_());
    }
}

