/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.event;

import cofh.core.config.CoreClientConfig;
import cofh.lib.client.renderer.entity.ITranslucentRenderer;
import cofh.lib.util.Utils;
import cofh.lib.util.constants.Constants;
import cofh.lib.util.helpers.StringHelper;
import cofh.lib.util.raytracer.VoxelShapeBlockHitResult;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.datafixers.util.Either;
import com.mojang.math.Matrix4f;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Camera;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawSelectionEvent;
import net.minecraftforge.client.event.RenderLevelLastEvent;
import net.minecraftforge.client.event.RenderTooltipEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="cofh_core")
public class CoreClientEvents {
    public static int renderTime;
    public static float renderFrame;
    private static final Set<String> NAMESPACES;

    private CoreClientEvents() {
    }

    @SubscribeEvent
    public static void handleItemTooltipEvent(ItemTooltipEvent event) {
        String enchKey;
        Enchantment ench;
        ListTag list;
        String infoKey;
        Object e;
        String keywordKey;
        List tooltip = event.getToolTip();
        if (tooltip.isEmpty()) {
            return;
        }
        ItemStack stack = event.getItemStack();
        if (CoreClientConfig.enableKeywords && NAMESPACES.contains(Utils.getItemNamespace(stack.m_41720_())) && StringHelper.canLocalize(keywordKey = stack.m_41778_() + ".keyword") && (e = tooltip.get(0)) instanceof MutableComponent) {
            MutableComponent mutable = (MutableComponent)e;
            mutable.m_7220_((Component)StringHelper.getKeywordTextComponent(keywordKey));
        }
        if (CoreClientConfig.enableItemDescriptions && NAMESPACES.contains(Utils.getItemNamespace(stack.m_41720_())) && StringHelper.canLocalize(infoKey = stack.m_41778_() + ".desc")) {
            tooltip.add(1, StringHelper.getInfoTextComponent(infoKey));
        }
        if (CoreClientConfig.enableEnchantmentDescriptions && stack.m_41783_() != null && (list = stack.m_41783_().m_128437_("StoredEnchantments", 10)).size() == 1 && (ench = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.m_135820_((String)list.m_128728_(0).m_128461_("id")))) != null && ench.getRegistryName() != null && StringHelper.canLocalize(enchKey = ench.m_44704_() + ".desc")) {
            tooltip.add(StringHelper.getInfoTextComponent(enchKey));
        }
        if (CoreClientConfig.enableItemTags && event.getFlags().m_7050_()) {
            Item item = event.getItemStack().m_41720_();
            Block block = Block.m_49814_((Item)item);
            Set blockTags = block == Blocks.f_50016_ ? Collections.emptySet() : Block.m_49814_((Item)item).m_204297_().m_203616_().map(TagKey::f_203868_).collect(Collectors.toSet());
            Set itemTags = item.m_204114_().m_203616_().map(TagKey::f_203868_).collect(Collectors.toSet());
            if (!blockTags.isEmpty() || !itemTags.isEmpty()) {
                if (Screen.m_96637_()) {
                    if (!blockTags.isEmpty()) {
                        tooltip.add(StringHelper.getTextComponent("info.cofh.block_tags").m_130940_(ChatFormatting.GRAY));
                        blockTags.stream().map(Object::toString).map(s -> "  " + s).map(t -> StringHelper.getTextComponent(t).m_130940_(ChatFormatting.DARK_GRAY)).forEach(tooltip::add);
                    }
                    if (!itemTags.isEmpty()) {
                        tooltip.add(StringHelper.getTextComponent("info.cofh.item_tags").m_130940_(ChatFormatting.GRAY));
                        itemTags.stream().map(Object::toString).map(s -> "  " + s).map(t -> StringHelper.getTextComponent(t).m_130940_(ChatFormatting.DARK_GRAY)).forEach(tooltip::add);
                    }
                } else {
                    tooltip.add(StringHelper.getTextComponent("info.cofh.hold_ctrl_for_tags").m_130940_(ChatFormatting.GRAY));
                }
            }
        }
    }

    @SubscribeEvent
    public static void handleRenderTooltipEvent(RenderTooltipEvent.GatherComponents event) {
        if (event.getTooltipElements().isEmpty()) {
            return;
        }
        ((Either)event.getTooltipElements().get(0)).left().ifPresent(text -> {
            if (text instanceof MutableComponent) {
                MutableComponent mutable = (MutableComponent)text;
                mutable.m_7360_().removeIf(string -> string.m_7383_().equals((Object)Constants.INVIS_STYLE));
            }
        });
    }

    @SubscribeEvent
    public static void clientTick(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.END) {
            ++renderTime;
        }
    }

    @SubscribeEvent
    public static void renderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            renderFrame = event.renderTickTime;
        }
    }

    @SubscribeEvent
    public static void renderTranslucentEntities(RenderLevelLastEvent event) {
        ITranslucentRenderer.renderTranslucent(event.getPoseStack(), event.getPartialTick(), event.getLevelRenderer(), event.getProjectionMatrix());
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    public static void renderSubHitboxes(DrawSelectionEvent.HighlightBlock event) {
        BlockHitResult hit = event.getTarget();
        if (hit instanceof VoxelShapeBlockHitResult) {
            VoxelShapeBlockHitResult voxelHit = (VoxelShapeBlockHitResult)hit;
            PoseStack stack = event.getPoseStack();
            BlockPos pos = voxelHit.m_82425_();
            event.setCanceled(true);
            stack.m_85836_();
            stack.m_85837_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
            CoreClientEvents.bufferShapeHitBox(stack, event.getMultiBufferSource(), event.getCamera(), voxelHit.shape);
            stack.m_85849_();
        }
    }

    private static void bufferShapeHitBox(PoseStack pStack, MultiBufferSource buffers, Camera renderInfo, VoxelShape shape) {
        Vec3 eye = renderInfo.m_90583_();
        pStack.m_85837_((double)((float)(-eye.f_82479_)), (double)((float)(-eye.f_82480_)), (double)((float)(-eye.f_82481_)));
        CoreClientEvents.bufferShapeOutline(buffers.m_6299_(RenderType.m_110504_()), pStack.m_85850_().m_85861_(), shape, 0.0f, 0.0f, 0.0f, 0.4f);
    }

    private static void bufferShapeOutline(VertexConsumer builder, Matrix4f mat, VoxelShape shape, float r, float g, float b, float a) {
        shape.m_83224_((x1, y1, z1, x2, y2, z2) -> {
            builder.m_85982_(mat, (float)x1, (float)y1, (float)z1).m_85950_(r, g, b, a).m_5752_();
            builder.m_85982_(mat, (float)x2, (float)y2, (float)z2).m_85950_(r, g, b, a).m_5752_();
        });
    }

    static {
        NAMESPACES = new ObjectOpenHashSet();
        NAMESPACES.add("cofh_core");
        NAMESPACES.add("archers_paradox");
        NAMESPACES.add("ensorcellation");
        NAMESPACES.add("redstone_arsenal");
        NAMESPACES.add("thermal");
    }
}

