/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.client.gui.element;

import cofh.core.client.gui.element.ITooltipFactory;
import cofh.lib.client.gui.IGuiAccess;
import cofh.lib.util.constants.Constants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.function.IntSupplier;
import net.minecraft.client.gui.Font;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public abstract class ElementBase {
    protected ITooltipFactory tooltip = ITooltipFactory.EMPTY;
    protected BooleanSupplier enabled = Constants.TRUE;
    protected BooleanSupplier visible = Constants.TRUE;
    protected final IGuiAccess gui;
    protected ResourceLocation texture;
    protected String name = "";
    private int posX;
    private int posY;
    private IntSupplier offsetX = () -> 0;
    private IntSupplier offsetY = () -> 0;
    protected int width;
    protected int height;
    protected int texW = 256;
    protected int texH = 256;

    public ElementBase(IGuiAccess gui) {
        this.gui = gui;
    }

    public ElementBase(IGuiAccess gui, int posX, int posY) {
        this.gui = gui;
        this.posX = posX;
        this.posY = posY;
    }

    public ElementBase(IGuiAccess gui, int posX, int posY, int width, int height) {
        this.gui = gui;
        this.posX = posX;
        this.posY = posY;
        this.width = width;
        this.height = height;
    }

    public void drawBackground(PoseStack matrixStack, int mouseX, int mouseY) {
    }

    public void drawForeground(PoseStack matrixStack, int mouseX, int mouseY) {
    }

    public void addTooltip(List<Component> tooltipList, int mouseX, int mouseY) {
        tooltipList.addAll(this.tooltip.create(this, mouseX, mouseY));
    }

    public void update(int mouseX, int mouseY) {
    }

    public boolean intersectsWith(double mouseX, double mouseY) {
        return mouseX >= (double)this.posX && mouseX < (double)(this.posX + this.width) && mouseY >= (double)this.posY && mouseY < (double)(this.posY + this.height);
    }

    public final ElementBase setEnabled(BooleanSupplier enabled) {
        this.enabled = enabled;
        return this;
    }

    public final ElementBase setVisible(BooleanSupplier visible) {
        this.visible = visible;
        return this;
    }

    public final ElementBase setTooltipFactory(ITooltipFactory tooltip) {
        this.tooltip = tooltip;
        return this;
    }

    public ElementBase setPosition(int posX, int posY) {
        this.posX = posX;
        this.posY = posY;
        return this;
    }

    public ElementBase setOffsets(IntSupplier offsetX, IntSupplier offsetY) {
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        return this;
    }

    public final ElementBase setSize(int width, int height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public final ElementBase setTexture(String texture, int texW, int texH) {
        this.texture = new ResourceLocation(texture);
        this.texW = texW;
        this.texH = texH;
        return this;
    }

    public final ElementBase setName(String name) {
        this.name = name;
        return this;
    }

    public final boolean enabled() {
        return this.enabled.getAsBoolean();
    }

    public final boolean visible() {
        return this.visible.getAsBoolean();
    }

    public final String name() {
        return this.name;
    }

    protected int posX() {
        return this.posX;
    }

    protected int offsetX() {
        return this.offsetX.getAsInt();
    }

    protected int posY() {
        return this.posY;
    }

    protected int offsetY() {
        return this.offsetY.getAsInt();
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }

    public final int guiTop() {
        return this.gui.getGuiTop();
    }

    public final int guiLeft() {
        return this.gui.getGuiLeft();
    }

    public void drawSizedRect(PoseStack poseStack, int x, int y, int width, int height, int color) {
        this.gui.drawSizedRect(poseStack, x, y, width, height, color);
    }

    public void drawColoredModalRect(PoseStack poseStack, int x, int y, int width, int height, int color) {
        this.gui.drawColoredModalRect(poseStack, x, y, width, height, color);
    }

    public void drawTexturedModalRect(PoseStack poseStack, int x, int y, int u, int v, int width, int height) {
        this.gui.drawTexturedModalRect(poseStack, x, y, u, v, width, height, this.texW, this.texH);
    }

    public Font getFontRenderer() {
        return this.gui.getFontRenderer();
    }

    public boolean keyTyped(int p_keyPressed_1_, int p_keyPressed_2_, int p_keyPressed_3_) {
        return false;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int mouseButton) {
        return false;
    }

    public void mouseReleased(double mouseX, double mouseY) {
    }

    public boolean mouseWheel(double mouseX, double mouseY, double movement) {
        return false;
    }
}

