/*
 * Decompiled with CFR 0.152.
 */
package cofh.core.block;

import cofh.core.block.entity.TileCoFH;
import cofh.core.util.helpers.ChatHelper;
import cofh.lib.block.IDismantleable;
import cofh.lib.block.entity.ICoFHTickableTile;
import cofh.lib.block.entity.ITileCallback;
import cofh.lib.item.IPlacementItem;
import cofh.lib.util.RayTracer;
import cofh.lib.util.Utils;
import cofh.lib.util.helpers.SecurityHelper;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.Nullable;

public class TileBlockCoFH
extends Block
implements EntityBlock,
IDismantleable {
    protected final Supplier<BlockEntityType<? extends TileCoFH>> blockEntityType;
    protected final Class<? extends TileCoFH> tileClass;

    public TileBlockCoFH(BlockBehaviour.Properties builder, Class<? extends TileCoFH> tileClass, Supplier<BlockEntityType<? extends TileCoFH>> blockEntityType) {
        super(builder);
        this.blockEntityType = blockEntityType;
        this.tileClass = tileClass;
    }

    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return this.blockEntityType.get().m_155264_(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> actualType) {
        return ICoFHTickableTile.createTicker(level, actualType, this.blockEntityType.get(), this.tileClass);
    }

    public InteractionResult m_6227_(BlockState state, Level worldIn, BlockPos pos, Player player, InteractionHand handIn, BlockHitResult hit) {
        if (Utils.isClientWorld(worldIn)) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity tile = worldIn.m_7702_(pos);
        if (!(tile instanceof TileCoFH) || tile.m_58901_()) {
            return InteractionResult.PASS;
        }
        if (!((TileCoFH)tile).canPlayerChange(player) && SecurityHelper.hasSecurity(tile)) {
            ChatHelper.sendIndexedChatMessageToPlayer(player, (Component)new TranslatableComponent("info.cofh.secure_warning", new Object[]{SecurityHelper.getOwnerName(tile)}));
            return InteractionResult.PASS;
        }
        if (Utils.isWrench(player.m_21120_(handIn))) {
            if (player.m_36341_()) {
                if (this.canDismantle(worldIn, pos, state, player)) {
                    this.dismantleBlock(worldIn, pos, state, (HitResult)hit, player, false);
                    return InteractionResult.SUCCESS;
                }
            } else {
                BlockState rotState = this.rotate(state, (LevelAccessor)worldIn, pos, Rotation.CLOCKWISE_90);
                if (rotState != state) {
                    worldIn.m_46597_(pos, rotState);
                    return InteractionResult.SUCCESS;
                }
            }
        }
        if (this.onBlockActivatedDelegate(worldIn, pos, state, player, handIn, hit)) {
            return InteractionResult.SUCCESS;
        }
        if (((TileCoFH)tile).canOpenGui()) {
            NetworkHooks.openGui((ServerPlayer)((ServerPlayer)player), (MenuProvider)((MenuProvider)tile), (BlockPos)tile.m_58899_());
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected boolean onBlockActivatedDelegate(Level world, BlockPos pos, BlockState state, Player player, InteractionHand hand, BlockHitResult result) {
        TileCoFH tile = (TileCoFH)world.m_7702_(pos);
        if (tile == null || !tile.canPlayerChange(player)) {
            return false;
        }
        return tile.onActivatedDelegate(world, pos, state, player, hand, result);
    }

    public void m_6861_(BlockState state, Level worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        TileCoFH tile = (TileCoFH)worldIn.m_7702_(pos);
        if (tile != null) {
            tile.neighborChanged(blockIn, fromPos);
        }
        super.m_6861_(state, worldIn, pos, blockIn, fromPos, isMoving);
    }

    public void m_6402_(Level worldIn, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        TileCoFH tile;
        Player player;
        block6: {
            block5: {
                if (!(placer instanceof Player)) break block5;
                player = (Player)placer;
                if (!Utils.isClientWorld(worldIn)) break block6;
            }
            return;
        }
        ItemStack offhand = placer.m_21206_();
        if (!offhand.m_41619_() && offhand.m_41720_() instanceof IPlacementItem) {
            ((IPlacementItem)offhand.m_41720_()).onBlockPlacement(offhand, new UseOnContext(player, InteractionHand.OFF_HAND, RayTracer.retrace(player)));
        }
        if ((tile = (TileCoFH)worldIn.m_7702_(pos)) != null) {
            tile.onPlacedBy(worldIn, pos, state, placer, stack);
        }
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.m_60734_() != newState.m_60734_()) {
            BlockEntity tile = worldIn.m_7702_(pos);
            if (tile instanceof TileCoFH) {
                ((TileCoFH)tile).onReplaced(state, worldIn, pos, newState);
            }
            super.m_6810_(state, worldIn, pos, newState, isMoving);
        }
    }

    public int m_6782_(BlockState blockState, Level worldIn, BlockPos pos) {
        BlockEntity tile = worldIn.m_7702_(pos);
        return tile instanceof ITileCallback ? ((ITileCallback)tile).getComparatorInputOverride() : super.m_6782_(blockState, worldIn, pos);
    }

    public float m_5880_(BlockState state, Player player, BlockGetter worldIn, BlockPos pos) {
        BlockEntity tile = worldIn.m_7702_(pos);
        if (tile instanceof TileCoFH && !tile.m_58901_() && !((TileCoFH)tile).canPlayerChange(player)) {
            return -1.0f;
        }
        return super.m_5880_(state, player, worldIn, pos);
    }

    public ItemStack m_7397_(BlockGetter worldIn, BlockPos pos, BlockState state) {
        ItemStack stack = super.m_7397_(worldIn, pos, state);
        BlockEntity tile = worldIn.m_7702_(pos);
        if (tile instanceof ITileCallback) {
            ((ITileCallback)tile).createItemStackTag(stack);
        }
        return stack;
    }

    @Override
    public boolean canDismantle(Level world, BlockPos pos, BlockState state, Player player) {
        BlockEntity blockEntity = world.m_7702_(pos);
        if (blockEntity instanceof TileCoFH) {
            TileCoFH tile = (TileCoFH)blockEntity;
            return tile.canPlayerChange(player);
        }
        return false;
    }
}

