/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.encoding;

import appeng.api.crafting.IPatternDetails;
import appeng.api.crafting.PatternDetailsHelper;
import appeng.api.inventories.InternalInventory;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.GenericStack;
import appeng.core.definitions.AEItems;
import appeng.crafting.pattern.AECraftingPattern;
import appeng.crafting.pattern.AEProcessingPattern;
import appeng.crafting.pattern.IAEPatternDetails;
import appeng.helpers.IPatternTerminalLogicHost;
import appeng.parts.encoding.EncodingMode;
import appeng.util.ConfigInventory;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.filter.AEItemDefinitionFilter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;

public class PatternEncodingLogic
implements InternalInventoryHost {
    private final IPatternTerminalLogicHost host;
    private static final int MAX_INPUT_SLOTS = Math.max(9, 18);
    private static final int MAX_OUTPUT_SLOTS = 6;
    private final ConfigInventory encodedInputInv = ConfigInventory.configStacks(null, MAX_INPUT_SLOTS, this::onEncodedInputChanged, true);
    private final ConfigInventory encodedOutputInv = ConfigInventory.configStacks(null, 6, this::onEncodedOutputChanged, true);
    private final AppEngInternalInventory blankPatternInv = new AppEngInternalInventory(this, 1);
    private final AppEngInternalInventory encodedPatternInv = new AppEngInternalInventory(this, 1);
    private EncodingMode mode = EncodingMode.CRAFTING;
    private boolean substitute = false;
    private boolean substituteFluids = true;
    private boolean isLoading = false;

    public PatternEncodingLogic(IPatternTerminalLogicHost host) {
        this.host = host;
        this.blankPatternInv.setFilter(new AEItemDefinitionFilter(AEItems.BLANK_PATTERN));
    }

    @Override
    public void onChangeInventory(InternalInventory inv, int slot) {
        if (inv == this.encodedPatternInv) {
            this.loadEncodedPattern(this.encodedPatternInv.getStackInSlot(0));
        }
        this.saveChanges();
    }

    @Override
    public void saveChanges() {
        if (!this.isLoading) {
            this.host.markForSave();
        }
    }

    @Override
    public boolean isClientSide() {
        return this.host.getLevel().m_5776_();
    }

    private void onEncodedInputChanged() {
        this.fixCraftingRecipes();
        this.saveChanges();
    }

    private void onEncodedOutputChanged() {
        this.saveChanges();
    }

    private void loadEncodedPattern(ItemStack pattern) {
        if (pattern.m_41619_()) {
            return;
        }
        IPatternDetails details = PatternDetailsHelper.decodePattern(pattern, this.host.getLevel());
        if (details instanceof AECraftingPattern) {
            this.setMode(EncodingMode.CRAFTING);
        } else if (details instanceof AEProcessingPattern) {
            this.setMode(EncodingMode.PROCESSING);
        }
        if (details instanceof IAEPatternDetails) {
            IAEPatternDetails aeDetails = (IAEPatternDetails)details;
            this.setSubstitution(aeDetails.canSubstitute());
            this.setFluidSubstitution(aeDetails.canSubstituteFluids());
            PatternEncodingLogic.fillInventoryFromSparseStacks(this.encodedInputInv, aeDetails.getSparseInputs());
            PatternEncodingLogic.fillInventoryFromSparseStacks(this.encodedOutputInv, aeDetails.getSparseOutputs());
        }
    }

    private static void fillInventoryFromSparseStacks(ConfigInventory inv, GenericStack[] stacks) {
        inv.beginBatch();
        try {
            for (int i = 0; i < inv.size(); ++i) {
                inv.setStack(i, i < stacks.length ? stacks[i] : null);
            }
        }
        finally {
            inv.endBatch();
        }
    }

    public EncodingMode getMode() {
        return this.mode;
    }

    public void setMode(EncodingMode mode) {
        this.mode = mode;
        this.fixCraftingRecipes();
        this.saveChanges();
    }

    public boolean isSubstitution() {
        return this.substitute;
    }

    public void setSubstitution(boolean canSubstitute) {
        this.substitute = canSubstitute;
        this.saveChanges();
    }

    public boolean isFluidSubstitution() {
        return this.substituteFluids;
    }

    public void setFluidSubstitution(boolean canSubstitute) {
        this.substituteFluids = canSubstitute;
        this.saveChanges();
    }

    public ConfigInventory getEncodedInputInv() {
        return this.encodedInputInv;
    }

    public ConfigInventory getEncodedOutputInv() {
        return this.encodedOutputInv;
    }

    public InternalInventory getBlankPatternInv() {
        return this.blankPatternInv;
    }

    public InternalInventory getEncodedPatternInv() {
        return this.encodedPatternInv;
    }

    public void readFromNBT(CompoundTag data) {
        this.isLoading = true;
        try {
            try {
                this.mode = EncodingMode.valueOf(data.m_128461_("mode"));
            }
            catch (IllegalArgumentException ignored) {
                this.mode = EncodingMode.CRAFTING;
            }
            this.setSubstitution(data.m_128471_("substitute"));
            this.setFluidSubstitution(data.m_128471_("substituteFluids"));
            if (data.m_128441_("pattern")) {
                AppEngInternalInventory pattern = new AppEngInternalInventory(null, 2);
                pattern.readFromNBT(data, "pattern");
            } else {
                this.blankPatternInv.readFromNBT(data, "blankPattern");
                this.encodedPatternInv.readFromNBT(data, "encodedPattern");
            }
            this.encodedInputInv.readFromChildTag(data, "encodedInputs");
            this.encodedOutputInv.readFromChildTag(data, "encodedOutputs");
        }
        finally {
            this.isLoading = false;
        }
    }

    public void writeToNBT(CompoundTag data) {
        data.m_128359_("mode", this.mode.name());
        data.m_128379_("substitute", this.substitute);
        data.m_128379_("substituteFluids", this.substituteFluids);
        this.blankPatternInv.writeToNBT(data, "blankPattern");
        this.encodedPatternInv.writeToNBT(data, "encodedPattern");
        this.encodedInputInv.writeToChildTag(data, "encodedInputs");
        this.encodedOutputInv.writeToChildTag(data, "encodedOutputs");
    }

    private void fixCraftingRecipes() {
        if (this.host.getLevel() == null || this.host.getLevel().m_5776_()) {
            return;
        }
        if (this.getMode() == EncodingMode.CRAFTING) {
            ConfigInventory craftingGrid = this.getEncodedInputInv();
            for (int slot = 0; slot < craftingGrid.size(); ++slot) {
                GenericStack stack = craftingGrid.getStack(slot);
                if (stack == null) continue;
                if (!AEItemKey.is(stack.what())) {
                    craftingGrid.setStack(slot, null);
                    continue;
                }
                if (stack.amount() == 1L) continue;
                craftingGrid.setStack(slot, new GenericStack(stack.what(), 1L));
            }
        }
    }
}

