/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.client.render.BasicUnbakedModel;
import appeng.parts.automation.PlaneBakedModel;
import java.util.function.Function;
import java.util.stream.Stream;
import net.minecraft.client.renderer.block.model.ItemOverrides;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBakery;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.client.model.IModelConfiguration;

public class PlaneModel
implements BasicUnbakedModel<PlaneModel> {
    private final Material frontTexture;
    private final Material sidesTexture;
    private final Material backTexture;

    public PlaneModel(ResourceLocation frontTexture, ResourceLocation sidesTexture, ResourceLocation backTexture) {
        this.frontTexture = new Material(TextureAtlas.f_118259_, frontTexture);
        this.sidesTexture = new Material(TextureAtlas.f_118259_, sidesTexture);
        this.backTexture = new Material(TextureAtlas.f_118259_, backTexture);
    }

    public BakedModel bake(IModelConfiguration owner, ModelBakery bakery, Function<Material, TextureAtlasSprite> spriteGetter, ModelState modelTransform, ItemOverrides overrides, ResourceLocation modelLocation) {
        TextureAtlasSprite frontSprite = spriteGetter.apply(this.frontTexture);
        TextureAtlasSprite sidesSprite = spriteGetter.apply(this.sidesTexture);
        TextureAtlasSprite backSprite = spriteGetter.apply(this.backTexture);
        return new PlaneBakedModel(frontSprite, sidesSprite, backSprite);
    }

    @Override
    public Stream<Material> getAdditionalTextures() {
        return Stream.of(this.frontTexture, this.sidesTexture, this.backTexture);
    }
}

