/*
 * Decompiled with CFR 0.152.
 */
package appeng.parts.automation;

import appeng.api.behaviors.PickupStrategy;
import appeng.api.config.Actionable;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEKey;
import appeng.api.storage.StorageHelper;
import appeng.api.util.AECableType;
import appeng.core.settings.TickRates;
import appeng.items.parts.PartModels;
import appeng.me.helpers.MachineSource;
import appeng.parts.BasicStatePart;
import appeng.parts.automation.PlaneConnectionHelper;
import appeng.parts.automation.PlaneConnections;
import appeng.parts.automation.PlaneModelData;
import appeng.parts.automation.PlaneModels;
import appeng.parts.automation.StackWorldBehaviors;
import appeng.util.EnchantmentUtil;
import appeng.util.SettingsFrom;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.client.model.data.IModelData;

public class AnnihilationPlanePart
extends BasicStatePart
implements IGridTickable {
    private static final PlaneModels MODELS = new PlaneModels("part/annihilation_plane", "part/annihilation_plane_on");
    private final IActionSource actionSource = new MachineSource(this);
    private final PlaneConnectionHelper connectionHelper = new PlaneConnectionHelper(this);
    @Nullable
    protected List<PickupStrategy> pickupStrategies;
    private PickupStrategy pendingPickupStrategy;
    @Nullable
    private Map<Enchantment, Integer> enchantments;

    @PartModels
    public static List<IPartModel> getModels() {
        return MODELS.getModels();
    }

    public AnnihilationPlanePart(IPartItem<?> partItem) {
        super(partItem);
        this.getMainNode().addService(IGridTickable.class, this);
    }

    @Override
    public void readFromNBT(CompoundTag data) {
        super.readFromNBT(data);
        this.readEnchantments(data);
    }

    @Override
    public void writeToNBT(CompoundTag data) {
        super.writeToNBT(data);
        this.writeEnchantments(data);
    }

    @Override
    public void importSettings(SettingsFrom mode, CompoundTag data, @Nullable Player player) {
        super.importSettings(mode, data, player);
        if (mode == SettingsFrom.DISMANTLE_ITEM) {
            this.readEnchantments(data);
        }
        this.pickupStrategies = null;
    }

    @Override
    public void exportSettings(SettingsFrom mode, CompoundTag data) {
        super.exportSettings(mode, data);
        if (mode == SettingsFrom.DISMANTLE_ITEM) {
            this.writeEnchantments(data);
        }
    }

    private void readEnchantments(CompoundTag data) {
        this.enchantments = EnchantmentUtil.getEnchantments(data);
    }

    private void writeEnchantments(CompoundTag data) {
        if (this.enchantments != null) {
            EnchantmentUtil.setEnchantments(data, this.enchantments);
        }
    }

    @Nullable
    public Map<Enchantment, Integer> getEnchantments() {
        return this.enchantments;
    }

    protected List<PickupStrategy> getPickupStrategies() {
        if (this.pickupStrategies == null) {
            BlockEntity self = this.getHost().getBlockEntity();
            BlockPos pos = self.m_58899_().m_142300_(this.getSide());
            Direction side = this.getSide().m_122424_();
            this.pickupStrategies = StackWorldBehaviors.createPickupStrategies((ServerLevel)self.m_58904_(), pos, side, self, this.enchantments);
        }
        return this.pickupStrategies;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        if (bch.isBBCollision()) {
            bch.addBox(0.0, 0.0, 14.0, 16.0, 16.0, 15.5);
            return;
        }
        this.connectionHelper.getBoxes(bch);
    }

    public PlaneConnections getConnections() {
        return this.connectionHelper.getConnections();
    }

    @Override
    public void onNeighborChanged(BlockGetter level, BlockPos pos, BlockPos neighbor) {
        if (pos.m_142300_(this.getSide()).equals((Object)neighbor)) {
            if (!this.isClientSide()) {
                this.refresh();
            }
        } else {
            this.connectionHelper.updateConnections();
        }
    }

    @Override
    public void onEntityCollision(Entity entity) {
        boolean capture;
        if (!entity.m_6084_() || this.isClientSide() || !this.getMainNode().isActive()) {
            return;
        }
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null) {
            return;
        }
        PickupStrategy strategy = null;
        for (PickupStrategy pickupStrategy : this.getPickupStrategies()) {
            if (!pickupStrategy.canPickUpEntity(entity)) continue;
            strategy = pickupStrategy;
            break;
        }
        if (strategy == null) {
            return;
        }
        BlockPos pos = this.getHost().getBlockEntity().m_58899_();
        int planePosX = pos.m_123341_();
        int planePosY = pos.m_123342_();
        int planePosZ = pos.m_123343_();
        double posYMiddle = (entity.m_142469_().f_82289_ + entity.m_142469_().f_82292_) / 2.0;
        double entityPosX = entity.m_20185_();
        double entityPosY = entity.m_20186_();
        double entityPosZ = entity.m_20189_();
        boolean captureX = entityPosX > (double)planePosX && entityPosX < (double)(planePosX + 1);
        boolean captureY = posYMiddle > (double)planePosY && posYMiddle < (double)(planePosY + 1);
        boolean captureZ = entityPosZ > (double)planePosZ && entityPosZ < (double)(planePosZ + 1);
        switch (this.getSide()) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case DOWN: {
                boolean bl;
                if (captureX && captureZ && entityPosY < (double)planePosY + 0.1) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case UP: {
                boolean bl;
                if (captureX && captureZ && entityPosY > (double)planePosY + 0.9) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case SOUTH: {
                boolean bl;
                if (captureX && captureY && entityPosZ > (double)planePosZ + 0.9) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case NORTH: {
                boolean bl;
                if (captureX && captureY && entityPosZ < (double)planePosZ + 0.1) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case EAST: {
                boolean bl;
                if (captureZ && captureY && entityPosX > (double)planePosX + 0.9) {
                    bl = true;
                    break;
                }
                bl = false;
                break;
            }
            case WEST: {
                boolean bl = capture = captureZ && captureY && entityPosX < (double)planePosX + 0.1;
            }
        }
        if (capture && !strategy.pickUpEntity(grid.getEnergyService(), this::insertIntoGrid, entity)) {
            this.getMainNode().ifPresent((g, n) -> g.getTickManager().alertDevice((IGridNode)n));
        }
    }

    @Override
    public float getCableConnectionLength(AECableType cable) {
        return 1.0f;
    }

    @Override
    protected void onMainNodeStateChanged(IGridNodeListener.State reason) {
        super.onMainNodeStateChanged(reason);
        if (this.getMainNode().hasGridBooted()) {
            this.refresh();
        }
    }

    @Override
    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.AnnihilationPlane, false, true);
    }

    @Override
    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        IGrid grid = node.getGrid();
        if (this.pendingPickupStrategy != null) {
            this.pendingPickupStrategy.completePickup(grid.getEnergyService(), this::insertIntoGrid);
            this.pendingPickupStrategy = null;
        }
        for (PickupStrategy pickupStrategy : this.getPickupStrategies()) {
            pickupStrategy.reset();
        }
        for (PickupStrategy pickupStrategy : this.getPickupStrategies()) {
            PickupStrategy.Result pickupResult = pickupStrategy.tryStartPickup(grid.getEnergyService(), this::insertIntoGrid);
            if (pickupResult == PickupStrategy.Result.PICKED_UP) {
                this.pendingPickupStrategy = pickupStrategy;
                return TickRateModulation.URGENT;
            }
            if (pickupResult != PickupStrategy.Result.CANT_STORE) continue;
            return TickRateModulation.IDLE;
        }
        return TickRateModulation.SLEEP;
    }

    private void refresh() {
        for (PickupStrategy pickupStrategy : this.getPickupStrategies()) {
            pickupStrategy.reset();
        }
        this.getMainNode().ifPresent((g, n) -> g.getTickManager().alertDevice((IGridNode)n));
    }

    private long insertIntoGrid(AEKey what, long amount, Actionable mode) {
        IGrid grid = this.getMainNode().getGrid();
        if (grid == null) {
            return 0L;
        }
        return StorageHelper.poweredInsert(grid.getEnergyService(), grid.getStorageService().getInventory(), what, amount, this.actionSource, mode);
    }

    @Override
    public IPartModel getStaticModels() {
        return MODELS.getModel(this.isPowered(), this.isActive());
    }

    @Override
    public IModelData getModelData() {
        return new PlaneModelData(this.getConnections());
    }
}

