/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.waila.tile;

import appeng.api.parts.IPart;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.parts.SelectedPart;
import appeng.block.networking.CableBusBlock;
import appeng.blockentity.networking.CableBusBlockEntity;
import appeng.integration.modules.waila.part.AnnihilationPlaneDataProvider;
import appeng.integration.modules.waila.part.ChannelDataProvider;
import appeng.integration.modules.waila.part.GridNodeStateProvider;
import appeng.integration.modules.waila.part.IPartDataProvider;
import appeng.integration.modules.waila.part.P2PStateDataProvider;
import appeng.integration.modules.waila.part.StorageMonitorDataProvider;
import appeng.integration.modules.waila.tile.DebugDataProvider;
import appeng.util.Platform;
import java.util.List;
import javax.annotation.Nullable;
import mcp.mobius.waila.api.BlockAccessor;
import mcp.mobius.waila.api.IComponentProvider;
import mcp.mobius.waila.api.IRegistrar;
import mcp.mobius.waila.api.IServerDataProvider;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.TooltipPosition;
import mcp.mobius.waila.api.config.IPluginConfig;
import mcp.mobius.waila.api.ui.IElement;
import mcp.mobius.waila.api.ui.IElementHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;

public final class CableBusDataProvider {
    private static final List<IPartDataProvider> PROVIDERS = List.of(new ChannelDataProvider(), new StorageMonitorDataProvider(), new AnnihilationPlaneDataProvider(), new GridNodeStateProvider(), new P2PStateDataProvider(), new DebugDataProvider());
    private static IElementHelper elementHelper;

    private CableBusDataProvider() {
    }

    public static void register(IRegistrar registrar) {
        elementHelper = registrar.getElementHelper();
        registrar.registerIconProvider((IComponentProvider)new IconProvider(), CableBusBlock.class);
        registrar.registerComponentProvider((IComponentProvider)new NameProvider(), TooltipPosition.HEAD, CableBusBlock.class);
        registrar.registerComponentProvider((IComponentProvider)new TooltipAdapter(IPartDataProvider::appendBodyTooltip), TooltipPosition.BODY, CableBusBlock.class);
        registrar.registerBlockDataProvider((IServerDataProvider)new ServerDataAdapter(), CableBusBlockEntity.class);
    }

    private static String getPartDataName(@Nullable Direction location) {
        return "cableBusPart" + (location == null ? "center" : location.name());
    }

    private static SelectedPart getPart(BlockEntity blockEntity, HitResult hitResult) {
        if (blockEntity instanceof IPartHost) {
            IPartHost host = (IPartHost)blockEntity;
            return host.selectPartWorld(hitResult.m_82450_());
        }
        return new SelectedPart();
    }

    private static class IconProvider
    implements IComponentProvider {
        private IconProvider() {
        }

        @Nullable
        public IElement getIcon(BlockAccessor accessor, IPluginConfig config, IElement currentIcon) {
            BlockEntity blockEntity = accessor.getBlockEntity();
            BlockHitResult hitResult = (BlockHitResult)accessor.getHitResult();
            SelectedPart selected = CableBusDataProvider.getPart(blockEntity, (HitResult)hitResult);
            if (selected.facade != null) {
                return elementHelper.item(selected.facade.getItemStack());
            }
            if (selected.part != null) {
                IPartItem<?> item = selected.part.getPartItem();
                return elementHelper.item(new ItemStack(item));
            }
            return currentIcon;
        }

        public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        }
    }

    private static class NameProvider
    implements IComponentProvider {
        private static final ResourceLocation OBJECT_NAME = new ResourceLocation("waila:object_name");

        private NameProvider() {
        }

        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            BlockEntity blockEntity = accessor.getBlockEntity();
            BlockHitResult hitResult = (BlockHitResult)accessor.getHitResult();
            SelectedPart selected = CableBusDataProvider.getPart(blockEntity, (HitResult)hitResult);
            Component name = null;
            if (selected.facade != null) {
                name = selected.facade.getItemStack().m_41786_();
            } else if (selected.part != null) {
                name = selected.part.getPartItem().m_5456_().m_41466_();
            }
            if (name != null) {
                tooltip.remove(OBJECT_NAME);
                tooltip.add((Component)name.m_6881_().m_130938_(style -> {
                    if (style.m_131135_() == null) {
                        return style.m_131140_(ChatFormatting.WHITE);
                    }
                    return style;
                }), OBJECT_NAME);
            }
        }
    }

    private record TooltipAdapter(TooltipAppender appender) implements IComponentProvider
    {
        public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
            SelectedPart selected = CableBusDataProvider.getPart(accessor.getBlockEntity(), accessor.getHitResult());
            if (selected.part != null) {
                CompoundTag partTag = accessor.getServerData().m_128469_(CableBusDataProvider.getPartDataName(selected.side));
                for (IPartDataProvider provider : PROVIDERS) {
                    this.appender.append(provider, selected.part, partTag, tooltip);
                }
            }
        }
    }

    @FunctionalInterface
    static interface TooltipAppender {
        public void append(IPartDataProvider var1, IPart var2, CompoundTag var3, ITooltip var4);
    }

    private static class ServerDataAdapter
    implements IServerDataProvider<BlockEntity> {
        private ServerDataAdapter() {
        }

        public void appendServerData(CompoundTag serverData, ServerPlayer serverPlayer, Level level, BlockEntity blockEntity, boolean showDetails) {
            if (!(blockEntity instanceof CableBusBlockEntity)) {
                return;
            }
            CableBusBlockEntity cableBus = (CableBusBlockEntity)blockEntity;
            CompoundTag partTag = new CompoundTag();
            for (Direction location : Platform.DIRECTIONS_WITH_NULL) {
                IPart part = cableBus.getPart(location);
                if (part == null) continue;
                for (IPartDataProvider provider : PROVIDERS) {
                    provider.appendServerData(serverPlayer, part, partTag);
                }
                if (partTag.m_128456_()) continue;
                serverData.m_128365_(CableBusDataProvider.getPartDataName(location), (Tag)partTag);
                partTag = new CompoundTag();
            }
        }
    }
}

